/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.facet;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.FacetModificationTrackingService;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.hibernate.HibernateInspectionToolProvider;
import com.intellij.hibernate.facet.HibernateFacetConfiguration;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.hibernate.model.xml.config.HibernateConfiguration;
import com.intellij.hibernate.model.xml.config.SessionFactory;
import com.intellij.hibernate.model.xml.mapping.HbmHibernateMapping;
import com.intellij.hibernate.util.HibernateUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeePersistenceDescriptorsConstants;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.common.persistence.mapping.EntityMappings;
import com.intellij.jpa.JpaInspectionToolProvider;
import com.intellij.jpa.facet.JpaFacetImpl;
import com.intellij.jpa.highlighting.HibernateModelValidator;
import com.intellij.jpa.model.annotations.mapping.EntityMappingsImpl;
import com.intellij.jpa.model.common.MergedPersistenceMappings;
import com.intellij.jpa.ql.JpqlLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.LanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileAdapter;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericValueUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateFacet
extends Facet<HibernateFacetConfiguration>
implements PersistenceFacet {
    public static final FacetTypeId<HibernateFacet> ID = new FacetTypeId("hibernate");
    private final ConfigFileContainer myDescriptorsContainer;
    private EntityMappingsImpl myAnnotationsPersistenceRoot;
    private final JpaFacetImpl.UnitDataSourceMap myUnitDataSourceMap;
    private final JpaFacetImpl.UnitSettingMap myUnitNamingStrategyMap;
    private final CachedValue<List<PersistencePackage>> myUnitsValue;
    private static final Key<CachedValue<PersistencePackageDefaults>> SESSION_FACTORY_DEFAULTS = Key.create((String)"SESSION_FACTORY_DEFAULTS");

    @Nullable
    public static HibernateFacet getInstance(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/hibernate/facet/HibernateFacet", "getInstance"));
        }
        return (HibernateFacet)FacetManager.getInstance((Module)module).getFacetByType(ID);
    }

    public HibernateFacet(@NotNull FacetType<HibernateFacet, HibernateFacetConfiguration> facetType, @NotNull Module module, String name, @NotNull HibernateFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetType", "com/intellij/hibernate/facet/HibernateFacet", "<init>"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/hibernate/facet/HibernateFacet", "<init>"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/hibernate/facet/HibernateFacet", "<init>"));
        }
        super(facetType, module, name, (FacetConfiguration)configuration, underlyingFacet);
        this.myUnitDataSourceMap = new JpaFacetImpl.UnitDataSourceMap(configuration.getUnitToDataSourceMap(), (PersistenceFacet)this);
        this.myUnitNamingStrategyMap = new JpaFacetImpl.UnitSettingMap(configuration.getUnitToNamingStrategyMap(), this){

            @Nullable
            protected String getDefaultSettingValue(PersistencePackage unit) {
                return unit.getModelHelper().getPersistenceUnitProperties().getProperty(HibernateUtil.getFullPropertyName("ejb.naming_strategy"));
            }
        };
        this.myDescriptorsContainer = ConfigFileFactory.getInstance().createConfigFileContainer(this.getModule().getProject(), configuration.getDescriptorsConfiguration().getMetaDataProvider(), configuration.getDescriptorsConfiguration());
        this.myDescriptorsContainer.addListener((ConfigFileListener)new ConfigFileAdapter(){

            protected void configChanged(ConfigFile configFile) {
                ((FacetManagerListener)HibernateFacet.this.getModule().getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged((Facet)HibernateFacet.this);
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myDescriptorsContainer);
        this.myUnitsValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<List<PersistencePackage>>(){

            public CachedValueProvider.Result<List<PersistencePackage>> compute() {
                return HibernateFacet.this.getPersistenceUnitsInner();
            }
        }, false);
    }

    @NotNull
    public List<PersistencePackage> getExtensionSessionFactories() {
        List list = ContainerUtil.concat((Object[])Extensions.getExtensions((ExtensionPointName)PersistencePackagesProvider.EP_NAME), (Function)new Function<PersistencePackagesProvider, Collection<? extends PersistencePackage>>(){

            public Collection<PersistencePackage> fun(PersistencePackagesProvider provider) {
                return provider.getPersistencePackages((PersistenceFacet)HibernateFacet.this);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getExtensionSessionFactories"));
        }
        return list;
    }

    @NotNull
    public List<HibernateConfiguration> getHibernateConfigurations() {
        ArrayList<HibernateConfiguration> result = new ArrayList<HibernateConfiguration>();
        for (ConfigFile configFile : this.myDescriptorsContainer.getConfigFiles()) {
            if (configFile.getMetaData() != HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA) continue;
            ContainerUtil.addIfNotNull((Object)JamCommonUtil.getRootElement((PsiFile)configFile.getPsiFile(), HibernateConfiguration.class, (Module)this.getModule()), result);
        }
        ArrayList<HibernateConfiguration> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getHibernateConfigurations"));
        }
        return arrayList;
    }

    public List<HibernateConfiguration> getDefaultHibernateConfigurations() {
        ArrayList<HibernateConfiguration> result = new ArrayList<HibernateConfiguration>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.getModule().getProject());
        for (VirtualFile root : ModuleRootManager.getInstance((Module)this.getModule()).getSourceRoots()) {
            for (VirtualFile child : root.getChildren()) {
                if (child.isDirectory() || !child.getName().endsWith(".cfg.xml")) continue;
                ContainerUtil.addIfNotNull((Object)JamCommonUtil.getRootElement((PsiFile)psiManager.findFile(child), HibernateConfiguration.class, (Module)this.getModule()), result);
            }
        }
        return result;
    }

    public ModificationTracker getModificationTracker() {
        return FacetModificationTrackingService.getInstance((Facet)this).getFacetModificationTracker((Facet)this);
    }

    public ConfigFile[] getDescriptors() {
        return this.myDescriptorsContainer.getConfigFiles();
    }

    public ConfigFileContainer getDescriptorsContainer() {
        return this.myDescriptorsContainer;
    }

    @NotNull
    public List<PersistencePackage> getPersistenceUnits() {
        List list = (List)this.myUnitsValue.getValue();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getPersistenceUnits"));
        }
        return list;
    }

    private CachedValueProvider.Result<List<PersistencePackage>> getPersistenceUnitsInner() {
        ArrayList<PersistencePackage> result = new ArrayList<PersistencePackage>();
        for (HibernateConfiguration configuration : this.getHibernateConfigurations()) {
            result.add(configuration.getSessionFactory());
        }
        result.addAll(this.getExtensionSessionFactories());
        return new CachedValueProvider.Result(result, new Object[]{PsiModificationTracker.MODIFICATION_COUNT, FacetModificationTrackingService.getInstance((Facet)this).getFacetModificationTracker((Facet)this)});
    }

    @Nullable
    public EntityMappings getAnnotationEntityMappings() {
        this.refreshModel();
        return this.myAnnotationsPersistenceRoot;
    }

    @NotNull
    public PersistenceMappings getEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "getEntityMappings"));
        }
        assert (unit.isValid());
        this.refreshModel();
        Collection xmlMappings = GenericValueUtil.getValueCollection((Collection)unit.getModelHelper().getMappingFiles(PersistenceMappings.class), (Collection)new THashSet());
        ArrayList allMappings = new ArrayList();
        ContainerUtil.addIfNotNull(allMappings, (Object)this.getAnnotationEntityMappings(unit));
        ContainerUtil.addIfNotNull(allMappings, (Object)unit.getModelHelper().getAdditionalMapping());
        allMappings.addAll(xmlMappings);
        Object object = allMappings.isEmpty() ? (PersistenceMappings)DomManager.getDomManager((Project)this.getModule().getProject()).createMockElement(HbmHibernateMapping.class, this.getModule(), true) : new MergedPersistenceMappings((PersistenceFacet)this, allMappings);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getEntityMappings"));
        }
        return object;
    }

    public EntityMappings getAnnotationEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "getAnnotationEntityMappings"));
        }
        return this.myAnnotationsPersistenceRoot != null ? this.myAnnotationsPersistenceRoot.createCustomMappings((Condition)JpaFacetImpl.getAnnoMappingsCondition((PersistenceFacet)this, (PersistencePackage)unit).getValue()) : null;
    }

    @NotNull
    public List<PersistenceMappings> getDefaultEntityMappings(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "getDefaultEntityMappings"));
        }
        List<PersistenceMappings> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getDefaultEntityMappings"));
        }
        return list;
    }

    @NotNull
    public Class<SessionFactory> getPersistenceUnitClass() {
        if (SessionFactory.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getPersistenceUnitClass"));
        }
        return SessionFactory.class;
    }

    @NotNull
    public Map<ConfigFileMetaData, Class<? extends PersistenceMappings>> getSupportedDomMappingFormats() {
        LinkedHashMap<ConfigFileMetaData, Class<? extends PersistenceMappings>> map = new LinkedHashMap<ConfigFileMetaData, Class<? extends PersistenceMappings>>();
        map.put(HibernateDescriptorsConstants.HIBERNATE_MAPPING_META_DATA, HbmHibernateMapping.class);
        map.put(JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA, com.intellij.javaee.model.xml.persistence.mapping.EntityMappings.class);
        LinkedHashMap<ConfigFileMetaData, Class<? extends PersistenceMappings>> linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getSupportedDomMappingFormats"));
        }
        return linkedHashMap;
    }

    public String getDataSourceId(@NotNull PersistencePackagePointer unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "getDataSourceId"));
        }
        return this.myUnitDataSourceMap.getSettingValue(unit.getElementName());
    }

    public String getDataSourceId(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "getDataSourceId"));
        }
        return this.myUnitDataSourceMap.getDataSourceID(unit);
    }

    public void setDataSourceId(@NotNull PersistencePackage unit, String dataSourceName) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "setDataSourceId"));
        }
        this.myUnitDataSourceMap.setDataSourceID(unit, dataSourceName);
    }

    public String getNamingStrategy(@NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "getNamingStrategy"));
        }
        return this.myUnitNamingStrategyMap.getSettingValue(unit);
    }

    public void setNamingStrategy(@NotNull PersistencePackage unit, String namingStrategy) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "setNamingStrategy"));
        }
        this.myUnitNamingStrategyMap.setSettingValue(unit, namingStrategy);
    }

    public Language getQlLanguage() {
        return JpqlLanguage.HQL;
    }

    @NotNull
    public ModelValidator getModelValidator(@Nullable PersistencePackage unit) {
        PersistenceModelBrowser browser = PersistenceCommonUtil.createFacetAndUnitModelBrowser((PersistenceFacet)this, (PersistencePackage)unit, null);
        HibernateModelValidator hibernateModelValidator = new HibernateModelValidator(browser);
        if (hibernateModelValidator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getModelValidator"));
        }
        return hibernateModelValidator;
    }

    @NotNull
    public Class[] getInspectionToolClasses() {
        Class[] classArray = (Class[])ArrayUtil.mergeArrays((Object[])new JpaInspectionToolProvider().getInspectionClasses(), (Object[])new HibernateInspectionToolProvider().getInspectionClasses());
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getInspectionToolClasses"));
        }
        return classArray;
    }

    @NotNull
    public PersistencePackageDefaults getPersistenceUnitDefaults(final @NotNull PersistencePackage unit) {
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/intellij/hibernate/facet/HibernateFacet", "getPersistenceUnitDefaults"));
        }
        assert (unit.isValid());
        CachedValue cachedValue = (CachedValue)unit.getUserData(SESSION_FACTORY_DEFAULTS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)unit.getPsiManager().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<PersistencePackageDefaults>(){

                public CachedValueProvider.Result<PersistencePackageDefaults> compute() {
                    Properties properties = unit.getModelHelper().getPersistenceUnitProperties();
                    final String schema = properties.getProperty(HibernateUtil.getFullPropertyName("default_schema"));
                    final String catalog = properties.getProperty(HibernateUtil.getFullPropertyName("default_catalog"));
                    PersistencePackageDefaults result = new PersistencePackageDefaults(){

                        @Nullable
                        public String getSchema() {
                            return schema;
                        }

                        @Nullable
                        public String getCatalog() {
                            return catalog;
                        }

                        @Nullable
                        public PropertyMemberType getAccess() {
                            return null;
                        }
                    };
                    PsiFile containingFile = unit.getContainingFile();
                    return new CachedValueProvider.Result((Object)result, new Object[]{containingFile != null ? containingFile : ModificationTracker.EVER_CHANGED});
                }
            }, false);
            unit.putUserData(SESSION_FACTORY_DEFAULTS, (Object)cachedValue);
        }
        PersistencePackageDefaults persistencePackageDefaults = (PersistencePackageDefaults)cachedValue.getValue();
        if (persistencePackageDefaults == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/facet/HibernateFacet", "getPersistenceUnitDefaults"));
        }
        return persistencePackageDefaults;
    }

    private void refreshModel() {
        boolean isJdk5;
        boolean bl = isJdk5 = LanguageLevel.JDK_1_5.compareTo((Enum)LanguageLevelUtil.getEffectiveLanguageLevel((Module)this.getModule())) <= 0;
        if (!this.getPersistenceUnits().isEmpty()) {
            if (isJdk5 && this.myAnnotationsPersistenceRoot == null) {
                this.myAnnotationsPersistenceRoot = new EntityMappingsImpl(this.getModule());
            }
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myAnnotationsPersistenceRoot == null) {
                this.myAnnotationsPersistenceRoot = new EntityMappingsImpl(this.getModule());
            }
        } else if (this.myAnnotationsPersistenceRoot != null) {
            this.myAnnotationsPersistenceRoot = null;
        }
    }

    public void initFacet() {
        JavaeeUtil.installDomAndJamListeners((Facet)this, (ConfigFileContainer)this.myDescriptorsContainer);
    }

    public void disposeFacet() {
        if (this.myAnnotationsPersistenceRoot != null) {
            this.myAnnotationsPersistenceRoot = null;
        }
    }
}

