/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.codeInsight.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.HamlBundle;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLTagImpl;

public class HamlNestedTagContentInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/haml/codeInsight/inspections/HamlNestedTagContentInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/plugins/haml/codeInsight/inspections/HamlNestedTagContentInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (!(tag instanceof HAMLTagImpl) || ((HAMLTagImpl)tag).isTagNameEmpty()) {
                    return;
                }
                boolean firstLine = true;
                boolean textOnFirstLine = false;
                for (PsiElement element : tag.getChildren()) {
                    if (element.getNode().getElementType() == HAMLTokenTypes.TEXT && firstLine) {
                        textOnFirstLine = true;
                        continue;
                    }
                    if (element.getNode().getElementType() == HAMLTokenTypes.EOL) {
                        firstLine = false;
                        continue;
                    }
                    if (firstLine || !textOnFirstLine || element.getText().trim().length() <= 0) continue;
                    holder.registerProblem((PsiElement)tag, HamlBundle.message("inspection.illegal.nesting.message", tag.getName()), new LocalQuickFix[0]);
                    return;
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/codeInsight/inspections/HamlNestedTagContentInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = HamlBundle.message("inspection.illegal.nesting.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/codeInsight/inspections/HamlNestedTagContentInspection", "getDisplayName"));
        }
        return string;
    }
}

