/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.filters;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.containers.HashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLTagImpl;

public class HamlFilterInjector
implements MultiHostInjector {
    private static final Map<String, String> HAML_FILTER_TO_LANGUAGE_ID_MAP = new HashMap();

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement element) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/haml/filters/HamlFilterInjector", "getLanguagesToInject"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/haml/filters/HamlFilterInjector", "getLanguagesToInject"));
        }
        if (element instanceof HAMLTagImpl) {
            ASTNode possibleFilterContent;
            ASTNode firstChild = element.getNode().getFirstChildNode();
            if (firstChild.getElementType() == HAMLTokenTypes.INDENT) {
                firstChild = firstChild.getTreeNext();
            }
            if (firstChild != null && firstChild.getElementType() == HAMLTokenTypes.FILTER && (possibleFilterContent = firstChild.getTreeNext()).getElementType() == HAMLTokenTypes.FILTER_CONTENT) {
                String languageName = firstChild.getText();
                String languageId = HAML_FILTER_TO_LANGUAGE_ID_MAP.get(languageName = StringUtil.trimStart((String)languageName, (String)":"));
                if (languageId == null) {
                    return;
                }
                Language filterLanguage = Language.findLanguageByID((String)languageId);
                if (filterLanguage != null) {
                    int injectionOffset = possibleFilterContent.getStartOffset() - ((HAMLTagImpl)element).getStartOffset();
                    TextRange range = new TextRange(injectionOffset, injectionOffset + possibleFilterContent.getTextLength());
                    registrar.startInjecting(filterLanguage).addPlace(null, null, (PsiLanguageInjectionHost)element, range).doneInjecting();
                }
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(HAMLTagImpl.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/filters/HamlFilterInjector", "elementsToInjectIn"));
        }
        return list;
    }

    static {
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("ruby", "ruby");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("javascript", "JavaScript");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("css", "CSS");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("sass", "SASS");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("scss", "SCSS");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("less", "LESS");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("styl", "Stylus");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("coffee", "CoffeeScript");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("coffeescript", "CoffeeScript");
        HAML_FILTER_TO_LANGUAGE_ID_MAP.put("erb", "RHTML");
    }
}

