/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.joinLines;

import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenEntry;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/joinLines/JoinBlockIntoSingleStatementHandler;", "Lcom/intellij/codeInsight/editorActions/JoinRawLinesHandlerDelegate;", "()V", "tryJoinLines", "", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "start", "end", "tryJoinRawLines", "idea"})
public final class JoinBlockIntoSingleStatementHandler
implements JoinRawLinesHandlerDelegate {
    /*
     * WARNING - void declaration
     */
    public int tryJoinRawLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!(file instanceof KtFile)) {
            return -1;
        }
        if (start == 0) {
            return -1;
        }
        char c = document.getCharsSequence().charAt(start);
        int index2 = c == '\n' ? start - 1 : start;
        PsiElement psiElement = file.findElementAt(index2);
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        PsiElement brace = psiElement;
        ASTNode aSTNode = brace.getNode();
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)KtTokens.LBRACE)) ^ true) {
            return -1;
        }
        PsiElement psiElement2 = brace.getParent();
        if (!(psiElement2 instanceof KtBlockExpression)) {
            psiElement2 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)psiElement2;
        if (ktBlockExpression == null) {
            return -1;
        }
        KtBlockExpression block = ktBlockExpression;
        KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull(block.getStatements());
        if (ktExpression == null) {
            return -1;
        }
        KtExpression statement2 = ktExpression;
        PsiElement parent2 = block.getParent();
        if (!(parent2 instanceof KtContainerNode) && !(parent2 instanceof KtWhenEntry)) {
            return -1;
        }
        Object[] objectArray = block.getNode().getChildren(KtTokens.COMMENTS);
        void var12_12 = $receiver$iv;
        if (!(((void)$receiver$iv$iv).length == 0)) {
            return -1;
        }
        PsiElement pparent = parent2.getParent();
        if (pparent instanceof KtIfExpression && Intrinsics.areEqual((Object)block, (Object)((KtIfExpression)pparent).getThen()) && statement2 instanceof KtIfExpression && ((KtIfExpression)statement2).getElse() == null) {
            if (((KtIfExpression)pparent).getElse() != null) {
                return -1;
            }
            KtExpression condition1 = ((KtIfExpression)pparent).getCondition();
            KtExpression condition2 = ((KtIfExpression)statement2).getCondition();
            KtExpression body2 = ((KtIfExpression)statement2).getThen();
            if (condition1 != null && condition2 != null && body2 != null) {
                KtExpression newCondition = CreateByPatternKt.createExpressionByPattern(KtPsiFactoryKt.KtPsiFactory(pparent), "$0 && $1", condition1, condition2);
                condition1.replace((PsiElement)newCondition);
                PsiElement newBody = block.replace((PsiElement)body2);
                TextRange textRange = newBody.getTextRange();
                if (textRange == null) {
                    Intrinsics.throwNpe();
                }
                return textRange.getStartOffset();
            }
        }
        PsiElement newStatement = block.replace((PsiElement)statement2);
        TextRange textRange = newStatement.getTextRange();
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        return textRange.getStartOffset();
    }

    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile file, int start, int end) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return -1;
    }
}

