/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionReturnTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeParameterTypeFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeVariableTypeFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

public class ChangeFunctionLiteralReturnTypeFix
extends KotlinQuickFixAction<KtLambdaExpression> {
    private final KotlinType type;
    private final KtTypeReference functionLiteralReturnTypeRef;
    private IntentionAction appropriateQuickFix;

    public ChangeFunctionLiteralReturnTypeFix(@NotNull KtLambdaExpression functionLiteralExpression, @NotNull KotlinType type2) {
        KtTypeReference parentFunctionReturnTypeRef;
        KotlinType parentFunctionReturnType;
        ValueArgument valueArgument;
        KtParameter correspondingParameter;
        if (functionLiteralExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralExpression", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "<init>"));
        }
        super(functionLiteralExpression);
        this.appropriateQuickFix = null;
        this.type = type2;
        this.functionLiteralReturnTypeRef = functionLiteralExpression.getFunctionLiteral().getTypeReference();
        AnalysisResult analysisResult = ResolutionUtils.analyzeFullyAndGetResult(functionLiteralExpression.getContainingKtFile(), new KtFile[0]);
        BindingContext context = analysisResult.getBindingContext();
        KotlinType functionLiteralType = context.getType(functionLiteralExpression);
        assert (functionLiteralType != null) : "Type of function literal not available in binding context";
        KotlinBuiltIns builtIns = analysisResult.getModuleDescriptor().getBuiltIns();
        ClassDescriptor functionClass = builtIns.getFunction(functionLiteralType.getArguments().size() - 1);
        LinkedList<KotlinType> functionClassTypeParameters = new LinkedList<KotlinType>();
        for (TypeProjection typeProjection : functionLiteralType.getArguments()) {
            functionClassTypeParameters.add(typeProjection.getType());
        }
        functionClassTypeParameters.remove(functionClassTypeParameters.size() - 1);
        functionClassTypeParameters.add(type2);
        KotlinType eventualFunctionLiteralType = TypeUtils.substituteParameters(functionClass, functionClassTypeParameters);
        KtProperty correspondingProperty = (KtProperty)PsiTreeUtil.getParentOfType((PsiElement)functionLiteralExpression, KtProperty.class);
        if (correspondingProperty != null && QuickFixUtil.canEvaluateTo(correspondingProperty.getInitializer(), functionLiteralExpression)) {
            KtTypeReference correspondingPropertyTypeRef = correspondingProperty.getTypeReference();
            KotlinType propertyType = context.get(BindingContext.TYPE, correspondingPropertyTypeRef);
            if (propertyType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, propertyType)) {
                this.appropriateQuickFix = new ChangeVariableTypeFix(correspondingProperty, eventualFunctionLiteralType);
            }
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getParentResolvedCall(functionLiteralExpression, context, true);
        if (resolvedCall2 != null && (correspondingParameter = QuickFixUtil.getParameterDeclarationForValueArgument(resolvedCall2, valueArgument = CallUtilKt.getValueArgumentForExpression(resolvedCall2.getCall(), functionLiteralExpression))) != null) {
            KtTypeReference correspondingParameterTypeRef = correspondingParameter.getTypeReference();
            KotlinType parameterType = context.get(BindingContext.TYPE, correspondingParameterTypeRef);
            if (parameterType != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parameterType)) {
                this.appropriateQuickFix = new ChangeParameterTypeFix(correspondingParameter, eventualFunctionLiteralType);
            }
            return;
        }
        KtFunction parentFunction = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)functionLiteralExpression, KtFunction.class, (boolean)true);
        if (parentFunction != null && QuickFixUtil.canFunctionOrGetterReturnExpression(parentFunction, functionLiteralExpression) && (parentFunctionReturnType = context.get(BindingContext.TYPE, parentFunctionReturnTypeRef = parentFunction.getTypeReference())) != null && !KotlinTypeChecker.DEFAULT.isSubtypeOf(eventualFunctionLiteralType, parentFunctionReturnType)) {
            this.appropriateQuickFix = new ChangeFunctionReturnTypeFix(parentFunction, eventualFunctionLiteralType);
        }
    }

    @NotNull
    public String getText() {
        if (this.appropriateQuickFix != null) {
            String string = this.appropriateQuickFix.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "getText"));
            }
            return string;
        }
        String string = String.format("Change lambda expression return type to '%s'", IdeDescriptorRenderers.SOURCE_CODE_SHORT_NAMES_IN_TYPES.renderType(this.type));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = KotlinBundle.message("change.type.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && (this.functionLiteralReturnTypeRef != null || this.appropriateQuickFix != null && this.appropriateQuickFix.isAvailable(project, editor, file));
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, @NotNull KtFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "invoke"));
        }
        if (this.functionLiteralReturnTypeRef != null) {
            KtTypeReference newTypeRef = KtPsiFactoryKt.KtPsiFactory((PsiElement)file).createType(IdeDescriptorRenderers.SOURCE_CODE.renderType(this.type));
            newTypeRef = (KtTypeReference)this.functionLiteralReturnTypeRef.replace((PsiElement)newTypeRef);
            ShortenReferences.DEFAULT.process(newTypeRef);
        }
        if (this.appropriateQuickFix != null && this.appropriateQuickFix.isAvailable(project, editor, (PsiFile)file)) {
            this.appropriateQuickFix.invoke(project, editor, (PsiFile)file);
        }
    }

    @NotNull
    public static KotlinSingleIntentionActionFactory createFactoryForExpectedOrAssignmentTypeMismatch() {
        KotlinSingleIntentionActionFactory kotlinSingleIntentionActionFactory = new KotlinSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix$1", "createAction"));
                }
                KtLambdaExpression functionLiteralExpression = QuickFixUtil.getParentElementOfType(diagnostic, KtLambdaExpression.class);
                if (functionLiteralExpression == null) {
                    return null;
                }
                return new ChangeFunctionLiteralReturnTypeFix(functionLiteralExpression, PlatformKt.getPlatform(functionLiteralExpression).getBuiltIns().getUnitType());
            }
        };
        if (kotlinSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/ChangeFunctionLiteralReturnTypeFix", "createFactoryForExpectedOrAssignmentTypeMismatch"));
        }
        return kotlinSingleIntentionActionFactory;
    }
}

