/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.roles;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetFinder;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistenceQuery;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentSuperclass;
import com.intellij.persistence.model.helpers.PersistenceMappingsModelHelper;
import com.intellij.persistence.model.helpers.PersistentEntityBaseModelHelper;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.roles.PersistenceClassRoleEnum;
import com.intellij.persistence.roles.PersistenceClassRoleImpl;
import com.intellij.persistence.roles.PersistenceRoleHolder;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.GenericValue;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistenceRoleHolderImpl
extends PersistenceRoleHolder {
    private static final NotNullFunction<PersistenceFacet, Info> MERGED_GETTER = new NotNullFunction<PersistenceFacet, Info>(){

        @NotNull
        public Info fun(PersistenceFacet facet) {
            Info info = PersistenceRoleHolderImpl.getFacetMergedInfo(facet);
            if (info == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/roles/PersistenceRoleHolderImpl$1", "fun"));
            }
            return info;
        }
    };
    private static final NotNullFunction<PersistenceFacet, Info> XML_GETTER = new NotNullFunction<PersistenceFacet, Info>(){

        @NotNull
        public Info fun(PersistenceFacet facet) {
            Info info = PersistenceRoleHolderImpl.getFacetXmlInfo(facet);
            if (info == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/roles/PersistenceRoleHolderImpl$2", "fun"));
            }
            return info;
        }
    };
    private final Project myProject;

    public PersistenceRoleHolderImpl(PsiManager manager) {
        this.myProject = manager.getProject();
    }

    public boolean processAllRoles(@NotNull PsiClass psiClass, @NotNull Processor<PersistenceClassRole> processor) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processAllRoles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processAllRoles"));
        }
        return this.processRoles(psiClass, MERGED_GETTER, processor);
    }

    public boolean processXmlRoles(@NotNull PsiClass aClass, @NotNull Processor<PersistenceClassRole> processor) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processXmlRoles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processXmlRoles"));
        }
        return this.processRoles(aClass, XML_GETTER, processor);
    }

    private boolean processRoles(@NotNull PsiClass psiClass, @NotNull NotNullFunction<PersistenceFacet, Info> infoGetter, @NotNull Processor<PersistenceClassRole> processor) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processRoles"));
        }
        if (infoGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoGetter", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processRoles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processRoles"));
        }
        String fqn = PersistenceRoleHolderImpl.getFQN(psiClass);
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets((Project)this.myProject)) {
            for (PersistenceClassRole role : ((Info)infoGetter.fun((Object)facet)).map.get((Object)fqn)) {
                if (processor.process((Object)role)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processAllRoles(@NotNull Processor<PersistenceClassRole> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processAllRoles"));
        }
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacets((Project)this.myProject)) {
            for (PersistenceClassRole role : ((Info)PersistenceRoleHolderImpl.MERGED_GETTER.fun((Object)facet)).map.values()) {
                if (processor.process((Object)role)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean processMergedQueries(PersistenceFacet facet, @NotNull Processor<PersistenceQuery> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "processMergedQueries"));
        }
        for (AtomicNotNullLazyValue<List<PersistenceQuery>> producer : ((Info)PersistenceRoleHolderImpl.MERGED_GETTER.fun((Object)facet)).queryProducers) {
            for (PersistenceQuery query : (List)producer.getValue()) {
                if (processor.process((Object)query)) continue;
                return false;
            }
        }
        return true;
    }

    private static Info getFacetXmlInfo(final PersistenceFacet facet) {
        if (facet.getModule().isDisposed()) {
            return new Info();
        }
        return (Info)CachedValuesManager.getManager((Project)facet.getModule().getProject()).getCachedValue((UserDataHolder)facet, (CachedValueProvider)new CachedValueProvider<Info>(){

            @Nullable
            public CachedValueProvider.Result<Info> compute() {
                Info info = new Info();
                HashSet<Object> dependencies = new HashSet<Object>();
                Project project = facet.getModule().getProject();
                dependencies.add(ProjectRootManager.getInstance((Project)project));
                if (facet instanceof Facet) {
                    FacetTypeId typeId = ((Facet)facet).getTypeId();
                    dependencies.add(FacetFinder.getInstance((Project)project).getAllFacetsOfTypeModificationTracker(typeId));
                }
                ContainerUtil.addIfNotNull((Object)facet.getDescriptorsContainer(), dependencies);
                for (PersistencePackage unit : facet.getPersistenceUnits()) {
                    ContainerUtil.addIfNotNull((Object)unit.getContainingFile(), dependencies);
                    ContainerUtil.addAll(dependencies, (Iterable)unit.getModelHelper().getCacheDependencies());
                    for (GenericValue value : unit.getModelHelper().getMappingFiles(PersistenceMappings.class)) {
                        PersistenceMappings mappings = (PersistenceMappings)value.getValue();
                        if (mappings == null) continue;
                        ContainerUtil.addIfNotNull((Object)mappings.getContainingFile(), dependencies);
                        PersistenceRoleHolderImpl.processMappings(info, facet, unit, mappings);
                    }
                }
                return new CachedValueProvider.Result((Object)info, ArrayUtil.toObjectArray(dependencies));
            }
        });
    }

    private static Info getFacetMergedInfo(final PersistenceFacet facet) {
        if (facet.getModule().isDisposed()) {
            return new Info();
        }
        return (Info)CachedValuesManager.getManager((Project)facet.getModule().getProject()).getCachedValue((UserDataHolder)facet, (CachedValueProvider)new CachedValueProvider<Info>(){

            @Nullable
            public CachedValueProvider.Result<Info> compute() {
                Info info = new Info();
                for (PersistencePackage unit : facet.getPersistenceUnits()) {
                    PersistenceRoleHolderImpl.processMappings(info, facet, unit, facet.getEntityMappings(unit));
                }
                return new CachedValueProvider.Result((Object)info, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
    }

    private static void processMappings(Info info, PersistenceFacet facet, PersistencePackage unit, PersistenceMappings mappings) {
        PersistenceMappingsModelHelper mappingsModelHelper = mappings.getModelHelper();
        List<AtomicNotNullLazyValue<List<PersistenceQuery>>> producers = info.queryProducers;
        for (PersistentEntity entity : mappingsModelHelper.getPersistentEntities()) {
            PersistenceRoleHolderImpl.processClass(info, (PsiClass)entity.getClazz().getValue(), PersistenceClassRoleEnum.ENTITY, (PersistentObject)entity, unit, facet);
            producers.add(PersistenceRoleHolderImpl.createProducer((PersistentEntityBaseModelHelper)entity.getObjectModelHelper()));
        }
        for (PersistentEmbeddable embeddable : mappingsModelHelper.getPersistentEmbeddables()) {
            PersistenceRoleHolderImpl.processClass(info, (PsiClass)embeddable.getClazz().getValue(), PersistenceClassRoleEnum.EMBEDDABLE, (PersistentObject)embeddable, unit, facet);
        }
        for (PersistentSuperclass mappedSuperclass : mappingsModelHelper.getPersistentSuperclasses()) {
            PersistenceRoleHolderImpl.processClass(info, (PsiClass)mappedSuperclass.getClazz().getValue(), PersistenceClassRoleEnum.MAPPED_SUPERCLASS, (PersistentObject)mappedSuperclass, unit, facet);
            producers.add(PersistenceRoleHolderImpl.createProducer(mappedSuperclass.getObjectModelHelper()));
        }
        for (PersistenceListener entityListener : mappingsModelHelper.getPersistentListeners()) {
            PersistenceRoleHolderImpl.processEntityListenerClass(info, (PsiClass)entityListener.getClazz().getValue(), entityListener, unit, facet);
        }
        producers.add(PersistenceRoleHolderImpl.createProducer(mappingsModelHelper));
    }

    public static void processEntityListenerClass(Info info, PsiClass psiClass, PersistenceListener entityListener, PersistencePackage unit, PersistenceFacet facet) {
        PersistenceRoleHolderImpl.processClass(info, psiClass, new PersistenceClassRoleImpl(PersistenceClassRoleEnum.ENTITY_LISTENER, facet, unit, entityListener));
    }

    private static void processClass(Info info, PsiClass psiClass, PersistenceClassRoleEnum classRoleEnum, PersistentObject persistentObject, PersistencePackage unit, PersistenceFacet facet) {
        PersistenceRoleHolderImpl.processClass(info, psiClass, new PersistenceClassRoleImpl(classRoleEnum, facet, unit, persistentObject));
    }

    private static void processClass(Info info, PsiClass psiClass, PersistenceClassRole classRole) {
        ProgressManager.checkCanceled();
        if (psiClass == null) {
            return;
        }
        info.map.putValue((Object)PersistenceRoleHolderImpl.getFQN(psiClass), (Object)classRole);
    }

    private static String getFQN(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "getFQN"));
        }
        String name = psiClass.getQualifiedName();
        VirtualFile virtualFile = psiClass.getContainingFile().getOriginalFile().getVirtualFile();
        return virtualFile == null ? name : name + ":" + virtualFile.getPath();
    }

    private static AtomicNotNullLazyValue<List<PersistenceQuery>> createProducer(final PersistenceMappingsModelHelper helper) {
        return new AtomicNotNullLazyValue<List<PersistenceQuery>>(){

            @NotNull
            protected List<PersistenceQuery> compute() {
                List queries = ContainerUtil.newSmartList();
                queries.addAll(helper.getNamedQueries());
                queries.addAll(helper.getNamedNativeQueries());
                List list = queries;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/roles/PersistenceRoleHolderImpl$5", "compute"));
                }
                return list;
            }
        };
    }

    private static AtomicNotNullLazyValue<List<PersistenceQuery>> createProducer(final @NotNull PersistentEntityBaseModelHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/persistence/roles/PersistenceRoleHolderImpl", "createProducer"));
        }
        return new AtomicNotNullLazyValue<List<PersistenceQuery>>(){

            @NotNull
            protected List<PersistenceQuery> compute() {
                List queries = ContainerUtil.newSmartList();
                queries.addAll(helper.getNamedQueries());
                queries.addAll(helper.getNamedNativeQueries());
                List list = queries;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/roles/PersistenceRoleHolderImpl$6", "compute"));
                }
                return list;
            }
        };
    }

    private static class Info {
        final MultiMap<String, PersistenceClassRole> map = MultiMap.createSet();
        final List<AtomicNotNullLazyValue<List<PersistenceQuery>>> queryProducers = ContainerUtil.newSmartList();

        private Info() {
        }
    }
}

