/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.util;

import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.util.JdbcUtil;
import com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdbcTypesUtil {
    @NonNls
    public static final String CHAR_ARR = "char[]";
    @NonNls
    public static final String BYTE_ARR = "byte[]";
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String BYTE = "java.lang.Byte";
    public static final String SHORT = "java.lang.Short";
    public static final String INTEGER = "java.lang.Integer";
    public static final String LONG = "java.lang.Long";
    public static final String BIGINT = "java.math.BigInteger";
    public static final String BIGDECIMAL = "java.math.BigDecimal";
    public static final String FLOAT = "java.lang.Float";
    public static final String DOUBLE = "java.lang.Double";
    public static final String STRING = "java.lang.String";
    public static final String BLOB = "java.sql.Blob";
    public static final String SQL_DATE = "java.sql.Date";
    public static final String UTIL_DATE = "java.util.Date";
    public static final String SQL_TIME = "java.sql.Time";
    public static final String SQL_TIMESTAMP = "java.sql.Timestamp";
    public static final String CLOB = "java.sql.Clob";
    public static final String SQL_ARRAY = "java.sql.Array";
    public static final String SQL_REF = "java.sql.Ref";
    public static final String OBJECT = "java.lang.Object";
    public static final String SQL_STRUCT = "java.sql.Struct";
    public static final String SERIALIZABLE = "java.io.Serializable";
    public static final String MAP = "java.util.Map";

    private JdbcTypesUtil() {
    }

    @NotNull
    public static String[] getJavaTypeVariants(int jdbcType, boolean preferUnboxed, DasTypedObject info) {
        String[] result;
        switch (jdbcType) {
            case -7: 
            case 16: {
                result = new String[]{BOOLEAN, BYTE, SHORT, INTEGER, LONG, BIGINT, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                break;
            }
            case -6: {
                result = new String[]{BYTE, SHORT, INTEGER, LONG, BIGINT, BOOLEAN, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                break;
            }
            case 5: {
                result = new String[]{SHORT, INTEGER, LONG, BIGINT, BOOLEAN, BYTE, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                break;
            }
            case 4: {
                result = new String[]{INTEGER, LONG, BIGINT, BOOLEAN, BYTE, SHORT, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                break;
            }
            case -5: {
                result = new String[]{LONG, BIGINT, BOOLEAN, BYTE, SHORT, INTEGER, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                break;
            }
            case 7: {
                result = new String[]{FLOAT, DOUBLE, BIGDECIMAL, BOOLEAN, BYTE, SHORT, INTEGER, LONG, BIGINT, STRING};
                break;
            }
            case 6: 
            case 8: {
                result = new String[]{DOUBLE, FLOAT, BIGDECIMAL, BOOLEAN, BYTE, SHORT, INTEGER, LONG, BIGINT, STRING};
                break;
            }
            case 2: 
            case 3: {
                int bytesRequired;
                int precision = info.getDataType().getPrecision();
                int n = bytesRequired = precision > 0 ? (int)((double)precision / Math.log(2.0) / 8.0 + 0.5) : 0;
                if (bytesRequired > 0) {
                    if (info.getDataType().getScale() == 0) {
                        if (bytesRequired <= 4) {
                            result = new String[]{INTEGER, BOOLEAN, BYTE, SHORT, LONG, BIGINT, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                            break;
                        }
                        if (bytesRequired <= 8) {
                            result = new String[]{LONG, BOOLEAN, BYTE, SHORT, INTEGER, BIGINT, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                            break;
                        }
                        result = new String[]{BIGINT, BOOLEAN, BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                        break;
                    }
                    result = new String[]{BIGDECIMAL, BOOLEAN, BYTE, SHORT, INTEGER, LONG, BIGINT, FLOAT, DOUBLE, STRING};
                    break;
                }
                if (info.getDataType().getScale() == 0) {
                    result = new String[]{BIGINT, BOOLEAN, BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE, BIGDECIMAL, STRING};
                    break;
                }
                result = new String[]{BIGDECIMAL, BOOLEAN, BYTE, SHORT, INTEGER, LONG, BIGINT, FLOAT, DOUBLE, STRING};
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                if (info.getDataType().getLength() == 1) {
                    result = new String[]{STRING, BOOLEAN, BYTE, SHORT, INTEGER, CHAR_ARR, BYTE_ARR};
                    break;
                }
                result = new String[]{STRING, CHAR_ARR, BYTE_ARR, SQL_DATE, SQL_TIME, SQL_TIMESTAMP, UTIL_DATE};
                break;
            }
            case 91: {
                result = new String[]{SQL_DATE, UTIL_DATE, STRING};
                break;
            }
            case 92: {
                result = new String[]{SQL_TIME, STRING};
                break;
            }
            case 93: {
                result = new String[]{SQL_TIMESTAMP, STRING};
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                result = new String[]{BYTE_ARR, STRING};
                break;
            }
            case 0: 
            case 70: 
            case 1111: 
            case 2000: 
            case 2001: {
                result = new String[]{OBJECT, SERIALIZABLE};
                break;
            }
            case 2002: {
                result = new String[]{SQL_STRUCT, MAP, OBJECT};
                break;
            }
            case 2003: {
                result = new String[]{SQL_ARRAY, OBJECT};
                break;
            }
            case 2004: {
                result = new String[]{BYTE_ARR, BLOB};
                break;
            }
            case 2005: 
            case 2011: {
                result = new String[]{STRING, CHAR_ARR, CLOB};
                break;
            }
            case 2006: {
                result = new String[]{SQL_REF, OBJECT, SERIALIZABLE};
                break;
            }
            default: {
                result = new String[]{OBJECT, SERIALIZABLE};
            }
        }
        String[] stringArray = preferUnboxed && info.isNotNull() ? JdbcTypesUtil.unboxJavaTypes(result) : result;
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/persistence/util/JdbcTypesUtil", "getJavaTypeVariants"));
        }
        return stringArray;
    }

    private static String[] unboxJavaTypes(String[] types) {
        for (int i = 0; i < types.length; ++i) {
            types[i] = PsiTypesUtil.unboxIfPossible((String)types[i]);
        }
        return types;
    }

    @Nullable
    public static String getJavaType(@NotNull DasColumn column, boolean preferPrimitiveTypes, @Nullable DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/persistence/util/JdbcTypesUtil", "getJavaType"));
        }
        int jdbcType = JdbcTypesUtil.getJdbcType(column, dialect);
        String[] javaType = JdbcTypesUtil.getJavaTypeVariants(jdbcType, preferPrimitiveTypes, (DasTypedObject)column);
        return javaType.length > 0 ? javaType[0] : OBJECT;
    }

    public static int getJdbcType(@NotNull DasColumn column, @Nullable DatabaseDialect dialect) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/persistence/util/JdbcTypesUtil", "getJdbcType"));
        }
        DataType dataType = column.getDataType();
        int jdbcType = dataType.jdbcType;
        if (jdbcType == 1111 || jdbcType == 0) {
            jdbcType = dialect != null ? dialect.getJavaTypeForNativeType(dataType.getSpecification()) : JdbcUtil.guessJdbcTypeByName((String)dataType.getSpecification());
        }
        return jdbcType;
    }
}

