/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.jsf.composite.CompositeComponentDescriptor;
import com.intellij.jsf.composite.CompositeUtil;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeNamespaceDescriptor
extends XmlNSDescriptorImpl {
    private final String myNamespace;
    private final String myResourcesPath;
    private final Key<CachedValue<Set<XmlFile>>> COMPOSITE_NAMESPACE_FILES_CACHE;

    public CompositeNamespaceDescriptor(@NotNull String namespace, @NotNull String resourcePath) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "<init>"));
        }
        if (resourcePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourcePath", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "<init>"));
        }
        this.COMPOSITE_NAMESPACE_FILES_CACHE = Key.create((String)"COMPOSITE_NAMESPACE_FILES_CACHE");
        this.myNamespace = namespace;
        this.myResourcesPath = resourcePath;
    }

    public String getResourcesPath() {
        return this.myResourcesPath;
    }

    public void init(PsiElement element) {
        super.init(element);
    }

    public XmlElementDescriptor getElementDescriptor(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getElementDescriptor"));
        }
        if (!this.myNamespace.equals(tag.getNamespace())) {
            return null;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)tag);
        if (module == null) {
            return null;
        }
        for (XmlFile file : this.getCompositeComponentsFiles(module)) {
            if (!tag.getLocalName().equals(FileUtil.getNameWithoutExtension((String)file.getName()))) continue;
            return new CompositeComponentDescriptor(file, tag.getNamespacePrefix());
        }
        return null;
    }

    public XmlElementDescriptor getElementDescriptor(String localName, String namespace) {
        return super.getElementDescriptor(localName, namespace);
    }

    @NotNull
    public XmlElementDescriptor[] getRootElementsDescriptors(@Nullable XmlDocument doc) {
        if (doc == null) {
            if (XmlElementDescriptor.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getRootElementsDescriptors"));
            }
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)doc);
        XmlTag rootTag = doc.getRootTag();
        if (rootTag != null) {
            String prefix = rootTag.getPrefixByNamespace(this.myNamespace);
            if (module != null && prefix != null) {
                HashSet<CompositeComponentDescriptor> descriptors = new HashSet<CompositeComponentDescriptor>();
                for (XmlFile file : this.getCompositeComponentsFiles(module)) {
                    descriptors.add(new CompositeComponentDescriptor(file, prefix));
                }
                XmlElementDescriptor[] xmlElementDescriptorArray = descriptors.toArray(new XmlElementDescriptor[descriptors.size()]);
                if (xmlElementDescriptorArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getRootElementsDescriptors"));
                }
                return xmlElementDescriptorArray;
            }
        }
        if (XmlElementDescriptor.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getRootElementsDescriptors"));
        }
        return XmlElementDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    private Set<XmlFile> getCompositeComponentsFiles(final Module module) {
        CachedValue value = (CachedValue)module.getUserData(this.COMPOSITE_NAMESPACE_FILES_CACHE);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Set<XmlFile>>(){

                public CachedValueProvider.Result<Set<XmlFile>> compute() {
                    Set files = CompositeNamespaceDescriptor.this.collectCompositeComponentsFiles(module);
                    return CachedValueProvider.Result.create((Object)files, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
            }, false);
            module.putUserData(this.COMPOSITE_NAMESPACE_FILES_CACHE, (Object)value);
        }
        Set set = (Set)value.getValue();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "getCompositeComponentsFiles"));
        }
        return set;
    }

    @NotNull
    private Set<XmlFile> collectCompositeComponentsFiles(Module module) {
        HashSet<XmlFile> files = new HashSet<XmlFile>();
        for (PsiDirectory directory : JsfCommonUtils.collectDirectories(module, this.myResourcesPath)) {
            for (PsiFile file : directory.getFiles()) {
                if (!(file instanceof XmlFile) || !CompositeUtil.hasCompositeNsDefinedIn((XmlFile)file)) continue;
                files.add((XmlFile)file);
            }
        }
        HashSet<XmlFile> hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/composite/CompositeNamespaceDescriptor", "collectCompositeComponentsFiles"));
        }
        return hashSet;
    }
}

