/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.google.common.base.Joiner;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.Colon2ConstNode;
import org.jrubyparser.ast.Colon3Node;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.ModuleNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.util.NoopVisitor;

class CollectExtensionFunctionVisitor
extends NoopVisitor {
    private static final Joiner COMMENTS_JOINER = Joiner.on((char)'\n');
    private static final Joiner ARGUMENTS_JOINER = Joiner.on((String)", ");
    private boolean myCurrentModuleIsAppropriate;
    private final Stack<String> myCurrentModules;
    private final Set<String> myAppropriateModules;
    private final Map<String, SassExtensionFunctionInfo> myResult;

    public CollectExtensionFunctionVisitor(@NotNull Set<String> appropriateModules, @NotNull Map<String, SassExtensionFunctionInfo> result) {
        if (appropriateModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appropriateModules", "org/jetbrains/plugins/sass/extensions/CollectExtensionFunctionVisitor", "<init>"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/sass/extensions/CollectExtensionFunctionVisitor", "<init>"));
        }
        this.myCurrentModuleIsAppropriate = false;
        this.myCurrentModules = new Stack();
        this.myAppropriateModules = appropriateModules;
        this.myResult = result;
    }

    public Object visitModuleNode(ModuleNode iVisited) {
        String moduleName;
        int moduleLevel = 0;
        Colon3Node path = iVisited.getCPath();
        if (path instanceof Colon2ConstNode) {
            while (path instanceof Colon2ConstNode) {
                moduleName = ((Colon2ConstNode)path).getName();
                this.addModuleToCurrent(moduleLevel, moduleName);
                ++moduleLevel;
                path = ((Colon2ConstNode)path).getLeftNode();
            }
        }
        if (path instanceof INameNode) {
            moduleName = ((INameNode)path).getName();
            this.addModuleToCurrent(moduleLevel, moduleName);
            ++moduleLevel;
        }
        if (!this.myCurrentModuleIsAppropriate) {
            this.myCurrentModuleIsAppropriate = this.isCurrentModuleAppropriate();
        }
        Object result = super.visitModuleNode(iVisited);
        while (moduleLevel > 0 && !this.myCurrentModules.empty()) {
            this.myCurrentModules.pop();
            --moduleLevel;
        }
        this.myCurrentModuleIsAppropriate = this.isCurrentModuleAppropriate();
        return result;
    }

    private void addModuleToCurrent(int moduleLevel, String moduleName) {
        if (moduleLevel > 0) {
            this.myCurrentModules.add(this.myCurrentModules.size() - moduleLevel, (Object)moduleName);
        } else {
            this.myCurrentModules.add((Object)moduleName);
        }
    }

    public Object visit(Node iVisited) {
        try {
            return super.visit(iVisited);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object visitAliasNode(AliasNode iVisited) {
        String newName;
        String oldName;
        SassExtensionFunctionInfo existingFunction;
        if (this.isCurrentModuleAppropriate() && (existingFunction = this.myResult.get(oldName = iVisited.getOldNameString())) != null && StringUtil.isNotEmpty((String)(newName = iVisited.getNewNameString()))) {
            this.myResult.put(newName, new SassExtensionFunctionInfo(newName, existingFunction.getArgumentsString(), existingFunction.getDocumentation(), iVisited.getPosition().getFile(), null));
        }
        return super.visitAliasNode(iVisited);
    }

    public Object visitClassNode(ClassNode iVisited) {
        return null;
    }

    public Object visitDefnNode(DefnNode iVisited) {
        if (this.isCurrentModuleAppropriate()) {
            ArgsNode argsNode = iVisited.getArgs();
            this.myResult.put(SASSSCSSLangUtil.normalizeName(iVisited.getName()), new SassExtensionFunctionInfo(iVisited.getName(), ARGUMENTS_JOINER.join((Iterable)argsNode.getNormativeParameterNameList(false)), CollectExtensionFunctionVisitor.createDocumentationFromCommentNode(iVisited.getPreviousComments()), iVisited.getPosition().getFile(), null));
        }
        return super.visitDefnNode(iVisited);
    }

    private boolean isCurrentModuleAppropriate() {
        StringBuilder fullModulePath = new StringBuilder();
        for (String moduleName : this.myCurrentModules) {
            if (fullModulePath.length() > 0) {
                fullModulePath.append("::");
            }
            fullModulePath.append(moduleName);
            if (!this.myAppropriateModules.contains(fullModulePath.toString())) continue;
            return true;
        }
        return false;
    }

    private static String createDocumentationFromCommentNode(List<CommentNode> comments) {
        return COMMENTS_JOINER.join((Iterable)ContainerUtil.map((Collection)ContainerUtil.reverse(comments), (Function)new Function<CommentNode, String>(){

            public String fun(CommentNode node) {
                return StringUtil.trimStart((String)node.getContent(), (String)"#").trim();
            }
        }));
    }
}

