/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.extensions.SassExtension;

public class SassExtensionsModuleComponent
implements ModuleComponent {
    private final Module myModule;

    public SassExtensionsModuleComponent(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/SassExtensionsModuleComponent", "<init>"));
        }
        this.myModule = module;
    }

    public void initComponent() {
        for (final SassExtension extension : SassExtension.getAllExtensions(null)) {
            StartupManager startupManager = StartupManager.getInstance((Project)this.myModule.getProject());
            startupManager.runWhenProjectIsInitialized(new Runnable(){

                @Override
                public void run() {
                    extension.startActivity(SassExtensionsModuleComponent.this.myModule);
                }
            });
        }
    }

    public void disposeComponent() {
        for (SassExtension extension : SassExtension.getAllExtensions(null)) {
            extension.stopActivity(this.myModule);
        }
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void moduleAdded() {
    }

    @NotNull
    public String getComponentName() {
        if ("Sass Extensions component" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassExtensionsModuleComponent", "getComponentName"));
        }
        return "Sass Extensions component";
    }
}

