/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.scss.inspections.SassScssBaseInspection;
import org.jetbrains.plugins.scss.psi.SASSSCSSElementVisitor;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssPlaceholderSelectorImpl;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;
import org.jetbrains.plugins.scss.references.SassScssFunctionReference;

public class SassScssResolvedByNameOnlyInspection
extends SassScssBaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = SASSBundle.message("inspections.resolved.without.imports.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssResolvedByNameOnlyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/scss/inspections/SassScssResolvedByNameOnlyInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/plugins/scss/inspections/SassScssResolvedByNameOnlyInspection", "buildVisitor"));
        }
        SASSSCSSElementVisitor sASSSCSSElementVisitor = new SASSSCSSElementVisitor(){

            @Override
            public void visitSassScssVariable(SassScssVariableImpl sassScssVariable) {
                CssInspectionsUtil.checkForProperlyResolving((PsiElement)sassScssVariable, (ProblemsHolder)holder, (String)SASSBundle.message("inspections.resolved.without.imports.message", sassScssVariable.getName()));
            }

            @Override
            public void visitInclude(SassScssInclude scssInclude) {
                PsiElement namedElement = scssInclude.getNameIdentifier();
                CssInspectionsUtil.checkForProperlyResolving((PsiElement)scssInclude, (PsiElement)(namedElement != null ? namedElement : scssInclude), (ProblemsHolder)holder, (String)SASSBundle.message("inspections.resolved.without.imports.message", scssInclude.getName()));
            }

            @Override
            public void visitPlaceholderSelector(SassScssPlaceholderSelectorImpl selector) {
                if (selector.isInsideExtendStatement()) {
                    CssInspectionsUtil.checkForProperlyResolving((PsiElement)selector, (ProblemsHolder)holder, (String)SASSBundle.message("inspections.resolved.without.imports.message", selector.getName()));
                }
            }

            public void visitElement(PsiElement element) {
                if (!(element.getContainingFile() instanceof SassScssStylesheetFile)) {
                    return;
                }
                if (element instanceof CssFunction) {
                    PsiElement nameIdentifier = ((CssFunction)element).getNameIdentifier();
                    boolean hasProblem = false;
                    for (PsiReference reference : element.getReferences()) {
                        if (reference instanceof SassScssFunctionReference) {
                            ResolveResult[] results = ((SassScssFunctionReference)reference).multiResolve(false);
                            hasProblem = hasProblem || results.length > 0;
                            for (ResolveResult result : results) {
                                if (!result.isValidResult()) continue;
                                hasProblem = false;
                            }
                            continue;
                        }
                        if (!(reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length > 0 : reference.resolve() != null)) continue;
                        return;
                    }
                    if (hasProblem) {
                        holder.registerProblem(nameIdentifier != null ? nameIdentifier : element, SASSBundle.message("inspections.resolved.without.imports.message", ((CssFunction)element).getName()), new LocalQuickFix[0]);
                    }
                }
                super.visitElement(element);
            }
        };
        if (sASSSCSSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/inspections/SassScssResolvedByNameOnlyInspection", "buildVisitor"));
        }
        return sASSSCSSElementVisitor;
    }
}

