/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.conflicts;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTrackerBase;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.FileTransferUtil;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.ExcludedPath;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.conflicts.RemoteChangeNotificationPanelCreator;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.PublishOptionsConfigurable;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteChangeNotifier
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)RemoteChangeNotifier.class.getName());
    private static final Key<EditorNotificationPanel> PANEL_KEY = Key.create((String)"remoteFilesConflictsPanel");
    private static final Key<Integer> VERSION_KEY = Key.create((String)"remoteFilesConflictsVersion");
    @NonNls
    private static final String REMOTE_FILES_MERGING_TOOL_WINDOW_GROUP = "Remote files merging";
    @NotNull
    private final Project myProject;
    private final FileEditorManager myFileEditorManager;
    private final PublishConfig myConfig;
    private final DeploymentRevisionTracker myRevisionTracker;
    private final Set<VirtualFile> myOpenFiles;
    private final AtomicInteger myFailureReported;
    private final Object LOCK;

    public static RemoteChangeNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "getInstance"));
        }
        return (RemoteChangeNotifier)((Object)project.getComponent(RemoteChangeNotifier.class));
    }

    protected RemoteChangeNotifier(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "<init>"));
        }
        super(project);
        this.myOpenFiles = new HashSet();
        this.myFailureReported = new AtomicInteger(0);
        this.LOCK = new Object();
        this.myProject = project;
        this.myFileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        this.myConfig = PublishConfig.getInstance(this.myProject);
        this.myRevisionTracker = ProjectDeploymentRevisionTracker.getInstance(this.myProject);
        MessageBusConnection connect = project.getMessageBus().connect((Disposable)project);
        connect.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$1", "fileClosed"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$1", "fileClosed"));
                }
                if (RemoteChangeNotifier.this.myConfig.isNotifyRemoteChanges() && source.getAllEditors(file).length == 0) {
                    RemoteChangeNotifier.this.myOpenFiles.remove(file);
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$1", "selectionChanged"));
                }
                if (RemoteChangeNotifier.this.myConfig.isNotifyRemoteChanges()) {
                    VirtualFile newFile = event.getNewFile();
                    if (newFile == null) {
                        return;
                    }
                    if (!newFile.isInLocalFileSystem()) {
                        return;
                    }
                    if (RemoteChangeNotifier.this.myOpenFiles.add(newFile)) {
                        RemoteChangeNotifier.this.updateNotifications(newFile);
                    }
                }
            }
        });
        connect.subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                this.update();
            }

            @Override
            public void optionsChanged() {
                this.update();
            }

            @Override
            public void excludedPathsChanged() {
                this.update();
            }

            private void update() {
                for (VirtualFile file : RemoteChangeNotifier.this.myFileEditorManager.getOpenFiles()) {
                    RemoteChangeNotifier.this.updateNotifications(file);
                }
                if (!RemoteChangeNotifier.this.myConfig.isNotifyRemoteChanges()) {
                    RemoteChangeNotifier.this.myOpenFiles.clear();
                }
            }
        });
    }

    public void updateNotificationsForRemoteItem(@NotNull FileObject fileObject, PublishConfig config, WebServerConfig serverConfig) throws FileSystemException {
        if (fileObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotificationsForRemoteItem"));
        }
        if (!serverConfig.getId().equals(config.getDefaultServerIdAndName().getFirst())) {
            return;
        }
        Pair<DeploymentPathMapping, Boolean> mappingPair = config.getNearestMappingDeploy2Local(fileObject, false, serverConfig);
        if (mappingPair.getFirst() != null) {
            FileObject source = ((DeploymentPathMapping)mappingPair.getFirst()).mapToLocalFile(fileObject, serverConfig);
            this.updateNotificationsForLocalItem(source);
        }
        Pair<List<DeploymentPathMapping>, Boolean> mappingCollectionPair = config.getChildMappingsDeploy2Local(fileObject, serverConfig);
        for (DeploymentPathMapping mapping : (List)mappingCollectionPair.getFirst()) {
            FileObject localRoot = DeploymentPathUtils.getLocalFile(mapping.getLocalPath());
            if (localRoot == null) continue;
            this.updateNotificationsForLocalItem(localRoot);
        }
    }

    public void updateNotificationsForLocalItem(@NotNull FileObject fileObject, @NotNull ExecutionContext context) throws FileSystemException {
        if (fileObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotificationsForLocalItem"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotificationsForLocalItem"));
        }
        if (!context.getServer().getId().equals(context.getConfig().getDefaultServerIdAndName().getFirst())) {
            return;
        }
        this.updateNotificationsForLocalItem(fileObject);
    }

    private void updateNotificationsForLocalItem(@NotNull FileObject fileObject) throws FileSystemException {
        if (fileObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotificationsForLocalItem"));
        }
        VirtualFile fileByURL = VfsUtil.findFileByURL((URL)fileObject.getURL());
        if (fileByURL != null) {
            this.updateNotifications(fileByURL);
        }
    }

    public void updateNotifications(@NotNull VirtualFile file, @NotNull PublishConfig publishConfig, @NotNull WebServerConfig server) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotifications"));
        }
        if (publishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotifications"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotifications"));
        }
        if (!server.getId().equals(publishConfig.getDefaultServerIdAndName().getFirst())) {
            return;
        }
        this.updateNotifications(file);
    }

    private void updateNotifications(final @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotifications"));
        }
        Runnable action = new Runnable(){

            @Override
            public void run() {
                if (RemoteChangeNotifier.this.myProject.isDisposed()) {
                    return;
                }
                String defaultServerId = (String)RemoteChangeNotifier.this.myConfig.getDefaultServerIdAndName().getFirst();
                if (defaultServerId == null) {
                    return;
                }
                final WebServerConfig serverConfig = WebServersConfigManager.getInstance(RemoteChangeNotifier.this.myProject).findServer(defaultServerId);
                if (serverConfig == null) {
                    return;
                }
                ArrayList<Object> files = new ArrayList<Object>();
                if (file.isDirectory()) {
                    for (VirtualFile vFile : RemoteChangeNotifier.this.myFileEditorManager.getOpenFiles()) {
                        if (!VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)vFile, (boolean)false)) continue;
                        files.add(vFile);
                    }
                } else if (RemoteChangeNotifier.this.myFileEditorManager.isFileOpen(file)) {
                    files.add(file);
                }
                for (final VirtualFile virtualFile : files) {
                    String title = WDBundle.message("progress.title.for.change.notifier", virtualFile.getPresentableName());
                    final int version = RemoteChangeNotifier.this.incAndGetNotificationVersion(virtualFile);
                    ProgressManager.getInstance().run((Task)new Task.Backgroundable(RemoteChangeNotifier.this.myProject, title, true){
                        private RemoteChangeNotificationPanelCreator myCreator;

                        public void run(@NotNull ProgressIndicator pi) {
                            if (pi == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$3$1", "run"));
                            }
                            this.myCreator = RemoteChangeNotifier.this.getNotificationCreator(virtualFile, pi, serverConfig);
                        }

                        public void onCancel() {
                            this.myCreator = new RemoteChangeNotificationPanelCreator.Cancel(virtualFile, RemoteChangeNotifier.this.myProject, RemoteChangeNotifier.this.myConfig, serverConfig);
                            RemoteChangeNotifier.this.updateNotificationForAllEditors(virtualFile, this.myCreator, version);
                        }

                        public void onSuccess() {
                            RemoteChangeNotifier.this.updateNotificationForAllEditors(virtualFile, this.myCreator, version);
                        }
                    });
                }
            }
        };
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeLater(action);
        } else {
            action.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationForAllEditors(@NotNull VirtualFile file, @Nullable RemoteChangeNotificationPanelCreator creator, int version) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotificationForAllEditors"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (version < this.getNotificationVersion(file)) {
                return;
            }
            for (FileEditor editor : this.myFileEditorManager.getAllEditors(file)) {
                this.updateNotificationForTheEditor(file, editor, creator == null ? null : creator.createPanel(editor));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incAndGetNotificationVersion(VirtualFile file) {
        Object object = this.LOCK;
        synchronized (object) {
            Integer version = (Integer)file.getUserData(VERSION_KEY);
            version = version == null ? Integer.valueOf(0) : Integer.valueOf(version + 1);
            file.putUserData(VERSION_KEY, (Object)version);
            return version;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNotificationVersion(VirtualFile file) {
        Object object = this.LOCK;
        synchronized (object) {
            Integer version = (Integer)file.getUserData(VERSION_KEY);
            if (version == null) {
                version = 0;
                file.putUserData(VERSION_KEY, (Object)version);
            }
            return version;
        }
    }

    public void hideNotification(@NotNull VirtualFile file, @NotNull FileEditor editor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "hideNotification"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "hideNotification"));
        }
        this.updateNotificationForTheEditor(file, editor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationForTheEditor(@NotNull VirtualFile file, @NotNull FileEditor editor, @Nullable EditorNotificationPanel component) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotificationForTheEditor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "updateNotificationForTheEditor"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            EditorNotificationPanel old = (EditorNotificationPanel)editor.getUserData(PANEL_KEY);
            if (old != null) {
                LOG.debug("old " + old);
                this.myFileEditorManager.removeTopComponent(editor, (JComponent)old);
            }
            if (component != null) {
                LOG.debug("new " + component);
                this.myFileEditorManager.addTopComponent(editor, (JComponent)component);
                editor.putUserData(PANEL_KEY, (Object)component);
            } else {
                editor.putUserData(PANEL_KEY, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RemoteChangeNotificationPanelCreator getNotificationCreator(final @NotNull VirtualFile file, final @NotNull ProgressIndicator pi, final @NotNull WebServerConfig serverConfig) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "getNotificationCreator"));
        }
        if (pi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "getNotificationCreator"));
        }
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "getNotificationCreator"));
        }
        if (!this.myConfig.isNotifyRemoteChanges()) {
            return null;
        }
        assert (this.myConfig.getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE);
        if (!serverConfig.needsTransfer() || serverConfig.getFileTransferConfig().validateFast() != null) {
            return null;
        }
        final DeploymentRevisionTracker.Revision revision = this.myRevisionTracker.getBaseRevision(file.getPath(), serverConfig);
        final DeploymentPathMapping mapping = (DeploymentPathMapping)this.myConfig.getNearestMappingForLocal(file.getPath(), false, true, false, serverConfig).getFirst();
        if (mapping == null) {
            return null;
        }
        final WebServerConfig.RemotePath remotePath = mapping.mapToDeployPath(file.getPath(), serverConfig);
        for (ExcludedPath excludedPath : this.myConfig.getExcludedPaths(serverConfig.getId())) {
            if (excludedPath.isLocal() || !excludedPath.isParentForRemotePath(remotePath, serverConfig)) continue;
            return null;
        }
        if (!AuthHelper.ensureAuthSpecified(serverConfig, this.myProject)) {
            return null;
        }
        final Ref resultRef = new Ref();
        final Ref exceptionRef = new Ref();
        RemoteConnection connection = null;
        try {
            final RemoteConnection finalConnection = connection = RemoteConnectionManager.getInstance().openConnection(ConnectionOwnerFactory.createConnectionOwner(this.myProject), WDBundle.message("browse.0", remotePath.path), serverConfig, FileTransferConfig.Origin.Default, null, pi);
            connection.executeServerOperation(new ThrowableRunnable<FileSystemException>(){

                public void run() throws FileSystemException {
                    FileObject remoteFile = serverConfig.findFile(finalConnection.getFileSystem(), remotePath);
                    if (remoteFile != null) {
                        remoteFile.refresh();
                        FileObject parent = remoteFile.getParent();
                        if (parent != null) {
                            parent.refresh();
                        }
                    }
                    if (pi.isCanceled()) {
                        return;
                    }
                    try {
                        if (remoteFile == null || !remoteFile.exists()) {
                            resultRef.set((Object)new RemoteChangeNotificationPanelCreator.Delete(file, serverConfig, RemoteChangeNotifier.this.myProject));
                            return;
                        }
                        if (pi.isCanceled()) {
                            return;
                        }
                        if (remoteFile.getContent().getSize() > DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
                            resultRef.set((Object)new RemoteChangeNotificationPanelCreator.TooLargeFile(file, serverConfig, RemoteChangeNotifier.this.myProject, remoteFile, mapping));
                            return;
                        }
                        if (pi.isCanceled()) {
                            return;
                        }
                        if (!RemoteChangeNotifier.isRemoteFileChangedAndLocalFileDifferentFromRemote(RemoteChangeNotifier.this.myProject, remoteFile, file, serverConfig, revision, RemoteChangeNotifier.this.myConfig.getPromptOnRemoteOverwrite(), pi)) {
                            LOG.debug("Changed: false; file: " + remoteFile.getName().getPath());
                            return;
                        }
                        LOG.debug("Changed: true; file: " + remoteFile.getName().getPath());
                        resultRef.set((Object)new RemoteChangeNotificationPanelCreator.Update(file, serverConfig, RemoteChangeNotifier.this.myConfig, revision, RemoteChangeNotifier.this.myProject));
                    }
                    catch (IOException e) {
                        exceptionRef.set((Object)e);
                    }
                }
            }, pi);
        }
        catch (FileSystemException e) {
            int reports = this.myFailureReported.incrementAndGet();
            RemoteChangeNotifier.showErrorMessage(WDBundle.message("operation.failed", WDBundle.message("error.message.remote.file.0.loading", remotePath), StringUtil.decapitalize((String)PublishUtils.getMessage(e, true))), serverConfig, this.myProject, this.myConfig, reports == 1);
            RemoteChangeNotifier.complainOnFailures(reports, this.myProject, serverConfig, StringUtil.decapitalize((String)PublishUtils.getMessage(e, true)));
            if (PublishUtils.isAuthFail(e)) {
                PublishUtils.clearPasswordIfNotStored(serverConfig.getFileTransferConfig());
            }
            RemoteChangeNotificationPanelCreator remoteChangeNotificationPanelCreator = null;
            return remoteChangeNotificationPanelCreator;
        }
        finally {
            if (connection != null) {
                connection.release();
            }
        }
        if (!exceptionRef.isNull()) {
            IOException e = (IOException)exceptionRef.get();
            LOG.warn((Throwable)e);
            int reports = this.myFailureReported.incrementAndGet();
            RemoteChangeNotifier.showErrorMessage(WDBundle.message("failed.to.check.remote.file.0", remotePath.path, StringUtil.decapitalize((String)PublishUtils.getMessage(e, true))), serverConfig, this.myProject, this.myConfig, reports == 1);
            RemoteChangeNotifier.complainOnFailures(reports, this.myProject, serverConfig, StringUtil.decapitalize((String)PublishUtils.getMessage(e, true)));
            return null;
        }
        this.myFailureReported.set(0);
        return (RemoteChangeNotificationPanelCreator)resultRef.get();
    }

    private static boolean isRemoteFileChangedAndLocalFileDifferentFromRemote(@NotNull Project project, @NotNull FileObject remoteFile, @NotNull VirtualFile local, WebServerConfig serverConfig, @Nullable DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "isRemoteFileChangedAndLocalFileDifferentFromRemote"));
        }
        if (remoteFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteFile", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "isRemoteFileChangedAndLocalFileDifferentFromRemote"));
        }
        if (local == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "isRemoteFileChangedAndLocalFileDifferentFromRemote"));
        }
        if (baseRevision == null) {
            return !RemoteChangeNotifier.compareFilesAndCreateRevisionIfEqual(project, remoteFile, local, serverConfig, promptOnRemoteOverwrite, pi);
        }
        boolean remoteFileUnchanged = RemoteChangeNotifier.isFileEqualToRevision(remoteFile, serverConfig, baseRevision, promptOnRemoteOverwrite, pi);
        if (remoteFileUnchanged) {
            return false;
        }
        return !RemoteChangeNotifier.compareFilesAndCreateRevisionIfEqual(project, remoteFile, local, serverConfig, promptOnRemoteOverwrite, pi);
    }

    private static boolean compareFilesAndCreateRevisionIfEqual(Project project, FileObject remoteFile, VirtualFile local, WebServerConfig serverConfig, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        FileObject localFile = DeploymentPathUtils.getLocalFile(local.getPath());
        if (localFile == null) {
            return false;
        }
        FileContent remoteFileContent = remoteFile.getContent();
        FileContent localFileContent = localFile.getContent();
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
            boolean equal;
            boolean accurateTimestamp = serverConfig.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            long currentRemoteTimestamp = remoteFileContent.getLastModifiedTime(accurateTimestamp);
            long currentLocalTimestamp = localFileContent.getLastModifiedTime(accurateTimestamp);
            boolean bl = equal = TransferOperation.areTimestampsEqual(currentLocalTimestamp, currentRemoteTimestamp, localFile.getFileSystem().getLastModTimeAccuracy() + remoteFile.getFileSystem().getLastModTimeAccuracy()) && localFileContent.getSize() == remoteFileContent.getSize();
            if (equal) {
                RemoteChangeNotifier.createRevision(project, local.getPath(), RemoteChangeNotifier.getContent(localFile, pi, true), currentRemoteTimestamp, serverConfig);
            }
            return equal;
        }
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_CONTENT) {
            byte[] localContent;
            if (remoteFileContent.getSize() != localFileContent.getSize()) {
                return false;
            }
            byte[] remoteContent = RemoteChangeNotifier.getContent(remoteFile, pi, false);
            boolean equal = Arrays.equals(remoteContent, localContent = RemoteChangeNotifier.getContent(localFile, pi, true));
            if (equal) {
                boolean accurateTimestamp = serverConfig.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
                long currentRemoteTimestamp = remoteFileContent.getLastModifiedTime(accurateTimestamp);
                RemoteChangeNotifier.createRevision(project, local.getPath(), localContent, currentRemoteTimestamp, serverConfig);
            }
            return equal;
        }
        throw new IllegalStateException("PublishConfig.PromptOnRemoteOverwrite.NONE is not expected here");
    }

    public static byte[] getContent(FileObject file, ProgressIndicator pi, boolean isLocal) throws CustomFileSystemException {
        try {
            return FileTransferUtil.getContent(file, pi);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            throw new CustomFileSystemException(WDBundle.message(isLocal ? "failed.to.load.local.file.0.content" : "failed.to.load.remote.file.0.content", file.getName().getPath()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void createRevision(@NotNull Project project, String path, final @NotNull byte[] content, final long timestamp, @NotNull WebServerConfig webServerConfig) throws IOException {
        void server;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "createRevision"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "createRevision"));
        }
        if (webServerConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier", "createRevision"));
        }
        if ((long)content.length > DeploymentRevisionTrackerBase.MAX_FILE_SIZE) {
            LOG.warn("File " + path + "  is larger than " + DeploymentRevisionTrackerBase.MAX_FILE_SIZE + " bytes, its base revision will not be stored");
            return;
        }
        LOG.debug("Creating revision for '" + path + "' from RemoteChangeNotifier");
        DeploymentRevisionTracker tracker = ProjectDeploymentRevisionTracker.getInstance(project);
        LOG.assertTrue(tracker != null, (Object)("No tracker for a given project - " + project));
        ThrowableComputable<DeploymentRevisionTracker.Revision, IOException> revisionFactory = new ThrowableComputable<DeploymentRevisionTracker.Revision, IOException>(){

            public DeploymentRevisionTracker.Revision compute() throws IOException {
                return new DeploymentRevisionTracker.Revision(timestamp, content);
            }
        };
        tracker.putBaseRevision(path, server.clone(), revisionFactory);
    }

    public static boolean isFileChanged(@Nullable FileObject source, WebServerConfig serverConfig, @Nullable DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        if (source == null || !source.exists()) {
            return baseRevision != null;
        }
        if (baseRevision == null) {
            return true;
        }
        return !RemoteChangeNotifier.isFileEqualToRevision(source, serverConfig, baseRevision, promptOnRemoteOverwrite, pi);
    }

    public static boolean isFileEqualToRevision(FileObject source, DeploymentRevisionTracker.Revision baseRevision, ExecutionContext context) throws IOException {
        return RemoteChangeNotifier.isFileEqualToRevision(source, context.getServer(), baseRevision, context.getConfig().getPromptOnRemoteOverwrite(), context.getProgressIndicator());
    }

    private static boolean isFileEqualToRevision(FileObject source, WebServerConfig serverConfig, DeploymentRevisionTracker.Revision baseRevision, PublishConfig.PromptOnRemoteOverwrite promptOnRemoteOverwrite, @Nullable ProgressIndicator pi) throws IOException {
        LOG.debug("source " + source.getName().getPath());
        if (promptOnRemoteOverwrite == PublishConfig.PromptOnRemoteOverwrite.CHECK_TIMESTAMP) {
            boolean accurateTimestamp = serverConfig.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps() != AdvancedOptionsConfig.AccurateTimestamps.NEVER;
            long currentRemoteTimestamp = source.getContent().getLastModifiedTime(accurateTimestamp);
            LOG.debug("Timestamps\n local: " + source.getFileSystem().getLastModTimeAccuracy() + "\nremote: " + currentRemoteTimestamp + "\n revision: " + baseRevision.timestamp);
            return TransferOperation.areTimestampsEqual(baseRevision.timestamp, currentRemoteTimestamp, source.getFileSystem().getLastModTimeAccuracy()) && source.getContent().getSize() == (long)baseRevision.content.length;
        }
        LOG.debug("Content\n local: " + new String(FileTransferUtil.getContent(source, pi)) + "\n revision: " + new String(baseRevision.content));
        return Arrays.equals(baseRevision.content, FileTransferUtil.getContent(source, pi));
    }

    private static void showErrorMessage(String message, WebServerConfig serverConfig, Project project, PublishConfig config, boolean showBalloon) {
        if (project.isDisposed()) {
            return;
        }
        FileTransferToolWindow.printWithTimestamp(project, serverConfig, message, ConsoleViewContentType.ERROR_OUTPUT, config.getTraceLevel());
        if (showBalloon) {
            NotificationGroup.toolWindowGroup((String)REMOTE_FILES_MERGING_TOOL_WINDOW_GROUP, (String)"File Transfer").createNotification(message, MessageType.ERROR).notify(project);
        }
    }

    private static void complainOnFailures(int number, final Project project, WebServerConfig serverConfig, String failure) {
        if (number == 10 && !project.isDisposed()) {
            NotificationListener listener = new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$6", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/conflicts/RemoteChangeNotifier$6", "hyperlinkUpdate"));
                    }
                    if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)new PublishOptionsConfigurable(project));
                    }
                }
            };
            DeploymentNotifier.notifyWithBalloon(WDBundle.message("constantly.fail.to.connect.to.server.0.maybe.configure.turn.off.auto.notification", serverConfig.getName()), failure, NotificationType.WARNING, listener, project, FileTransferToolWindow.ID_PROVIDER);
        }
    }
}

