/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit.fs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.SmartList;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.remoteEdit.notification.RemoteEditEditorDecorator;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDeploymentFileSystem
extends DeprecatedVirtualFileSystem
implements FileEditorManagerListener,
FileEditorManagerListener.Before {
    private static final Logger LOG = Logger.getInstance(RemoteDeploymentFileSystem.class);
    @NonNls
    private static final String PROTOCOL = "REMOTE_DEPLOYMENT_FS";
    private static final String MESSAGES_TITLE = WDBundle.message("remote.edit.fs.messages.title", new Object[0]);
    private final ConcurrentHashMap<String, RemoteVirtualFile> myOpenFiles = new ConcurrentHashMap();

    public static RemoteDeploymentFileSystem getInstance() {
        return (RemoteDeploymentFileSystem)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    public RemoteDeploymentFileSystem() {
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)this);
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        busConnection.subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    VirtualFile[] files;
                    FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.getInstanceEx((Project)project);
                    for (VirtualFile file : files = fileEditorManagerEx.getOpenFiles()) {
                        if (!(file instanceof RemoteVirtualFile)) continue;
                        fileEditorManagerEx.updateFilePresentation(file);
                    }
                }
            }

            @Override
            public void optionsChanged() {
            }

            @Override
            public void excludedPathsChanged() {
            }
        });
        ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)new ProjectListener());
        this.startEventPropagation();
        this.addVirtualFileListener((VirtualFileListener)new VirtualFileAdapter(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem$2", "contentsChanged"));
                }
                VirtualFile file = event.getFile();
                if (!(file instanceof RemoteVirtualFile)) {
                    return;
                }
                RemoteEditEditorDecorator.updateDecorators((RemoteVirtualFile)file);
            }
        });
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "getProtocol"));
        }
        return PROTOCOL;
    }

    @Nullable
    public RemoteVirtualFile checkAndGetFileIfOpened(String url) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        RemoteVirtualFile file = this.myOpenFiles.get(url);
        if (file == null) {
            return null;
        }
        if (RemoteDeploymentFileSystem.isFileOpenInSomeEditor(file)) {
            return file;
        }
        this.myOpenFiles.remove(url);
        return null;
    }

    @NotNull
    public RemoteVirtualFile constructFileByNodeServerAndContent(@NotNull FileObject node, @NotNull WebServerConfig config, @NotNull byte[] content, RemoteConnection connection, @Nullable String presentableServerName) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructFileByNodeServerAndContent"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructFileByNodeServerAndContent"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructFileByNodeServerAndContent"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String name = node.getName().getBaseName();
        String nodePath = RemoteDeploymentFileSystem.getPath(node, config);
        String path = RemoteDeploymentFileSystem.constructIdPath(nodePath, config);
        String url = RemoteDeploymentFileSystem.constructURL(nodePath, config);
        RemoteVirtualFile file = new RemoteVirtualFile(this, path, name, content, config, connection, node, presentableServerName);
        RemoteVirtualFile lastSavedFile = this.myOpenFiles.putIfAbsent(url, file);
        RemoteVirtualFile remoteVirtualFile = lastSavedFile == null ? file : lastSavedFile;
        if (remoteVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructFileByNodeServerAndContent"));
        }
        return remoteVirtualFile;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull @NonNls String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "findFileByPath"));
        }
        return this.myOpenFiles.get(path);
    }

    public void refresh(boolean asynchronous) {
        throw new UnsupportedOperationException("refresh is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "refreshAndFindFileByPath"));
        }
        throw new UnsupportedOperationException("refreshAndFindFileByPath is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "deleteFile"));
        }
        throw new UnsupportedOperationException("deleteFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "moveFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "moveFile"));
        }
        throw new UnsupportedOperationException("moveFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "renameFile"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "renameFile"));
        }
        throw new UnsupportedOperationException("renameFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "createChildFile"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "createChildFile"));
        }
        throw new UnsupportedOperationException("createChildFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vDir", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "createChildDirectory"));
        }
        if (dirName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirName", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "createChildDirectory"));
        }
        throw new UnsupportedOperationException("createChildDirectory is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "copyFile"));
        }
        if (newParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParent", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "copyFile"));
        }
        if (copyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyName", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "copyFile"));
        }
        throw new UnsupportedOperationException("copyFile is not implemented in : " + ((Object)((Object)this)).getClass());
    }

    public static String constructURL(@NotNull FileObject fileObject, @NotNull WebServerConfig config) {
        if (fileObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructURL"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructURL"));
        }
        return RemoteDeploymentFileSystem.constructURL(RemoteDeploymentFileSystem.getPath(fileObject, config), config);
    }

    public static String constructURL(@NotNull String nodePath, @NotNull WebServerConfig config) {
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructURL"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructURL"));
        }
        return RemoteDeploymentFileSystem.constructIdURL(nodePath, config);
    }

    public boolean isReadOnly() {
        return false;
    }

    public void fireBeforeContentsChange(Object requestor, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "fireBeforeContentsChange"));
        }
        super.fireBeforeContentsChange(requestor, file);
    }

    public void fireContentsChanged(Object requestor, @NotNull VirtualFile file, long oldModificationStamp) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "fireContentsChanged"));
        }
        super.fireContentsChanged(requestor, file, oldModificationStamp);
    }

    private static String constructIdURL(@NotNull String nodePath, @NotNull WebServerConfig config) {
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructIdURL"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructIdURL"));
        }
        return "REMOTE_DEPLOYMENT_FS://" + RemoteDeploymentFileSystem.constructIdPath(nodePath, config);
    }

    private static String constructIdPath(@NotNull String nodePath, @NotNull WebServerConfig config) {
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructIdPath"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "constructIdPath"));
        }
        return "<" + config.getId() + ">/" + nodePath;
    }

    private static String getPath(@NotNull FileObject fileObject, @NotNull WebServerConfig config) {
        int i;
        if (fileObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "getPath"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "getPath"));
        }
        String path = config.getRemotePath(fileObject).toString();
        for (i = 0; i < path.length() && (path.charAt(i) == '\\' || path.charAt(i) == '/'); ++i) {
        }
        return path.substring(i);
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "fileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "fileOpened"));
        }
        if (!(file instanceof RemoteVirtualFile)) {
            return;
        }
        RemoteEditEditorDecorator.updateDecorators(source, (RemoteVirtualFile)file);
    }

    public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "fileClosed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "fileClosed"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!(file instanceof RemoteVirtualFile)) {
            return;
        }
        RemoteVirtualFile remoteVirtualFile = (RemoteVirtualFile)file;
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(file);
        if (!remoteVirtualFile.isChanged(document)) {
            return;
        }
        String message = WDBundle.message("remote.edit.remote.file.0.was.closed.and", remoteVirtualFile.getPresentableName());
        int choice = Messages.showYesNoDialog((Project)source.getProject(), (String)message, (String)MESSAGES_TITLE, (Icon)Messages.getQuestionIcon());
        if (choice == 1) {
            if (RemoteDeploymentFileSystem.isFileOpenInSomeEditor(file)) {
                return;
            }
            this.myOpenFiles.remove(file.getUrl());
        } else {
            new OpenFileDescriptor(source.getProject(), file).navigate(true);
        }
    }

    private static boolean isFileOpenInSomeEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "isFileOpenInSomeEditor"));
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (!FileEditorManager.getInstance((Project)project).isFileOpen(file)) continue;
            return true;
        }
        return false;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "selectionChanged"));
        }
    }

    public void beforeFileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "beforeFileOpened"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "beforeFileOpened"));
        }
    }

    public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "beforeFileClosed"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/fs/RemoteDeploymentFileSystem", "beforeFileClosed"));
        }
    }

    private class ProjectListener
    extends ProjectManagerAdapter {
        private ProjectListener() {
        }

        public boolean canCloseProject(Project project) {
            String message;
            SmartList openFiles = new SmartList();
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
            FileDocumentManager documentManager = FileDocumentManager.getInstance();
            for (RemoteVirtualFile file : RemoteDeploymentFileSystem.this.myOpenFiles.values()) {
                Document document;
                if (editorManager.getEditors((VirtualFile)file).length == 0 || !file.isChanged(document = documentManager.getDocument((VirtualFile)file))) continue;
                openFiles.add(file);
            }
            if (openFiles.isEmpty()) {
                return true;
            }
            if (openFiles.size() == 1) {
                message = WDBundle.message("remote.edit.close.project.message", ((RemoteVirtualFile)((Object)openFiles.get(0))).getPresentableName());
            } else {
                StringBuilder messageBuilder = new StringBuilder();
                messageBuilder.append(WDBundle.message("remote.edit.some.remote.files.are.opened.for.editing.and.their.changes.are.not.uploaded", new Object[0])).append("\n");
                for (RemoteVirtualFile file : openFiles) {
                    messageBuilder.append('\'').append(file.getPresentableName()).append("'\n");
                }
                messageBuilder.append(WDBundle.message("remote.edit.do.you.want.to.close.the.project.and.lose.them", new Object[0]));
                message = messageBuilder.toString();
            }
            int choice = Messages.showYesNoDialog((Project)project, (String)message, (String)MESSAGES_TITLE, (Icon)Messages.getQuestionIcon());
            if (choice == 1) {
                return false;
            }
            for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
                VirtualFile[] files;
                if (openProject == project) continue;
                for (VirtualFile file : files = FileEditorManager.getInstance((Project)openProject).getOpenFiles()) {
                    if (!(file instanceof RemoteVirtualFile)) continue;
                    openFiles.remove(file);
                }
            }
            RemoteDeploymentFileSystem.this.myOpenFiles.values().removeAll((Collection<?>)openFiles);
            return true;
        }
    }
}

