/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.remoteEdit.notification;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteEditedFilesUploadingService;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class RemoteEditEditorDecorator
extends EditorNotificationPanel {
    private static final Logger LOG = Logger.getInstance(RemoteEditEditorDecorator.class);
    private static final Key<RemoteEditEditorDecorator> PANEL_KEY = Key.create((String)"remoteFilesEditPanel");
    private final List<ActionButton> myActions = new ArrayList<ActionButton>();
    private volatile boolean myChanged;

    public static void updateDecorators(@NotNull RemoteVirtualFile file) {
        Project[] projects;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "updateDecorators"));
        }
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)file);
        token.finish();
        boolean changed = file.isChanged(document);
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            RemoteEditEditorDecorator.updateDecorators(file, FileEditorManager.getInstance((Project)project), changed);
        }
    }

    public static void updateDecorators(@NotNull FileEditorManager manager, @NotNull RemoteVirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "updateDecorators"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "updateDecorators"));
        }
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)file);
        token.finish();
        boolean changed = file.isChanged(document);
        RemoteEditEditorDecorator.updateDecorators(file, manager, changed);
    }

    private static void updateDecorators(@NotNull RemoteVirtualFile file, @NotNull FileEditorManager manager, boolean changed) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "updateDecorators"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "updateDecorators"));
        }
        for (FileEditor editor : manager.getAllEditors((VirtualFile)file)) {
            RemoteEditEditorDecorator.updateDecorator(file, manager, editor, changed);
        }
    }

    private static void updateDecorator(@NotNull RemoteVirtualFile file, @NotNull FileEditorManager manager, @NotNull FileEditor editor, boolean changed) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "updateDecorator"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "updateDecorator"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "updateDecorator"));
        }
        RemoteEditEditorDecorator decorator = RemoteEditEditorDecorator.getOrCreatePanelForTheEditor(manager, editor, file);
        decorator.update(changed);
    }

    private static RemoteEditEditorDecorator getOrCreatePanelForTheEditor(@NotNull FileEditorManager manager, @NotNull FileEditor editor, @NotNull RemoteVirtualFile file) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "getOrCreatePanelForTheEditor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "getOrCreatePanelForTheEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator", "getOrCreatePanelForTheEditor"));
        }
        RemoteEditEditorDecorator old = (RemoteEditEditorDecorator)((Object)editor.getUserData(PANEL_KEY));
        if (old != null) {
            return old;
        }
        RemoteEditEditorDecorator.tryToListenToEditorUpdates(editor);
        RemoteEditEditorDecorator newPanel = new RemoteEditEditorDecorator(file, editor instanceof TextEditor);
        manager.addTopComponent(editor, (JComponent)((Object)newPanel));
        editor.putUserData(PANEL_KEY, (Object)newPanel);
        return newPanel;
    }

    private static void tryToListenToEditorUpdates(FileEditor fileEditor) {
        if (!(fileEditor instanceof TextEditor)) {
            return;
        }
        Editor editor = ((TextEditor)fileEditor).getEditor();
        editor.getDocument().addDocumentListener((DocumentListener)new UpdateNotificationsDocumentAdapter());
    }

    public RemoteEditEditorDecorator(RemoteVirtualFile file, boolean isTextFile) {
        this.initializeActions(file, isTextFile);
        this.myChanged = true;
        this.update(false);
    }

    private void initializeActions(RemoteVirtualFile file, boolean isTextFile) {
        DiffAction diffAction = new DiffAction(file);
        this.myActions.add(RemoteEditEditorDecorator.createButton(diffAction));
        RevertAction revertAction = new RevertAction(file);
        ActionButton button = RemoteEditEditorDecorator.createButton(revertAction);
        button.setEnabled(isTextFile);
        this.myActions.add(button);
        UploadAction uploadAction = new UploadAction(file);
        this.myActions.add(RemoteEditEditorDecorator.createButton(uploadAction));
        this.myLinksPanel.setLayout(new FlowLayout());
        for (ActionButton action : this.myActions) {
            this.myLinksPanel.add((Component)action);
        }
        this.myLinksPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setPreferredSize(new Dimension(-1, this.myLinksPanel.getPreferredSize().height));
    }

    private static ActionButton createButton(AnAction action) {
        Icon icon = action.getTemplatePresentation().getIcon();
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        ActionButton button = new ActionButton(action, action.getTemplatePresentation(), "unknown", new Dimension(width, height));
        button.setIconInsets(new Insets(2, 2, 2, 2));
        return button;
    }

    private void update(final boolean changed) {
        if (this.myChanged == changed) {
            return;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                RemoteEditEditorDecorator.this.setText(changed ? WDBundle.message("remote.edit.the.file.is.changed.upload", new Object[0]) : WDBundle.message("remote.edit.the.file.is.identical.to.remote.one", new Object[0]));
                RemoteEditEditorDecorator.this.myChanged = changed;
                for (ActionButton action : RemoteEditEditorDecorator.this.myActions) {
                    if (!(action.getAction() instanceof RevertAction)) continue;
                    action.setEnabled(changed);
                }
            }
        });
    }

    private static class UploadAction
    extends AnAction {
        private final RemoteVirtualFile myFile;

        private UploadAction(@NotNull RemoteVirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator$UploadAction", "<init>"));
            }
            this.myFile = file;
            this.copyFrom(ActionManager.getInstance().getAction("WD.UploadCurrentRemoteFileAction"));
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return;
            }
            ApplicationManager.getApplication().saveAll();
            RemoteEditedFilesUploadingService.getInstance(project).queueUpload(this.myFile);
        }
    }

    private static class RevertAction
    extends AnAction {
        private final RemoteVirtualFile myFile;

        private RevertAction(@NotNull RemoteVirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator$RevertAction", "<init>"));
            }
            super(WDBundle.message("remote.edit.revert.action.title", new Object[0]), WDBundle.message("remote.edit.revert.action.title", new Object[0]), AllIcons.Actions.Rollback);
            this.myFile = file;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return;
            }
            final Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)this.myFile);
            if (document == null) {
                return;
            }
            final Runnable action = new Runnable(){

                @Override
                public void run() {
                    FileDocumentManager.getInstance().saveDocument(document);
                    myFile.revert(document);
                    FileDocumentManager.getInstance().saveDocument(document);
                }
            };
            CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                @Override
                public void run() {
                    ApplicationManager.getApplication().runWriteAction(action);
                }
            }, WDBundle.message("remote.edit.revert.edited.remote.file", new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)document), document);
        }
    }

    private static class DiffAction
    extends AnAction {
        private final RemoteVirtualFile myFile;

        private DiffAction(@NotNull RemoteVirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/plugins/webDeployment/remoteEdit/notification/RemoteEditEditorDecorator$DiffAction", "<init>"));
            }
            super(WDBundle.message("remote.edit.diff.action.title", new Object[0]), WDBundle.message("remote.edit.diff.action.title", new Object[0]), AllIcons.Actions.Diff);
            this.myFile = file;
        }

        public void actionPerformed(AnActionEvent e) {
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return;
            }
            ApplicationManager.getApplication().saveAll();
            try {
                DiffContent docContent = DiffContentFactory.getInstance().create(project, (VirtualFile)this.myFile);
                DiffContent savedContent = DiffContentFactory.getInstance().createFromBytes(project, (VirtualFile)this.myFile, this.myFile.getLastSyncedContent());
                SimpleDiffRequest diffData = new SimpleDiffRequest(this.myFile.getName(), savedContent, docContent, WDBundle.message("remote.edit.last.uploaded", new Object[0]), WDBundle.message("remote.edit.current.content", new Object[0]));
                DiffManager.getInstance().showDiff(project, (DiffRequest)diffData);
            }
            catch (IOException err) {
                LOG.error((Throwable)err);
            }
        }
    }

    private static class UpdateNotificationsDocumentAdapter
    extends DocumentAdapter {
        private UpdateNotificationsDocumentAdapter() {
        }

        public void documentChanged(DocumentEvent event) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(event.getDocument());
            if (!(virtualFile instanceof RemoteVirtualFile)) {
                return;
            }
            RemoteEditEditorDecorator.updateDecorators((RemoteVirtualFile)virtualFile);
        }
    }
}

