/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HoverHyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.UriUtil;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.AdvancedOptionsDialog;
import com.jetbrains.plugins.webDeployment.ui.BrowseMountedFolderActionListener;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.Util;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebServerConfigForm
implements UnnamedConfigurable,
Iconable {
    private static final Logger LOG = Logger.getInstance((String)WebServerConfigForm.class.getName());
    private static final long VALIDATE_TIMEOUT = 200L;
    private static final long CHECK_PASSPHRASE_TIMEOUT_MS = 100L;
    private static final String AUTH_PASSWORD = WDBundle.message("auth.password", new Object[0]);
    private static final String AUTH_KEYPAIR = WDBundle.message("auth.keypair", new Object[0]);
    private JPanel myContentPane;
    private JTextField myHostField;
    private JTextField myPortField;
    private JTextField myUsernameField;
    private JPasswordField myPasswordField;
    private JCheckBox mySavePasswordCheckBox;
    private JLabel myMessageLabel;
    private JButton myTestConnectionButton;
    private JCheckBox myAnonymousCheckBox;
    private JTextField myUrlField;
    private JLabel myPasswordLabel;
    private TextFieldWithBrowseButton myPrivateKeyFileField;
    private JLabel myPrivateKeyFileLabel;
    private JPasswordField myPassphraseField;
    private JLabel myPassphraseLabel;
    private JComboBox myAuthTypeCombo;
    private JLabel myAuthTypeLabel;
    private JCheckBox mySavePassphraseCheckbox;
    private JComboBox myAccessTypeCombo;
    private JButton myAdvancedOptionsButton;
    private JLabel myHostLabel;
    private JLabel myRootFolderLabel;
    private TextFieldWithBrowseButton.NoPathCompletion myRootFolderField;
    private JButton myAutodetectButton;
    private JButton myOpenUrlButton;
    private TextFieldWithBrowseButton myMountedFolderField;
    private JLabel myMountedFolderLabel;
    private JLabel myPortLabel;
    private JLabel myUsernameLabel;
    private JPanel mySpacer1;
    private JPanel mySpacer2;
    private JLabel myAccessTypeLabel;
    private JPanel myUploadPanel;
    private JPanel mySpacer3;
    private HoverHyperlinkLabel myFixLink;
    private JLabel myAccessTypeDescriptionLabel;
    private JRadioButton myExplicitFTPSRadioButton;
    private JRadioButton myImplicitFTPSRadioButton;
    private JPanel mySpacer4;
    private JBCheckBox myProjectLevelCheckBox;
    private boolean mySlowValidationTimedOut;
    private WebServerConfig myItem;
    private boolean myPasswordIsSpecified;
    private boolean myPassphraseIsSpecified;
    private String myInitialPort;
    private final EventDispatcher<Listener> myEventDispatcher;
    private final EventDispatcher<AccessTypeChangeListener> myAccessTypeEventDispatcher;
    private AdvancedOptionsConfig myAdvancedOptions;
    private AccessType myPreviousAccessType;
    private String myForbiddenChildPath;
    private String myPreviousHostValue;
    private boolean myMuted;

    public WebServerConfigForm(WebServerConfig item, final Project project) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.myAccessTypeEventDispatcher = EventDispatcher.create(AccessTypeChangeListener.class);
        this.myAdvancedOptions = new AdvancedOptionsConfig();
        this.myItem = item;
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myProjectLevelCheckBox.setVisible(project != null && !project.isDefault());
        this.updateAccessTypes(new AccessType[0]);
        this.myAccessTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServerConfigForm.this.updateOnAccessTypeChange();
                WebServerConfigForm.this.myPreviousAccessType = (AccessType)((Object)WebServerConfigForm.this.myAccessTypeCombo.getSelectedItem());
                ((AccessTypeChangeListener)WebServerConfigForm.this.myAccessTypeEventDispatcher.getMulticaster()).changed();
            }
        });
        this.myAccessTypeCombo.setRenderer(new AccessTypeComboRenderer(this.myAccessTypeCombo.getRenderer()));
        this.myAnonymousCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServerConfigForm.this.updateOnAnonymousChange();
            }
        });
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myContentPane);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                WebServerConfigForm.this.fireChanged();
            }
        });
        this.myPasswordField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (WebServerConfigForm.this.myPasswordField.getPassword().length == 0) {
                    WebServerConfigForm.this.myPasswordIsSpecified = false;
                }
            }
        });
        this.myTestConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String title = WDBundle.message("test.connection", WebServerConfigForm.this.getCurrentState().getFileTransferConfig().getAccessType().getTitle());
                WebServerConfigForm.this.testConnection(title, false, project);
            }
        });
        this.myPrivateKeyFileLabel.setLabelFor(this.myPrivateKeyFileField.getTextField());
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                WebServerConfigForm.this.updateNeedsPassphrase();
            }
        });
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, true, true, false);
        descriptor.setHideIgnored(false);
        descriptor.withShowHiddenFiles(true);
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> browseFolderActionListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(WDBundle.message("choose.private.key", new Object[0]), "", (ComponentWithBrowseButton)this.myPrivateKeyFileField, null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile initial = super.getInitialFile();
                if (initial != null) {
                    return initial;
                }
                return this.getSshHome();
            }

            @Nullable
            private VirtualFile getSshHome() {
                String userHome = SystemProperties.getUserHome();
                if (userHome == null) {
                    return null;
                }
                File file = new File(userHome, ".ssh");
                if (!file.exists()) {
                    return null;
                }
                return LocalFileSystem.getInstance().findFileByIoFile(file);
            }
        };
        this.myPrivateKeyFileField.addActionListener((ActionListener)browseFolderActionListener);
        this.myPassphraseField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (WebServerConfigForm.this.myPassphraseField.getPassword().length == 0) {
                    WebServerConfigForm.this.myPassphraseIsSpecified = false;
                }
            }
        });
        this.myAuthTypeCombo.setModel(new CollectionComboBoxModel(Arrays.asList(AUTH_PASSWORD, AUTH_KEYPAIR), (Object)AUTH_PASSWORD));
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServerConfigForm.this.updateOnAuthTypeChange();
                JTextField focus = WebServerConfigForm.this.myAuthTypeCombo.getSelectedItem() == AUTH_PASSWORD ? WebServerConfigForm.this.myPasswordField : WebServerConfigForm.this.myPrivateKeyFileField.getTextField();
                IdeFocusManager.findInstanceByComponent((Component)focus).requestFocus((Component)focus, false);
            }
        });
        this.myAdvancedOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdvancedOptionsDialog d = new AdvancedOptionsDialog(WebServerConfigForm.this.myContentPane, WebServerConfigForm.this.myAdvancedOptions, (AccessType)((Object)WebServerConfigForm.this.myAccessTypeCombo.getSelectedItem()));
                d.show();
            }
        });
        this.myRootFolderLabel.setLabelFor(this.myRootFolderField.getTextField());
        this.myRootFolderField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebServerConfig.RemotePath path;
                WebServerConfig server = WebServerConfigForm.this.getCurrentState();
                String title = WDBundle.message("choose.root.path", server.getName(), server.getFileTransferConfig().getHost());
                WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(WebServerConfigForm.this.myRootFolderField.getText());
                Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)WebServerConfigForm.this.myRootFolderField));
                ServerBrowserDialog d = project != null ? new ServerBrowserDialog(project, server, title, true, FileTransferConfig.Origin.ForceRoot, initialPath) : new ServerBrowserDialog((Component)WebServerConfigForm.this.myRootFolderField, server, title, true, FileTransferConfig.Origin.ForceRoot, initialPath);
                d.show();
                WebServerConfigForm.this.updatePassword(server);
                if (d.isOK() && (path = d.getPath()) != null) {
                    WebServerConfigForm.this.myRootFolderField.setText(path.path);
                }
            }
        });
        this.myAutodetectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String homePath = WebServerConfigForm.this.testConnection(WDBundle.message("autodetect.root.path", new Object[0]), true, project);
                if (homePath != null) {
                    WebServerConfigForm.this.myRootFolderField.setText(homePath);
                }
            }
        });
        this.myOpenUrlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)WebServerConfigForm.this.myUrlField.getText());
            }
        });
        this.myMountedFolderField.addBrowseFolderListener((TextBrowseFolderListener)new BrowseMountedFolderActionListener(new FileChooserDescriptor(false, true, false, true, false, false), null){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm$14", "onFileChosen"));
                }
                super.onFileChosen(chosenFile);
                WebServerConfigForm.this.mySlowValidationTimedOut = false;
            }
        });
        this.myHostField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                String url = StringUtil.trimStart((String)StringUtil.notNullize((String)WebServerConfigForm.this.myUrlField.getText()), (String)"http://");
                String newHost = WebServerConfigForm.this.myHostField.getText();
                if (!WebServerConfigForm.this.myMuted && Comparing.equal((String)url, (String)WebServerConfigForm.this.myPreviousHostValue)) {
                    String urlFieldContent = newHost.startsWith("http://") ? newHost : (newHost.startsWith("https://") ? newHost : "http://" + newHost);
                    WebServerConfigForm.this.myUrlField.setText(urlFieldContent);
                }
                WebServerConfigForm.this.myPreviousHostValue = newHost;
            }
        });
        this.getFixLink().addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                        @Override
                        public void run() {
                            ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                            WebServerConfigForm.this.updateWarning(true);
                        }
                    }, WDBundle.message("validating.server", new Object[0]), false, null, (JComponent)WebServerConfigForm.this.myContentPane);
                }
            }
        });
        ButtonGroup sftpButtonGroup = new ButtonGroup();
        sftpButtonGroup.add(this.myExplicitFTPSRadioButton);
        sftpButtonGroup.add(this.myImplicitFTPSRadioButton);
    }

    public void updatePassword(WebServerConfig server) {
        this.myMuted = true;
        try {
            if (server.getFileTransferConfig().getAccessType() == AccessType.SFTP && server.getFileTransferConfig().isUseKeyPair()) {
                this.myPassphraseField.setText(server.getFileTransferConfig().getPassphrase());
                this.myPassphraseIsSpecified = server.getFileTransferConfig().getPassphraseState() != FileTransferConfig.PasswordState.Unspecified;
            } else if (server.getFileTransferConfig().getAccessType().isProtocolBased()) {
                this.myPasswordField.setText(server.getFileTransferConfig().getPassword());
                this.myPasswordIsSpecified = server.getFileTransferConfig().getPasswordState() != FileTransferConfig.PasswordState.Unspecified;
            }
        }
        finally {
            this.myMuted = false;
        }
    }

    public void fireChanged() {
        if (!this.myMuted) {
            WebServerConfig effective = this.updateUi();
            ((Listener)this.myEventDispatcher.getMulticaster()).changed(effective);
        }
    }

    public void updateAccessTypes(AccessType ... accessTypes) {
        EnumComboBoxModel comboModel;
        if (accessTypes.length == 0) {
            comboModel = new EnumComboBoxModel(AccessType.class);
        } else {
            ArrayList<AccessType> list = new ArrayList<AccessType>();
            for (AccessType accessType : AccessType.values()) {
                if (!ArrayUtil.contains((Object)((Object)accessType), (Object[])accessTypes)) continue;
                list.add(accessType);
            }
            comboModel = new CollectionComboBoxModel(list, list.get(0));
        }
        this.myAccessTypeCombo.setVisible(comboModel.getSize() > 1);
        this.myAccessTypeLabel.setVisible(comboModel.getSize() > 1);
        this.myAccessTypeCombo.setModel(comboModel);
        this.updateOnAccessTypeChange();
        this.updateOnAuthTypeChange();
    }

    public void setItem(WebServerConfig item) {
        this.myItem = item;
        this.reset();
    }

    @Nullable
    private String testConnection(String title, boolean detectHomePath, Project project) {
        WebServerConfig serverConfig = this.getCurrentState();
        FileTransferConfig fileTransferConfig = serverConfig.getFileTransferConfig();
        if (!AuthHelper.ensureAuthSpecified(project, serverConfig, this.myContentPane)) {
            return null;
        }
        try {
            String homePath = PublishUtils.testConnection(serverConfig, this.myContentPane, title, false);
            if (!detectHomePath) {
                Messages.showInfoMessage((String)WDBundle.message("connection.to.successful", fileTransferConfig.getHost()), (String)title);
            }
            if (fileTransferConfig.getAccessType() == AccessType.SFTP && fileTransferConfig.isUseKeyPair()) {
                this.myPassphraseField.setText(fileTransferConfig.getPassphrase());
                this.myPassphraseIsSpecified = true;
                this.mySavePassphraseCheckbox.setSelected(fileTransferConfig.getPassphraseState() == FileTransferConfig.PasswordState.Store);
            } else {
                this.myPasswordField.setText(fileTransferConfig.getPassword());
                this.myPasswordIsSpecified = true;
                this.mySavePasswordCheckBox.setSelected(fileTransferConfig.getPasswordState() == FileTransferConfig.PasswordState.Store);
            }
            return homePath;
        }
        catch (FileSystemException e) {
            LOG.warn((Throwable)e);
            Messages.showErrorDialog((String)WDBundle.message("connection.to.failed", fileTransferConfig.getHost(), StringUtil.capitalize((String)PublishUtils.getMessage(e, false))), (String)title);
            return null;
        }
        catch (ProcessCanceledException e) {
            return null;
        }
    }

    private void updateNeedsPassphrase() {
        boolean needsPassphrase;
        final String privateKeyPath = this.myPrivateKeyFileField.getText();
        if (StringUtil.isEmpty((String)privateKeyPath)) {
            this.myPasswordField.setEnabled(true);
            this.mySavePasswordCheckBox.setEnabled(true);
            return;
        }
        try {
            needsPassphrase = Util.runWithTimeout(100L, new Computable<Boolean>(){

                public Boolean compute() {
                    return WebServerConfigForm.needsKeyPassphrase(privateKeyPath);
                }
            });
        }
        catch (TimeoutException e) {
            LOG.warn("Failed to check key for passphrase: " + privateKeyPath);
            needsPassphrase = true;
        }
        if (needsPassphrase) {
            if (!this.myPassphraseField.isEnabled()) {
                this.myPassphraseField.setText(null);
                this.myPassphraseField.setEnabled(true);
                this.mySavePassphraseCheckbox.setEnabled(true);
            }
        } else {
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setEnabled(false);
            this.mySavePassphraseCheckbox.setSelected(false);
            this.mySavePassphraseCheckbox.setEnabled(false);
        }
    }

    private static boolean needsKeyPassphrase(@NotNull String privateKeyPath) {
        if (privateKeyPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "privateKeyPath", "com/jetbrains/plugins/webDeployment/ui/WebServerConfigForm", "needsKeyPassphrase"));
        }
        boolean needsPassphrase = true;
        File file = new File(privateKeyPath);
        if (file.isFile() && file.canRead()) {
            try {
                KeyPair keyPair = KeyPair.load((JSch)new JSch(), (String)file.getAbsolutePath());
                needsPassphrase = keyPair == null || keyPair.isEncrypted();
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
        return needsPassphrase;
    }

    private void updateOnAuthTypeChange() {
        if (!((AccessType)((Object)this.myAccessTypeCombo.getSelectedItem())).isProtocolBased()) {
            return;
        }
        if (this.myAuthTypeCombo.getSelectedItem() == AUTH_PASSWORD) {
            this.myPasswordLabel.setVisible(true);
            this.myPasswordField.setVisible(true);
            this.mySavePasswordCheckBox.setVisible(true);
            this.myPrivateKeyFileLabel.setVisible(false);
            this.myPrivateKeyFileField.setText(null);
            int width = this.myPrivateKeyFileLabel.getPreferredSize().width;
            this.myPasswordLabel.setMinimumSize(new Dimension(width, this.myPasswordLabel.getMinimumSize().height));
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseLabel.setVisible(false);
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setVisible(false);
            this.mySavePassphraseCheckbox.setVisible(false);
            this.mySavePassphraseCheckbox.setSelected(false);
        } else {
            this.myPasswordLabel.setVisible(false);
            this.myPasswordField.setText(null);
            this.myPasswordField.setVisible(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setVisible(false);
            this.myPrivateKeyFileLabel.setVisible(true);
            this.myPrivateKeyFileField.setVisible(true);
            this.myPassphraseLabel.setVisible(true);
            this.myPassphraseField.setVisible(true);
            this.mySavePassphraseCheckbox.setVisible(true);
            this.myPassphraseField.setEnabled(true);
            this.mySavePassphraseCheckbox.setEnabled(true);
        }
    }

    private void updateOnAnonymousChange() {
        if (this.myAnonymousCheckBox.isSelected()) {
            this.myUsernameField.setText("anonymous");
            this.myPasswordField.setText(null);
            this.myUsernameField.setEnabled(false);
            this.myPasswordField.setEnabled(false);
            this.mySavePasswordCheckBox.setSelected(false);
            this.mySavePasswordCheckBox.setEnabled(false);
        } else {
            this.myUsernameField.setEnabled(true);
            this.myUsernameField.setText(null);
            this.myPasswordField.setEnabled(true);
            this.mySavePasswordCheckBox.setEnabled(true);
            this.myPasswordIsSpecified = false;
            IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus((Component)this.myUsernameField, false);
        }
    }

    private void updateOnAccessTypeChange() {
        boolean ftpSftp;
        AccessType accessType = (AccessType)((Object)this.myAccessTypeCombo.getSelectedItem());
        if (accessType == AccessType.FTP) {
            this.myHostLabel.setText(WDBundle.message("host.ftp", new Object[0]));
            this.myAnonymousCheckBox.setVisible(true);
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myAuthTypeCombo.setSelectedItem(AUTH_PASSWORD);
            this.myPrivateKeyFileField.setText(null);
            this.myPassphraseField.setText(null);
            this.mySavePassphraseCheckbox.setSelected(false);
            ftpSftp = true;
            this.myUploadPanel.setVisible(true);
        } else if (accessType == AccessType.SFTP) {
            this.myHostLabel.setText(WDBundle.message("host.sftp", new Object[0]));
            if (this.myAnonymousCheckBox.isSelected()) {
                this.myAnonymousCheckBox.setSelected(false);
                this.myUsernameField.setText(null);
            }
            this.myUsernameField.setEnabled(true);
            this.myPasswordField.setEnabled(true);
            this.mySavePasswordCheckBox.setEnabled(true);
            this.myAnonymousCheckBox.setVisible(false);
            this.myAuthTypeLabel.setVisible(true);
            this.myAuthTypeCombo.setVisible(true);
            this.myUploadPanel.setVisible(true);
            this.mySpacer3.setVisible(true);
            ftpSftp = true;
        } else if (accessType == AccessType.FTPS) {
            this.myHostLabel.setText(WDBundle.message("host.ftps", new Object[0]));
            this.myAnonymousCheckBox.setVisible(true);
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myAuthTypeCombo.setSelectedItem(AUTH_PASSWORD);
            this.myPrivateKeyFileField.setText(null);
            this.myPrivateKeyFileField.setVisible(false);
            this.myPassphraseField.setText(null);
            this.mySavePassphraseCheckbox.setSelected(false);
            ftpSftp = true;
            this.myUploadPanel.setVisible(true);
        } else if (accessType == AccessType.MOUNT) {
            this.myAuthTypeLabel.setVisible(false);
            this.myAuthTypeCombo.setVisible(false);
            this.myUploadPanel.setVisible(true);
            this.mySpacer3.setVisible(true);
            ftpSftp = false;
            String url = this.myUrlField.getText();
            if (StringUtil.isEmptyOrSpaces((String)url) || "http://".equalsIgnoreCase(url)) {
                this.myUrlField.setText("http://localhost");
            }
        } else {
            this.myUploadPanel.setVisible(false);
            this.mySpacer3.setVisible(false);
            ftpSftp = false;
            String url = this.myUrlField.getText();
            if (StringUtil.isEmptyOrSpaces((String)url) || "http://".equalsIgnoreCase(url)) {
                this.myUrlField.setText("http://localhost");
            }
        }
        this.myTestConnectionButton.setVisible(ftpSftp);
        this.myHostLabel.setVisible(ftpSftp);
        this.myHostField.setVisible(ftpSftp);
        this.myPortLabel.setVisible(ftpSftp);
        this.myPortField.setVisible(ftpSftp);
        this.myRootFolderLabel.setVisible(ftpSftp);
        this.myRootFolderField.setVisible(ftpSftp);
        this.myAutodetectButton.setVisible(ftpSftp);
        this.myUsernameLabel.setVisible(ftpSftp);
        this.myUsernameField.setVisible(ftpSftp);
        this.myAnonymousCheckBox.setVisible(ftpSftp);
        this.myPasswordLabel.setVisible(ftpSftp);
        this.myPasswordField.setVisible(ftpSftp);
        this.myPassphraseLabel.setVisible(accessType == AccessType.SFTP);
        this.myPassphraseField.setVisible(accessType == AccessType.SFTP);
        this.mySavePasswordCheckBox.setVisible(ftpSftp);
        this.mySavePassphraseCheckbox.setVisible(accessType == AccessType.SFTP);
        this.myAdvancedOptionsButton.setVisible(ftpSftp);
        this.myPrivateKeyFileLabel.setVisible(ftpSftp);
        this.myPrivateKeyFileField.setVisible(ftpSftp);
        this.myExplicitFTPSRadioButton.setVisible(accessType == AccessType.FTPS);
        this.myImplicitFTPSRadioButton.setVisible(accessType == AccessType.FTPS);
        this.mySpacer4.setVisible(accessType == AccessType.FTPS);
        this.mySpacer1.setVisible(ftpSftp);
        this.mySpacer2.setVisible(ftpSftp);
        this.myMountedFolderLabel.setVisible(!ftpSftp);
        this.myMountedFolderField.setVisible(!ftpSftp);
        if (ftpSftp) {
            this.myPortField.setText(String.valueOf(accessType.getDefaultPort()));
            this.myTestConnectionButton.setText(WDBundle.message("test.connection.button.label", accessType.getTitle()));
            if (StringUtil.isEmpty((String)this.myRootFolderField.getText()) || this.myPreviousAccessType != null && this.myPreviousAccessType.getDefaultRootFolder().equals(this.myRootFolderField.getText())) {
                this.myRootFolderField.setText(accessType.getDefaultRootFolder());
            }
            this.updateOnAuthTypeChange();
        }
        this.myAccessTypeDescriptionLabel.setText(accessType.getDescription());
    }

    public JComponent createComponent() {
        return this.myContentPane;
    }

    public boolean isModified() {
        if (!Comparing.equal((String)this.myItem.getUrl(), (String)this.myUrlField.getText())) {
            return true;
        }
        if (this.myItem.isProjectLevel() != this.myProjectLevelCheckBox.isSelected()) {
            return true;
        }
        FileTransferConfig config = this.myItem.getFileTransferConfig();
        if (config.getAccessType() != this.myAccessTypeCombo.getSelectedItem()) {
            return true;
        }
        if (!Comparing.equal((String)StringUtil.notNullize((String)config.getHost()), (String)StringUtil.notNullize((String)this.getHost()))) {
            return true;
        }
        if (!Comparing.equal((String)this.myInitialPort, (String)this.myPortField.getText())) {
            return true;
        }
        if (config.isAnonymous() != this.myAnonymousCheckBox.isSelected()) {
            return true;
        }
        if (!config.isAnonymous()) {
            String username = StringUtil.notNullize((String)this.myUsernameField.getText()).trim();
            if (!Comparing.equal((String)StringUtil.notNullize((String)config.getUserName()), (String)username)) {
                return true;
            }
            if (config.isUseKeyPair() != (this.myAuthTypeCombo.getSelectedItem() == AUTH_KEYPAIR)) {
                return true;
            }
            if (!Comparing.equal((String)StringUtil.notNullize((String)config.getPassword()), (String)new String(this.myPasswordField.getPassword()))) {
                return true;
            }
            if (config.getPasswordState() == FileTransferConfig.PasswordState.Store != this.mySavePasswordCheckBox.isSelected()) {
                return true;
            }
            if (config.getPasswordState() != FileTransferConfig.PasswordState.Store && config.getPasswordState() == FileTransferConfig.PasswordState.Specified != this.myPasswordIsSpecified) {
                return true;
            }
            if (!Comparing.equal((String)StringUtil.notNullize((String)config.getPassphrase()), (String)new String(this.myPassphraseField.getPassword()))) {
                return true;
            }
            if (config.getPassphraseState() == FileTransferConfig.PasswordState.Store != this.mySavePassphraseCheckbox.isSelected()) {
                return true;
            }
            if (config.getPassphraseState() != FileTransferConfig.PasswordState.Store && config.getPassphraseState() == FileTransferConfig.PasswordState.Specified != this.myPassphraseIsSpecified) {
                return true;
            }
            if (!Comparing.equal((String)StringUtil.notNullize((String)config.getPrivateKeyFile()), (String)this.myPrivateKeyFileField.getText())) {
                return true;
            }
        }
        if (!this.myAdvancedOptions.equals(config.getAdvancedOptions())) {
            return true;
        }
        if (!Comparing.equal((String)StringUtil.notNullize((String)config.getRootFolder()), (String)this.myRootFolderField.getText())) {
            return true;
        }
        if (!Comparing.equal((String)StringUtil.notNullize((String)config.getMountedFolder()), (String)StringUtil.notNullize((String)this.getMountedFolder()))) {
            return true;
        }
        return config.isFtpsExplicit() != this.myExplicitFTPSRadioButton.isSelected();
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.myItem);
    }

    @Nullable
    private String getHost() {
        String host = this.myHostField.getText();
        if (host != null) {
            host = UriUtil.trimTrailingSlashes((String)host);
        }
        return host;
    }

    public void applyTo(WebServerConfig serverConfig) {
        serverConfig.setUrl(this.myUrlField.getText());
        serverConfig.setIsProjectLevel(this.myProjectLevelCheckBox.isSelected());
        FileTransferConfig config = serverConfig.getFileTransferConfig();
        AccessType accessType = (AccessType)((Object)this.myAccessTypeCombo.getSelectedItem());
        config.setAccessType(accessType);
        if (accessType.isProtocolBased()) {
            config.setHost(this.getHost());
            config.setLiteralPort(this.myPortField.getText());
            if (this.myAnonymousCheckBox.isSelected()) {
                config.setAnonymous(true);
                config.setUserName(null);
                config.setPassword(null, false);
            } else {
                config.setAnonymous(false);
                String username = this.myUsernameField.getText();
                if (username != null) {
                    username = username.trim();
                }
                config.setUserName(username);
                config.setUseKeyPair(this.myAuthTypeCombo.getSelectedItem() == AUTH_KEYPAIR);
                if (this.myAuthTypeCombo.getSelectedItem() == AUTH_KEYPAIR) {
                    config.setPassword(null, false);
                    config.setStorePassword(false);
                    config.setPassphrase(new String(this.myPassphraseField.getPassword()), this.myPassphraseIsSpecified);
                    config.setStorePassphrase(this.mySavePassphraseCheckbox.isSelected());
                    config.setPrivateKeyFile(this.myPrivateKeyFileField.getText());
                } else {
                    config.setPassword(new String(this.myPasswordField.getPassword()), this.myPasswordIsSpecified);
                    config.setStorePassword(this.mySavePasswordCheckBox.isSelected());
                    config.setPassphrase(null, false);
                    config.setStorePassphrase(false);
                    config.setPrivateKeyFile(null);
                }
            }
            config.setAdvancedOptions(this.myAdvancedOptions.clone());
            config.setRootFolder(this.myRootFolderField.getText());
            config.setMountedFolder(null);
            config.setFtpsExplicit(this.myExplicitFTPSRadioButton.isSelected());
        } else {
            config.setHost(null);
            config.setPort(0);
            config.setAnonymous(false);
            config.setUserName(null);
            config.setRootFolder(new FileTransferConfig().getRootFolder());
            config.setPassword(null, false);
            config.setStorePassword(false);
            config.setUseKeyPair(false);
            config.setPassphrase(null, false);
            config.setStorePassphrase(false);
            config.setPrivateKeyFile(null);
            config.setAdvancedOptions(new AdvancedOptionsConfig());
            if (accessType == AccessType.MOUNT) {
                config.setMountedFolder(this.getMountedFolder());
            } else {
                config.setMountedFolder(null);
            }
        }
    }

    public String getMountedFolder() {
        String s = this.myMountedFolderField.getText();
        if (StringUtil.isEmpty((String)s)) {
            return s;
        }
        return new File(s).getAbsolutePath();
    }

    public void reset() {
        this.myMuted = true;
        try {
            this.myUrlField.setText(this.myItem.getUrl());
            this.myProjectLevelCheckBox.setSelected(this.myItem.isProjectLevel());
            FileTransferConfig config = this.myItem.getFileTransferConfig();
            this.myRootFolderField.setText(config.getRootFolder());
            this.myHostField.setText(config.getHost());
            this.myPreviousHostValue = this.myHostField.getText();
            this.myAccessTypeCombo.setSelectedItem((Object)config.getAccessType());
            this.updateOnAccessTypeChange();
            this.myPortField.setText(config.getLiteralPort());
            this.myAnonymousCheckBox.setSelected(config.isAnonymous());
            this.updateOnAnonymousChange();
            if (!config.isAnonymous()) {
                this.myUsernameField.setText(config.getUserName());
                this.myPasswordField.setText(config.getPassword());
                this.mySavePasswordCheckBox.setSelected(config.getPasswordState() == FileTransferConfig.PasswordState.Store);
            }
            this.myPasswordIsSpecified = config.getPasswordState() == FileTransferConfig.PasswordState.Specified;
            this.myPrivateKeyFileField.setText(config.getPrivateKeyFile());
            this.myPassphraseField.setText(config.getPassphrase());
            this.mySavePassphraseCheckbox.setSelected(config.getPassphraseState() == FileTransferConfig.PasswordState.Store);
            this.myPassphraseIsSpecified = config.getPassphraseState() == FileTransferConfig.PasswordState.Specified;
            this.myAuthTypeCombo.setSelectedItem(config.isUseKeyPair() ? AUTH_KEYPAIR : AUTH_PASSWORD);
            this.myAdvancedOptions = config.getAdvancedOptions().clone();
            this.myMountedFolderField.setText(config.getMountedFolder());
            this.updateOnAuthTypeChange();
            this.updateNeedsPassphrase();
            if (config.isFtpsExplicit()) {
                this.myExplicitFTPSRadioButton.setSelected(true);
            } else {
                this.myImplicitFTPSRadioButton.setSelected(true);
            }
            this.mySlowValidationTimedOut = false;
            this.updateUi();
            IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus((Component)this.getPreferredFocusedComponent(), false);
        }
        finally {
            this.myMuted = false;
        }
    }

    public JComponent getPreferredFocusedComponent() {
        JComponent[] fields;
        for (JComponent field : fields = new JComponent[]{this.myHostField, this.myPortField, this.myRootFolderField, this.myUsernameField, this.myPasswordField, this.myPrivateKeyFileField, this.myPassphraseField, this.myMountedFolderField, this.myUrlField}) {
            String text;
            String string = text = field instanceof TextFieldWithBrowseButton ? ((TextFieldWithBrowseButton)field).getText() : ((JTextField)field).getText();
            if (field == this.myUrlField && "http://".equals(text)) {
                text = null;
            }
            if (!field.isVisible() || !StringUtil.isEmpty((String)text)) continue;
            return field instanceof TextFieldWithBrowseButton ? ((TextFieldWithBrowseButton)field).getTextField() : field;
        }
        for (JComponent field : fields) {
            if (!field.isVisible()) continue;
            return field;
        }
        return fields[0];
    }

    public void disposeUIResources() {
    }

    private WebServerConfig updateUi() {
        this.updateWarning(false);
        WebServerConfig serverConfig = this.getCurrentState();
        boolean canConnect = serverConfig.getFileTransferConfig().canConnect();
        this.myTestConnectionButton.setEnabled(canConnect);
        this.myAutodetectButton.setEnabled(canConnect);
        this.myRootFolderField.getButton().setEnabled(canConnect);
        this.myOpenUrlButton.setEnabled(serverConfig.validateUrl() == null);
        return serverConfig;
    }

    public void setForbiddenChildPath(String forbiddenChildPath) {
        this.myForbiddenChildPath = forbiddenChildPath;
    }

    public void updateWarning(boolean forceSlow) {
        File path;
        File mountedFolder;
        String errorMessage;
        if (!forceSlow && this.mySlowValidationTimedOut) {
            return;
        }
        WebServerConfig currentState = this.getCurrentState();
        try {
            errorMessage = currentState.validateSlow(forceSlow ? -1L : 200L);
            this.mySlowValidationTimedOut = false;
        }
        catch (TimeoutException e) {
            errorMessage = WDBundle.message("validation.took.more.than.expected", new Object[0]);
            boolean bl = this.mySlowValidationTimedOut = !forceSlow;
        }
        if (StringUtil.isEmpty((String)errorMessage) && !StringUtil.isEmpty((String)this.myForbiddenChildPath) && VfsUtil.isAncestor((File)(mountedFolder = new File(this.getMountedFolder())), (File)(path = new File(this.myForbiddenChildPath)), (boolean)false)) {
            errorMessage = WDBundle.message("path.is.under.mounted.folder", mountedFolder);
        }
        if (StringUtil.isEmpty((String)errorMessage)) {
            try {
                errorMessage = WebServerConfigForm.getNonBlockingWarnings(currentState, forceSlow ? -1L : 200L);
            }
            catch (TimeoutException e) {
                errorMessage = WDBundle.message("validation.took.more.than.expected", new Object[0]);
                this.mySlowValidationTimedOut = !forceSlow;
            }
        }
        final String finalErrorMessage = errorMessage;
        Runnable updateRunnable = new Runnable(){

            @Override
            public void run() {
                if (finalErrorMessage != null) {
                    WebServerConfigForm.this.getMessageLabel().setText(finalErrorMessage);
                    WebServerConfigForm.this.getMessageLabel().setVisible(true);
                    WebServerConfigForm.this.getFixLink().setVisible(WebServerConfigForm.this.mySlowValidationTimedOut);
                } else {
                    WebServerConfigForm.this.getMessageLabel().setText(null);
                    WebServerConfigForm.this.getMessageLabel().setVisible(false);
                    WebServerConfigForm.this.getFixLink().setVisible(false);
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            updateRunnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(updateRunnable, ModalityState.stateForComponent((Component)this.myContentPane));
        }
    }

    private static String getNonBlockingWarnings(WebServerConfig currentState, long msTimeout) throws TimeoutException {
        String privateKeyFile;
        boolean needsKeyPassphrase;
        String warning = currentState.getNonBlockingWarnings();
        if (warning != null) {
            return warning;
        }
        FileTransferConfig config = currentState.getFileTransferConfig();
        if (config.getAccessType() == AccessType.SFTP && !StringUtil.isEmpty((String)config.getPrivateKeyFile()) && StringUtil.isEmpty((String)config.getPassphrase()) && (needsKeyPassphrase = Util.runWithTimeout(msTimeout, new Computable<Boolean>(privateKeyFile = config.getPrivateKeyFile()){
            final /* synthetic */ String val$privateKeyFile;
            {
                this.val$privateKeyFile = string;
            }

            public Boolean compute() {
                return WebServerConfigForm.needsKeyPassphrase(this.val$privateKeyFile);
            }
        }).booleanValue())) {
            return "Provided private key requires a passphrase";
        }
        return null;
    }

    @Nullable
    public String getCurrentWarning() {
        return this.getMessageLabel().getText();
    }

    public Icon getIcon(int flags) {
        Icon icon = ((AccessType)((Object)this.myAccessTypeCombo.getSelectedItem())).getIcon();
        if (this.getCurrentWarning() != null) {
            icon = new LayeredIcon(new Icon[]{icon, AllIcons.General.WarningDecorator});
        }
        return icon;
    }

    public void addListener(Listener listener, Disposable parentDisposable) {
        this.myEventDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public WebServerConfig getCurrentState() {
        WebServerConfig currentState = this.myItem.clone();
        currentState.getFileTransferConfig().setAccessType(this.myItem.getFileTransferConfig().getAccessType());
        this.applyTo(currentState);
        return currentState;
    }

    private void createUIComponents() {
        this.myFixLink = new HoverHyperlinkLabel(WDBundle.message("revalidate", new Object[0]));
    }

    protected JLabel getMessageLabel() {
        return this.myMessageLabel;
    }

    protected HoverHyperlinkLabel getFixLink() {
        return this.myFixLink;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JComboBox jComboBox;
        JLabel jLabel3;
        JButton jButton;
        JTextField jTextField;
        JButton jButton2;
        JTextField jTextField2;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel3;
        JPanel jPanel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel4;
        JButton jButton3;
        JLabel jLabel5;
        TextFieldWithBrowseButton.NoPathCompletion noPathCompletion;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JComboBox jComboBox2;
        JButton jButton4;
        JPasswordField jPasswordField;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel7;
        JPasswordField jPasswordField2;
        JLabel jLabel8;
        JLabel jLabel9;
        JCheckBox jCheckBox3;
        JTextField jTextField3;
        JLabel jLabel10;
        JTextField jTextField4;
        JLabel jLabel11;
        JLabel jLabel12;
        JPanel jPanel5;
        JPanel jPanel6;
        this.createUIComponents();
        this.myContentPane = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myUploadPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(16, 4, new Insets(0, 5, 5, 5), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel5, new GridConstraints(3, 0, 1, 3, 0, 3, 2, 2, new Dimension(-1, 40), null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Upload/download project files", (int)0, (int)0, null, null));
        this.myHostLabel = jLabel12 = new JLabel();
        jLabel12.setText("Host:");
        jLabel12.setDisplayedMnemonic('O');
        jLabel12.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jLabel12, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortLabel = jLabel11 = new JLabel();
        jLabel11.setText("Port:");
        jLabel11.setDisplayedMnemonic('P');
        jLabel11.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel11, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField4 = new JTextField();
        jTextField4.setText("");
        jPanel5.add((Component)jTextField4, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(70, 22), null));
        this.myUsernameLabel = jLabel10 = new JLabel();
        jLabel10.setText("User name:");
        jLabel10.setDisplayedMnemonic('U');
        jLabel10.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel10, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUsernameField = jTextField3 = new JTextField();
        jPanel5.add((Component)jTextField3, new GridConstraints(6, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, -1), null));
        this.myAnonymousCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Login as anonymous");
        jCheckBox3.setMnemonic('N');
        jCheckBox3.setDisplayedMnemonicIndex(10);
        jPanel5.add((Component)jCheckBox3, new GridConstraints(6, 2, 1, 2, 8, 0, 3, 0, null, new Dimension(122, 22), null));
        this.myAuthTypeLabel = jLabel9 = new JLabel();
        jLabel9.setText("Auth type:");
        jLabel9.setDisplayedMnemonic('Y');
        jLabel9.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jLabel9, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordLabel = jLabel8 = new JLabel();
        jLabel8.setText("Password:");
        jLabel8.setDisplayedMnemonic('S');
        jLabel8.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jLabel8, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField2 = new JPasswordField();
        jPanel5.add((Component)jPasswordField2, new GridConstraints(8, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.myPrivateKeyFileLabel = jLabel7 = new JLabel();
        jLabel7.setText("Private key file:");
        jLabel7.setDisplayedMnemonic('K');
        jLabel7.setDisplayedMnemonicIndex(8);
        jPanel5.add((Component)jLabel7, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPrivateKeyFileField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(9, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myPassphraseLabel = jLabel6 = new JLabel();
        jLabel6.setText("Key passphrase:");
        jLabel6.setDisplayedMnemonic('S');
        jLabel6.setDisplayedMnemonicIndex(6);
        jPanel5.add((Component)jLabel6, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPassphraseField = jPasswordField = new JPasswordField();
        jPanel5.add((Component)jPasswordField, new GridConstraints(10, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(200, 22), null));
        this.myAdvancedOptionsButton = jButton4 = new JButton();
        jButton4.setText("Advanced options...");
        jButton4.setMnemonic('D');
        jButton4.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jButton4, new GridConstraints(15, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myAuthTypeCombo = jComboBox2 = new JComboBox();
        jPanel5.add(jComboBox2, new GridConstraints(7, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.mySavePassphraseCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Save passphrase");
        jCheckBox2.setMnemonic('V');
        jCheckBox2.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jCheckBox2, new GridConstraints(10, 2, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySavePasswordCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Save password");
        jCheckBox.setMnemonic('V');
        jCheckBox.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jCheckBox, new GridConstraints(8, 2, 1, 2, 8, 0, 3, 0, null, new Dimension(122, 22), null));
        this.myRootFolderField = noPathCompletion = new TextFieldWithBrowseButton.NoPathCompletion();
        jPanel5.add((Component)noPathCompletion, new GridConstraints(4, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        this.myRootFolderLabel = jLabel5 = new JLabel();
        jLabel5.setText("Root path:");
        jLabel5.setDisplayedMnemonic('R');
        jLabel5.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAutodetectButton = jButton3 = new JButton();
        jButton3.setText("Autodetect");
        jButton3.setToolTipText("Configure root folder according to the user home folder on the server.");
        jPanel5.add((Component)jButton3, new GridConstraints(4, 3, 1, 1, 4, 0, 3, 0, null, null, null));
        this.myMountedFolderLabel = jLabel4 = new JLabel();
        jLabel4.setText("Folder:");
        jLabel4.setDisplayedMnemonic('F');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMountedFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.mySpacer2 = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(11, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 10), null));
        this.mySpacer1 = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 10), null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myExplicitFTPSRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("explicit");
        jRadioButton2.setMnemonic('X');
        jRadioButton2.setDisplayedMnemonicIndex(1);
        ((Component)jRadioButton2).setVisible(true);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(12, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myImplicitFTPSRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("implicit");
        jRadioButton.setMnemonic('I');
        jRadioButton.setDisplayedMnemonicIndex(0);
        ((Component)jRadioButton).setVisible(true);
        jPanel5.add((Component)jRadioButton, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpacer4 = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setVisible(true);
        jPanel5.add((Component)jPanel2, new GridConstraints(14, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 10), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel7, new GridConstraints(2, 1, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myHostField = jTextField2 = new JTextField();
        jPanel7.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, new Dimension(100, -1), null, null));
        this.myTestConnectionButton = jButton2 = new JButton();
        jButton2.setText("Test connection...");
        jButton2.setMnemonic('C');
        jButton2.setDisplayedMnemonicIndex(5);
        jPanel7.add((Component)jButton2, new GridConstraints(0, 1, 1, 2, 4, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 5, 5, 5), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel8, new GridConstraints(5, 0, 1, 3, 0, 3, 2, 2, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Browse files on server", (int)0, (int)0, null, null));
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Web server root URL:");
        jLabel13.setDisplayedMnemonic('W');
        jLabel13.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jLabel13, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUrlField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel8.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myOpenUrlButton = jButton = new JButton();
        jButton.setText("Open");
        jButton.setMnemonic('E');
        jButton.setDisplayedMnemonicIndex(2);
        jPanel8.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAccessTypeLabel = jLabel3 = new JLabel();
        jLabel3.setText("Type:");
        jLabel3.setDisplayedMnemonic('T');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel6.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAccessTypeCombo = jComboBox = new JComboBox();
        jPanel6.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, new Dimension(200, -1), null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySpacer3 = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, new Dimension(-1, 5), null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel9, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        HoverHyperlinkLabel hoverHyperlinkLabel = this.myFixLink;
        hoverHyperlinkLabel.setText("Refresh");
        hoverHyperlinkLabel.setToolTipText("Force server revalidation");
        jPanel9.add((Component)hoverHyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myMessageLabel = jLabel2 = new JLabel();
        jLabel2.setText("Label");
        jPanel9.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAccessTypeDescriptionLabel = jLabel = new JLabel();
        jLabel.setText("Description");
        ((Component)jLabel).setForeground(SystemColor.textInactiveText);
        jPanel6.add((Component)jLabel, new GridConstraints(2, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myProjectLevelCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Visible only for this project");
        jPanel6.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        jLabel12.setLabelFor(jTextField2);
        jLabel11.setLabelFor(jTextField4);
        jLabel10.setLabelFor(jTextField3);
        jLabel9.setLabelFor(jComboBox2);
        jLabel8.setLabelFor(jPasswordField2);
        jLabel6.setLabelFor(jPasswordField);
        jLabel13.setLabelFor(jTextField);
        jLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static class AccessTypeComboRenderer
    extends ListCellRendererWrapper<AccessType> {
        public AccessTypeComboRenderer(ListCellRenderer listCellRenderer) {
        }

        public void customize(JList list, AccessType accessType, int index, boolean selected, boolean hasFocus) {
            if (accessType != null) {
                this.setText(accessType.getTitle());
                this.setIcon(accessType.getIcon());
            }
        }
    }

    public static interface AccessTypeChangeListener
    extends EventListener {
        public void changed();
    }

    public static interface Listener
    extends EventListener {
        public void changed(WebServerConfig var1);
    }
}

