/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.version;

import com.intellij.javaee.oss.jetty.JettyUtil;
import com.intellij.javaee.oss.jetty.server.JettyConfigFile;
import com.intellij.javaee.oss.jetty.server.JettyConfigFileChecker;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesCollector;
import com.intellij.javaee.oss.jetty.server.JettyConfigFilesEditor;
import com.intellij.javaee.oss.jetty.server.JettyIniProcessor;
import com.intellij.javaee.oss.jetty.server.JettyIniProducer;
import com.intellij.javaee.oss.jetty.version.JettyVersion9Handler;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JettyVersion91Handler
extends JettyVersion9Handler {
    @Override
    public FileTypeDescriptor getConfigFileTypeDescriptor() {
        return JettyUtil.MODULE_FILE_DESCRIPTOR;
    }

    @Override
    public Collection<String> getCommandLineParameters(Collection<String> configFiles) {
        ArrayList<String> modules = new ArrayList<String>();
        for (String modulePath : configFiles) {
            modules.add(JettyUtil.getModuleNameFromPath(modulePath));
        }
        return modules.isEmpty() ? Collections.emptyList() : Collections.singletonList("--module=" + StringUtil.join(modules, (String)","));
    }

    @Override
    public List<JettyConfigFileChecker> getConfigFileCheckers(JettyConfigFilesEditor editor) {
        return Collections.singletonList(new JettyConfigFileChecker(editor, "modules/jmx.mod", "JMX module is not included"));
    }

    @Override
    public JettyConfigFilesCollector getConfigFilesCollector(String home, String workDir, List<JettyConfigFile> configFiles) {
        return new JettyModulesConfigCollector(home, workDir, configFiles);
    }

    @Override
    public JettyIniProducer getIniProducer(String home, Set<String> activePaths) {
        return new ModuleIniProducer(home, activePaths);
    }

    private static class ModuleIniProducer
    extends JettyIniProducer {
        private Set<String> myActiveModules;

        public ModuleIniProducer(String home, Set<String> configFiles) {
            super(home, configFiles);
        }

        @Override
        public void process() {
            this.myActiveModules = new HashSet<String>();
            for (String activePath : this.getConfigFiles()) {
                this.myActiveModules.add(FileUtil.getNameWithoutExtension((String)new File(activePath).getName()));
            }
            super.process();
            for (String module : this.myActiveModules) {
                this.addModule(module, false);
            }
        }

        @Override
        protected void processPathLine(String path) {
            this.addIniLine(path);
        }

        @Override
        protected void processModuleLine(String moduleName, boolean isCommented) {
            this.addModule(moduleName, !this.myActiveModules.remove(moduleName));
        }

        private void addModule(String moduleName, boolean commented) {
            this.addIniLine((commented ? "#" : "") + "--module=" + moduleName);
        }
    }

    private static class JettyModulesConfigCollector
    extends JettyConfigFilesCollector {
        public JettyModulesConfigCollector(String home, String workDir, List<JettyConfigFile> configFiles) {
            super(home, workDir, configFiles, ".mod");
        }

        @Override
        public void scanIni() {
            new JettyIniProcessor(this.getWorkDir()){

                @Override
                protected void processModuleLine(String moduleName, boolean isCommented) {
                    if (!isCommented) {
                        this.getOrCreateConfigFile(JettyUtil.getModuleRelativePath(moduleName)).setActive(true);
                    }
                }
            }.process();
        }

        @Override
        protected File[] doScanDir() {
            return new File(this.getHome(), "modules").listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".mod");
                }
            });
        }
    }
}

