/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.maven;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.maven.GwtCodehausFacetImporter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;

public class GwtFacetForVaadinImporter
extends GwtCodehausFacetImporter {
    public GwtFacetForVaadinImporter() {
        super("com.vaadin", "vaadin-maven-plugin");
    }

    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        String version = this.getVaadinVersion(mavenProject);
        if (version != null) {
            List repos = mavenProject.getRemoteRepositories();
            embedder.resolve(new MavenArtifactInfo("com.vaadin", "vaadin-client-compiler", version, "jar", null), repos);
        }
    }

    @Nullable
    private String getVaadinVersion(MavenProject mavenProject) {
        for (MavenArtifact artifact : mavenProject.findDependencies("com.vaadin", "vaadin-client")) {
            String artifactVersion = artifact.getVersion();
            if (artifactVersion == null) continue;
            return artifactVersion;
        }
        return this.findConfigValue(mavenProject, "version");
    }

    protected void setupGwtSdk(GwtFacet facet, MavenProject project) {
        String version = this.getVaadinVersion(project);
        if (version != null) {
            GwtFacetConfiguration configuration = (GwtFacetConfiguration)facet.getConfiguration();
            String homePath = project.getLocalRepository().getPath() + "/com/vaadin/vaadin-client/" + version;
            configuration.setGwtSdkUrl(VfsUtilCore.pathToUrl((String)homePath));
            configuration.setGwtSdkType("Vaadin-Maven");
        }
    }
}

