/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.OSAgentException;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.jcraft.jsch.JSchException;
import com.openshift.client.IDomain;
import com.openshift.client.OpenShiftException;
import java.io.IOException;
import java.net.URISyntaxException;

public class OSApiTaskProvider {
    private IDomain myDomain;
    private final CloudAgentErrorHandler myErrorHandler;
    private final CloudAgentLogger myLogger;

    public OSApiTaskProvider(IDomain domain, CloudAgentErrorHandler errorHandler, CloudAgentLogger logger) {
        this.myDomain = domain;
        this.myErrorHandler = errorHandler;
        this.myLogger = logger;
    }

    public abstract class ApiSilentTask<T>
    extends ApiTask<T> {
        @Override
        protected void onError(Exception ex) {
            OSApiTaskProvider.this.myLogger.debugEx(ex);
        }

        @Override
        protected void onError(String message) {
            OSApiTaskProvider.this.myLogger.debug(message);
        }
    }

    public abstract class ApiTask<T> {
        public T perform() {
            try {
                OSApiTaskProvider.this.myDomain.refresh();
                return this.doPerform(OSApiTaskProvider.this.myDomain);
            }
            catch (OpenShiftException ex) {
                this.onError((Exception)((Object)ex));
                return null;
            }
            catch (IOException ex) {
                this.onError(ex);
                return null;
            }
            catch (JSchException ex) {
                this.onError((Exception)((Object)ex));
                return null;
            }
            catch (URISyntaxException ex) {
                this.onError(ex);
                return null;
            }
            catch (OSAgentException e) {
                this.onError(e.getMessage());
                return null;
            }
        }

        protected abstract T doPerform(IDomain var1) throws OpenShiftException, IOException, JSchException, URISyntaxException, OSAgentException;

        protected void onError(Exception ex) {
            OSApiTaskProvider.this.myErrorHandler.onError(ex.toString());
        }

        protected void onError(String message) {
            OSApiTaskProvider.this.myErrorHandler.onError(message);
        }
    }
}

