/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.banner.SpringBootBannerReferenceContributor;
import com.intellij.ui.LayeredIcon;
import icons.SpringBootApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootIconProvider
extends IconProvider {
    public static final LayeredIcon ADDITIONAL_JSON_ICON = new LayeredIcon(new Icon[]{SpringBootApiIcons.SpringBoot, AllIcons.Javaee.InheritedAttributeOverlay});
    public static final LayeredIcon BANNER_ICON = new LayeredIcon(new Icon[]{AllIcons.FileTypes.Text, SpringBootApiIcons.SpringBoot_Overlay});

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/SpringBootIconProvider", "getIcon"));
        }
        if (element instanceof PropertiesFile) {
            if (SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)element)) {
                return SpringBootApiIcons.SpringBoot;
            }
        } else if (element instanceof JsonFile) {
            JsonFile jsonFile = (JsonFile)element;
            String filename = jsonFile.getName();
            if ("additional-spring-configuration-metadata.json".equals(filename)) {
                return ADDITIONAL_JSON_ICON;
            }
        } else if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            if (SpringBootApplicationUtil.isSpringApplication((PsiClass)psiClass)) {
                return new LayeredIcon(new Icon[]{PsiClassImplUtil.getClassIcon((int)flags, (PsiClass)psiClass), SpringBootApiIcons.SpringBoot_Overlay});
            }
        } else if (element instanceof PsiPlainTextFile && SpringBootBannerReferenceContributor.PATTERN.accepts((Object)element)) {
            return BANNER_ICON;
        }
        return null;
    }
}

