/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EnumReferenceProvider
extends PsiReferenceProvider {
    private final PsiClass myEnumClass;

    EnumReferenceProvider(PsiClass enumClass) {
        this.myEnumClass = enumClass;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/EnumReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/EnumReferenceProvider", "getReferencesByElement"));
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new HintReferenceBase(element){

            @Override
            @Nullable
            protected PsiElement doResolve() {
                final String enumText = this.getValue();
                return (PsiElement)ContainerUtil.find((Object[])this.getEnumFields(), (Condition)new Condition<PsiField>(){

                    public boolean value(PsiField field) {
                        return Comparing.strEqual((String)field.getName(), (String)enumText, (boolean)false);
                    }
                });
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = ContainerUtil.map2Array((Object[])this.getEnumFields(), LookupElement.class, (Function)new Function<PsiField, LookupElement>(){

                    public LookupElement fun(PsiField field) {
                        String enumLowerCaseName = field.getName().toLowerCase(Locale.US);
                        LookupElementBuilder builder = JavaLookupElementBuilder.forField((PsiField)field, (String)enumLowerCaseName, null);
                        String shortDoc = this.getEnumFieldShortJavadoc(field);
                        if (shortDoc == null) {
                            return builder;
                        }
                        return builder.withTailText(" (" + shortDoc + ")", true);
                    }
                });
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/EnumReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                String string = "Cannot resolve field ''{0}'' in enum ''" + EnumReferenceProvider.this.myEnumClass.getQualifiedName() + "''";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/EnumReferenceProvider$1", "getUnresolvedMessagePattern"));
                }
                return string;
            }

            @Nullable
            private String getEnumFieldShortJavadoc(PsiField field) {
                PsiElement navigationElement = field.getNavigationElement();
                if (!(navigationElement instanceof PsiDocCommentOwner)) {
                    return null;
                }
                PsiDocComment comment = ((PsiDocCommentOwner)navigationElement).getDocComment();
                if (comment == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (PsiElement element : comment.getDescriptionElements()) {
                    sb.append(StringUtil.replaceUnicodeEscapeSequences((String)element.getText()));
                }
                String plainJavadoc = sb.toString();
                if (StringUtil.isEmptyOrSpaces((String)plainJavadoc)) {
                    return null;
                }
                String strippedDoc = StringUtil.stripHtml((String)StringUtil.trim((String)plainJavadoc), (boolean)false);
                SpringBootApplicationMetaConfigKey.DescriptionText text = new SpringBootApplicationMetaConfigKey.DescriptionText(strippedDoc);
                return text.getShortText();
            }

            @NotNull
            private PsiField[] getEnumFields() {
                PsiField[] psiFieldArray = (PsiField[])ContainerUtil.findAllAsArray((Object[])EnumReferenceProvider.this.myEnumClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
                if (psiFieldArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/EnumReferenceProvider$1", "getEnumFields"));
                }
                return psiFieldArray;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/EnumReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

