/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlAccessor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.Processor;
import java.util.LinkedHashSet;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

public class SpringBootApplicationYamlConfigurationPropertyReferenceSearcher
extends SpringBootConfigurationPropertyReferenceSearcher {
    @Override
    protected void processModule(MethodReferencesSearch.SearchParameters queryParameters, String prefix, Module module) {
    }

    @Override
    protected boolean processFileSet(final MethodReferencesSearch.SearchParameters queryParameters, PsiManager psiManager, final String prefix, SpringFileSet fileSet) {
        LinkedHashSet otherConfigFiles = new LinkedHashSet(fileSet.getFiles());
        otherConfigFiles.removeAll(fileSet.getCodeConfigurationFiles());
        otherConfigFiles.removeAll(fileSet.getXmlFiles());
        otherConfigFiles.removeAll(fileSet.getPropertiesFiles());
        for (VirtualFilePointer pointer : otherConfigFiles) {
            PsiFile psiFile;
            VirtualFile file = pointer.getFile();
            if (file == null || !((psiFile = psiManager.findFile(file)) instanceof YAMLFile) || !SpringBootApplicationYamlUtil.isApplicationYamlFile((YAMLFile)psiFile)) continue;
            Processor<YAMLKeyValue> processor = new Processor<YAMLKeyValue>(){

                public boolean process(YAMLKeyValue value) {
                    String qualifiedKeyName;
                    return value.getValue() instanceof YAMLCompoundValue || !StringUtil.charsEqualIgnoreCase((char)(qualifiedKeyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(value)).charAt(0), (char)prefix.charAt(0)) || SpringBootApplicationYamlConfigurationPropertyReferenceSearcher.searchMetaConfigKeyReferences(queryParameters, value.getReferences());
                }
            };
            YAMLFile yamlFile = (YAMLFile)psiFile;
            for (YAMLDocument document : yamlFile.getDocuments()) {
                if (SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)document, processor)) continue;
                return false;
            }
        }
        return true;
    }
}

