/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.metadata.ConfigKeyDocumentationProviderBase;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class SpringBootApplicationYamlDocumentationProvider
extends ConfigKeyDocumentationProviderBase {
    @Override
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof YAMLKeyValue && SpringBootApplicationYamlUtil.isInsideApplicationYamlFile(element)) {
            return StringUtil.wrapWithDoubleQuote((String)((YAMLKeyValue)element).getValueText());
        }
        return super.getQuickNavigateInfo(element, originalElement);
    }

    @Override
    @Nullable
    protected String getConfigKey(PsiElement configKeyElement) {
        if (!(configKeyElement instanceof LeafPsiElement)) {
            return null;
        }
        if (((LeafPsiElement)configKeyElement).getElementType() != YAMLTokenTypes.SCALAR_KEY) {
            return null;
        }
        if (!SpringBootApplicationYamlUtil.isInsideApplicationYamlFile(configKeyElement)) {
            return null;
        }
        YAMLKeyValue yamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)configKeyElement, YAMLKeyValue.class);
        if (yamlKeyValue == null) {
            return null;
        }
        return SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(yamlKeyValue);
    }
}

