/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.bool;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.intention.bool.ConjunctionPredicate;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSDeMorgansLawIntention
extends JSMutablyNamedIntention {
    @NonNls
    private static final String AND_OPERATOR = "&&";
    @NonNls
    private static final String OR_OPERATOR = "||";
    @NonNls
    private static final String AND_SUFFIX = "ANDAND";
    @NonNls
    private static final String OR_SUFFIX = "OROR";

    @Override
    protected String getTextForElement(PsiElement element) {
        IElementType tokenType = ((JSBinaryExpression)element).getOperationSign();
        return this.getSuffixedDisplayName(tokenType.equals(JSTokenTypes.ANDAND) ? AND_SUFFIX : OR_SUFFIX, new Object[0]);
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        ConjunctionPredicate conjunctionPredicate = new ConjunctionPredicate();
        if (conjunctionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/bool/JSDeMorgansLawIntention", "getElementPredicate"));
        }
        return conjunctionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/bool/JSDeMorgansLawIntention", "processIntention"));
        }
        JSBinaryExpression exp = (JSBinaryExpression)element;
        IElementType tokenType = exp.getOperationSign();
        JSElement parent = (JSElement)exp.getParent();
        while (JSDeMorgansLawIntention.isConjunctionExpression(parent, tokenType)) {
            exp = (JSBinaryExpression)parent;
            assert (exp != null);
            parent = (JSElement)exp.getParent();
        }
        String newExpression = this.convertConjunctionExpression(exp, tokenType);
        JSElementFactory.replaceExpressionWithNegatedExpressionString((JSExpression)exp, newExpression);
    }

    private String convertConjunctionExpression(JSBinaryExpression exp, IElementType tokenType) {
        String leftText = this.getOperandText(exp.getLOperand(), tokenType);
        String rightText = this.getOperandText(exp.getROperand(), tokenType);
        String flippedConjunction = tokenType.equals(JSTokenTypes.ANDAND) ? OR_OPERATOR : AND_OPERATOR;
        return leftText + flippedConjunction + rightText;
    }

    private String getOperandText(JSExpression operand, IElementType tokenType) {
        return JSDeMorgansLawIntention.isConjunctionExpression((JSElement)operand, tokenType) ? this.convertConjunctionExpression((JSBinaryExpression)operand, tokenType) : BoolUtils.getNegatedExpressionText(operand);
    }

    private static boolean isConjunctionExpression(JSElement exp, IElementType conjunctionType) {
        if (!(exp instanceof JSBinaryExpression)) {
            return false;
        }
        JSBinaryExpression binaryExpression = (JSBinaryExpression)exp;
        IElementType tokenType = binaryExpression.getOperationSign();
        return tokenType.equals(conjunctionType);
    }
}

