/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.conditional;

import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.BoolUtils;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class JSRemoveConditionalIntention
extends JSIntention {
    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        RemoveConditionalPredicate removeConditionalPredicate = new RemoveConditionalPredicate();
        if (removeConditionalPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/conditional/JSRemoveConditionalIntention", "getElementPredicate"));
        }
        return removeConditionalPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSRemoveConditionalIntention", "processIntention"));
        }
        JSConditionalExpression exp = (JSConditionalExpression)element;
        JSExpression condition = exp.getCondition();
        JSExpression thenExpression = exp.getThen();
        assert (thenExpression != null);
        String thenExpressionText = thenExpression.getText();
        String newExpression = thenExpressionText.equals("true") ? condition.getText() : BoolUtils.getNegatedExpressionText(condition);
        JSElementFactory.replaceExpression((JSExpression)exp, newExpression);
    }

    private static class RemoveConditionalPredicate
    implements JSElementPredicate {
        private RemoveConditionalPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/conditional/JSRemoveConditionalIntention$RemoveConditionalPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSConditionalExpression)) {
                return false;
            }
            if (ErrorUtil.containsError(element)) {
                return false;
            }
            JSConditionalExpression condition = (JSConditionalExpression)element;
            JSExpression thenExpression = ParenthesesUtils.stripParentheses(condition.getThen());
            JSExpression elseExpression = ParenthesesUtils.stripParentheses(condition.getElse());
            if (condition.getCondition() == null || thenExpression == null || elseExpression == null) {
                return false;
            }
            String thenText = thenExpression.getText();
            String elseText = elseExpression.getText();
            return "true".equals(elseText) && "false".equals(thenText) || "true".equals(thenText) && "false".equals(elseText);
        }
    }
}

