/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.constant;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.ExpressionUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NotNull;

public class JSConstantExpressionIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        ConstantExpressionPredicate constantExpressionPredicate = new ConstantExpressionPredicate();
        if (constantExpressionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention", "getElementPredicate"));
        }
        return constantExpressionPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention", "processIntention"));
        }
        JSExpression expression = (JSExpression)element;
        Object value = ExpressionUtil.computeConstantExpression(expression);
        String newExpression = value instanceof String ? '\"' + StringUtil.escapeStringCharacters((String)((String)value)) + '\"' : String.valueOf(value);
        JSElementFactory.replaceExpression(expression, newExpression);
    }

    private static class ConstantExpressionPredicate
    implements JSElementPredicate {
        private ConstantExpressionPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention$ConstantExpressionPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSExpression)) {
                return false;
            }
            if (ErrorUtil.containsError(element)) {
                return false;
            }
            JSExpression expression = (JSExpression)element;
            if (element instanceof JSLiteralExpression || element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() != null || expression instanceof JSCallExpression) {
                return false;
            }
            if (!ExpressionUtil.isConstantExpression(expression)) {
                return false;
            }
            if (ExpressionUtil.computeConstantExpression(expression) == null) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSExpression)) {
                return true;
            }
            return !ExpressionUtil.isConstantExpression((JSExpression)parent);
        }
    }
}

