/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.opassign;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.intellij.idea.lang.javascript.psiutil.BinaryOperatorUtils;
import org.intellij.idea.lang.javascript.psiutil.EquivalenceChecker;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.SideEffectChecker;
import org.jetbrains.annotations.NotNull;

public class JSReplaceWithOperatorAssignmentIntention
extends JSMutablyNamedIntention {
    @Override
    public String getTextForElement(PsiElement element) {
        JSAssignmentExpression exp = (JSAssignmentExpression)element;
        JSBinaryExpression rhs = (JSBinaryExpression)exp.getROperand();
        assert (rhs != null);
        IElementType sign = rhs.getOperationSign();
        return this.getText(BinaryOperatorUtils.getOperatorText(sign));
    }

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        Predicate predicate = new Predicate();
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention", "getElementPredicate"));
        }
        return predicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention", "processIntention"));
        }
        JSAssignmentExpression exp = (JSAssignmentExpression)element;
        JSBinaryExpression rhs = (JSBinaryExpression)exp.getROperand();
        JSExpression lhs = exp.getLOperand();
        assert (rhs != null);
        IElementType sign = rhs.getOperationSign();
        String operand = BinaryOperatorUtils.getOperatorText(sign);
        JSExpression rhsrhs = rhs.getROperand();
        assert (rhsrhs != null);
        JSElementFactory.replaceExpression((JSExpression)exp, lhs.getText() + operand + '=' + rhsrhs.getText());
    }

    private static class Predicate
    implements JSElementPredicate {
        private Predicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/opassign/JSReplaceWithOperatorAssignmentIntention$Predicate", "satisfiedBy"));
            }
            if (!(element instanceof JSAssignmentExpression)) {
                return false;
            }
            if (ErrorUtil.containsError(element)) {
                return false;
            }
            JSAssignmentExpression assignment = (JSAssignmentExpression)element;
            IElementType tokenType = assignment.getOperationSign();
            if (!JSTokenTypes.EQ.equals(tokenType)) {
                return false;
            }
            JSExpression lhs = assignment.getLOperand();
            JSExpression rhs = assignment.getROperand();
            if (lhs instanceof JSDefinitionExpression) {
                lhs = ((JSDefinitionExpression)lhs).getExpression();
            }
            if (lhs == null || rhs == null) {
                return false;
            }
            if (!(rhs instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryRhs = (JSBinaryExpression)rhs;
            JSExpression rhsRhs = binaryRhs.getROperand();
            JSExpression rhsLhs = binaryRhs.getLOperand();
            if (rhsRhs == null) {
                return false;
            }
            IElementType rhsTokenType = binaryRhs.getOperationSign();
            if (JSTokenTypes.OROR.equals(rhsTokenType) || JSTokenTypes.ANDAND.equals(rhsTokenType)) {
                return false;
            }
            if (SideEffectChecker.mayHaveSideEffects(lhs)) {
                return false;
            }
            return EquivalenceChecker.expressionsAreEquivalent(lhs, rhsLhs);
        }
    }
}

