/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.switchtoif;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.lang.javascript.psi.util.DeclarationUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.intention.switchtoif.CaseUtil;
import org.intellij.idea.lang.javascript.psiutil.EquivalenceChecker;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSReplaceIfWithSwitchIntention
extends JSIntention {
    @NonNls
    private static final String IF_KEYWORD = "if";
    @NonNls
    private static final String DEFAULT_LABEL_NAME = "Label";
    @NonNls
    private static final String SWITCH_STATEMENT_PREFIX = "switch(";
    @NonNls
    private static final String DEFAULT_CASE_CLAUSE_EXPRESSION = "default: ";
    @NonNls
    private static final String CASE_EXPRESSION_PREFIX = "\ncase ";
    @NonNls
    private static final String LABELED_BREAK_STATEMENT_PREFIX = "break ";
    @NonNls
    private static final String BREAK_STATEMENT = "\nbreak;";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        IfToSwitchPredicate ifToSwitchPredicate = new IfToSwitchPredicate();
        if (ifToSwitchPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceIfWithSwitchIntention", "getElementPredicate"));
        }
        return ifToSwitchPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        JSStatement elseBranch;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceIfWithSwitchIntention", "processIntention"));
        }
        JSIfStatement ifStatement = (JSIfStatement)element.getParent();
        assert (ifStatement != null);
        boolean breaksNeedRelabeled = false;
        JSStatement breakTarget = null;
        String labelString = "";
        if (ControlFlowUtils.statementContainsExitingBreak((JSStatement)ifStatement)) {
            for (JSElement ancestor = (JSElement)ifStatement.getParent(); ancestor != null; ancestor = (JSElement)ancestor.getParent()) {
                if (!(ancestor instanceof JSForStatement) && !(ancestor instanceof JSForInStatement) && !(ancestor instanceof JSDoWhileStatement) && !(ancestor instanceof JSWhileStatement) && !(ancestor instanceof JSSwitchStatement)) continue;
                breakTarget = (JSStatement)ancestor;
                break;
            }
            if (breakTarget != null) {
                labelString = CaseUtil.findUniqueLabel((JSStatement)ifStatement, DEFAULT_LABEL_NAME);
                breaksNeedRelabeled = true;
            }
        }
        JSIfStatement statementToReplace = ifStatement;
        JSExpression caseExpression = CaseUtil.getCaseExpression(ifStatement);
        assert (caseExpression != null);
        StringBuilder switchStatementBuffer = new StringBuilder(1024);
        switchStatementBuffer.append(SWITCH_STATEMENT_PREFIX).append(caseExpression.getText()).append(')').append('{');
        ArrayList<IfStatementBranch> branches = new ArrayList<IfStatementBranch>(20);
        while (true) {
            HashSet<String> topLevelVariables = new HashSet<String>(5);
            HashSet<String> innerVariables = new HashSet<String>(5);
            JSExpression condition = ifStatement.getCondition();
            JSExpression[] labels = JSReplaceIfWithSwitchIntention.getValuesFromCondition(condition, caseExpression);
            JSStatement thenBranch = ifStatement.getThen();
            DeclarationUtils.calculateVariablesDeclared((JSStatement)thenBranch, topLevelVariables, innerVariables, (boolean)true);
            IfStatementBranch ifBranch = new IfStatementBranch();
            ifBranch.setInnerVariables(innerVariables);
            ifBranch.setTopLevelVariables(topLevelVariables);
            ifBranch.setStatement(thenBranch);
            for (JSExpression label : labels) {
                ifBranch.addCondition(label.getText());
            }
            branches.add(ifBranch);
            elseBranch = ifStatement.getElse();
            if (!(elseBranch instanceof JSIfStatement)) break;
            ifStatement = (JSIfStatement)elseBranch;
        }
        if (elseBranch != null) {
            HashSet<String> elseTopLevelVariables = new HashSet<String>(5);
            HashSet<String> elseInnerVariables = new HashSet<String>(5);
            DeclarationUtils.calculateVariablesDeclared((JSStatement)elseBranch, elseTopLevelVariables, elseInnerVariables, (boolean)true);
            IfStatementBranch elseIfBranch = new IfStatementBranch();
            elseIfBranch.setInnerVariables(elseInnerVariables);
            elseIfBranch.setTopLevelVariables(elseTopLevelVariables);
            elseIfBranch.setElse();
            elseIfBranch.setStatement(elseBranch);
            branches.add(elseIfBranch);
        }
        for (IfStatementBranch branch : branches) {
            boolean hasConflicts = false;
            for (IfStatementBranch testBranch : branches) {
                if (!branch.topLevelDeclarationsConfictWith(testBranch)) continue;
                hasConflicts = true;
            }
            JSStatement branchStatement = branch.getStatement();
            if (branch.isElse()) {
                JSReplaceIfWithSwitchIntention.dumpDefaultBranch(switchStatementBuffer, branchStatement, hasConflicts, breaksNeedRelabeled, labelString);
                continue;
            }
            List<String> conditions = branch.getConditions();
            JSReplaceIfWithSwitchIntention.dumpBranch(switchStatementBuffer, conditions, branchStatement, hasConflicts, breaksNeedRelabeled, labelString);
        }
        switchStatementBuffer.append('}');
        String switchStatementString = switchStatementBuffer.toString();
        if (breaksNeedRelabeled) {
            int length = switchStatementBuffer.length();
            StringBuilder out = new StringBuilder(length);
            out.append(labelString).append(':');
            JSReplaceIfWithSwitchIntention.termReplace(out, (JSElement)breakTarget, (JSElement)statementToReplace, switchStatementString);
            JSElementFactory.replaceStatement(breakTarget, out.toString());
        } else {
            JSElementFactory.replaceStatement((JSStatement)statementToReplace, switchStatementString);
        }
    }

    private static void termReplace(StringBuilder out, JSElement target, JSElement replace, String stringToReplaceWith) {
        if (target.equals(replace)) {
            out.append(stringToReplaceWith);
        } else if (target.getChildren().length != 0) {
            JSElement[] children;
            for (JSElement child : children = (JSElement[])target.getChildren()) {
                JSReplaceIfWithSwitchIntention.termReplace(out, child, replace, stringToReplaceWith);
            }
        } else {
            String text = target.getText();
            out.append(text);
        }
    }

    private static JSExpression[] getValuesFromCondition(JSExpression condition, JSExpression caseExpression) {
        ArrayList<JSExpression> values = new ArrayList<JSExpression>(10);
        JSReplaceIfWithSwitchIntention.getValuesFromExpression(condition, caseExpression, values);
        return values.toArray(new JSExpression[values.size()]);
    }

    private static void getValuesFromExpression(JSExpression expression, JSExpression caseExpression, List<JSExpression> values) {
        if (expression instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            JSExpression lhs = binaryExpression.getLOperand();
            JSExpression rhs = binaryExpression.getROperand();
            IElementType tokenType = binaryExpression.getOperationSign();
            if (JSTokenTypes.OROR.equals(tokenType)) {
                JSReplaceIfWithSwitchIntention.getValuesFromExpression(lhs, caseExpression, values);
                JSReplaceIfWithSwitchIntention.getValuesFromExpression(rhs, caseExpression, values);
            } else if (EquivalenceChecker.expressionsAreEquivalent(caseExpression, rhs)) {
                values.add(lhs);
            } else {
                values.add(rhs);
            }
        } else if (expression instanceof JSParenthesizedExpression) {
            JSParenthesizedExpression parenExpression = (JSParenthesizedExpression)expression;
            JSExpression contents = parenExpression.getInnerExpression();
            JSReplaceIfWithSwitchIntention.getValuesFromExpression(contents, caseExpression, values);
        }
    }

    private static void dumpBranch(StringBuilder switchStatementString, List<String> labels, JSStatement body, boolean wrap, boolean renameBreaks, String breakLabelName) {
        JSReplaceIfWithSwitchIntention.dumpLabels(switchStatementString, labels);
        JSReplaceIfWithSwitchIntention.dumpBody(switchStatementString, body, wrap, renameBreaks, breakLabelName);
    }

    private static void dumpDefaultBranch(StringBuilder switchStatementString, JSStatement body, boolean wrap, boolean renameBreaks, String breakLabelName) {
        switchStatementString.append(DEFAULT_CASE_CLAUSE_EXPRESSION);
        JSReplaceIfWithSwitchIntention.dumpBody(switchStatementString, body, wrap, renameBreaks, breakLabelName);
    }

    private static void dumpLabels(StringBuilder switchStatementString, List<String> labels) {
        for (String label : labels) {
            switchStatementString.append(CASE_EXPRESSION_PREFIX);
            switchStatementString.append(label);
            switchStatementString.append(": ");
        }
    }

    private static void dumpBody(StringBuilder switchStatementString, JSStatement bodyStatement, boolean wrap, boolean renameBreaks, String breakLabelName) {
        if (bodyStatement instanceof JSBlockStatement) {
            if (wrap) {
                JSReplaceIfWithSwitchIntention.appendElement(switchStatementString, (JSElement)bodyStatement, renameBreaks, breakLabelName);
            } else {
                String bodyText = bodyStatement.getText();
                switchStatementString.append(bodyText.substring(1, bodyText.length() - 1));
            }
        } else if (wrap) {
            switchStatementString.append('{');
            JSReplaceIfWithSwitchIntention.appendElement(switchStatementString, (JSElement)bodyStatement, renameBreaks, breakLabelName);
            switchStatementString.append('}');
        } else {
            JSReplaceIfWithSwitchIntention.appendElement(switchStatementString, (JSElement)bodyStatement, renameBreaks, breakLabelName);
        }
        if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)bodyStatement)) {
            switchStatementString.append(BREAK_STATEMENT);
        }
        switchStatementString.append('\n');
    }

    private static void appendElement(StringBuilder switchStatementString, JSElement element, boolean renameBreakElements, String breakLabelString) {
        String text = element.getText();
        if (!renameBreakElements) {
            switchStatementString.append(text);
        } else if (element instanceof JSBreakStatement) {
            String identifier = ((JSBreakStatement)element).getLabel();
            if (identifier == null || identifier.length() == 0) {
                switchStatementString.append(LABELED_BREAK_STATEMENT_PREFIX);
                switchStatementString.append(breakLabelString);
                switchStatementString.append(';');
            } else {
                switchStatementString.append(text);
            }
        } else if (element instanceof JSBlockStatement || element instanceof JSBlock || element instanceof JSIfStatement) {
            JSElement[] children;
            for (JSElement child : children = (JSElement[])element.getChildren()) {
                JSReplaceIfWithSwitchIntention.appendElement(switchStatementString, child, renameBreakElements, breakLabelString);
            }
        } else {
            switchStatementString.append(text);
        }
    }

    private static class IfStatementBranch {
        private final List<String> conditions = new ArrayList<String>(3);
        private Set<String> topLevelVariables = new HashSet<String>(3);
        private Set<String> innerVariables = new HashSet<String>(3);
        private JSStatement statement;
        private boolean isElse;

        private IfStatementBranch() {
        }

        public void addCondition(String conditionString) {
            this.conditions.add(conditionString);
        }

        public void setStatement(JSStatement statement) {
            this.statement = statement;
        }

        public JSStatement getStatement() {
            return this.statement;
        }

        public List<String> getConditions() {
            return Collections.unmodifiableList(this.conditions);
        }

        public boolean isElse() {
            return this.isElse;
        }

        public void setElse() {
            this.isElse = true;
        }

        public void setTopLevelVariables(Set<String> topLevelVariables) {
            this.topLevelVariables = new HashSet<String>(topLevelVariables);
        }

        public void setInnerVariables(Set<String> innerVariables) {
            this.innerVariables = new HashSet<String>(innerVariables);
        }

        private Set<String> getTopLevelVariables() {
            return Collections.unmodifiableSet(this.topLevelVariables);
        }

        private Set<String> getInnerVariables() {
            return Collections.unmodifiableSet(this.innerVariables);
        }

        public boolean topLevelDeclarationsConfictWith(IfStatementBranch testBranch) {
            Set<String> innerVariables = testBranch.getInnerVariables();
            Set<String> topLevel = testBranch.getTopLevelVariables();
            return IfStatementBranch.hasNonEmptyIntersection(this.topLevelVariables, topLevel) || IfStatementBranch.hasNonEmptyIntersection(this.topLevelVariables, innerVariables);
        }

        private static boolean hasNonEmptyIntersection(Set<String> set1, Set<String> set2) {
            for (String set1Element : set1) {
                if (!set2.contains(set1Element)) continue;
                return true;
            }
            return false;
        }
    }

    private static class IfToSwitchPredicate
    implements JSElementPredicate {
        private IfToSwitchPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/switchtoif/JSReplaceIfWithSwitchIntention$IfToSwitchPredicate", "satisfiedBy"));
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                return false;
            }
            String text = element.getText();
            if (!JSReplaceIfWithSwitchIntention.IF_KEYWORD.equals(text)) {
                return false;
            }
            JSIfStatement statement = (JSIfStatement)parent;
            if (ErrorUtil.containsError((PsiElement)statement)) {
                return false;
            }
            return CaseUtil.getCaseExpression(statement) != null;
        }
    }
}

