/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.trivialif;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSElementPredicate;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.intellij.idea.lang.javascript.psiutil.EquivalenceChecker;
import org.intellij.idea.lang.javascript.psiutil.ErrorUtil;
import org.intellij.idea.lang.javascript.psiutil.JSElementFactory;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JSMergeIfOrIntention
extends JSIntention {
    @NonNls
    private static final String IF_STATEMENT_PREFIX = "if (";
    @NonNls
    private static final String ELSE_KEYWORD = "else ";

    @Override
    @NotNull
    public JSElementPredicate getElementPredicate() {
        MergeIfOrPredicate mergeIfOrPredicate = new MergeIfOrPredicate();
        if (mergeIfOrPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfOrIntention", "getElementPredicate"));
        }
        return mergeIfOrPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfOrIntention", "processIntention"));
        }
        assert (element instanceof JSElement);
        JSElement jsElement = (JSElement)element;
        if (MergeIfOrPredicate.isMergableExplicitIf(jsElement)) {
            JSMergeIfOrIntention.replaceMergeableExplicitIf(jsElement);
        } else {
            JSMergeIfOrIntention.replaceMergeableImplicitIf(jsElement);
        }
    }

    private static void replaceMergeableExplicitIf(JSElement token) throws IncorrectOperationException {
        JSIfStatement parentStatement = (JSIfStatement)(token.getParent() instanceof JSIfStatement ? token.getParent() : token);
        assert (parentStatement != null);
        JSIfStatement childStatement = (JSIfStatement)parentStatement.getElse();
        JSExpression childCondition = childStatement.getCondition();
        JSExpression condition = parentStatement.getCondition();
        String childConditionText = ParenthesesUtils.getParenthesized(childCondition, 14);
        String parentConditionText = ParenthesesUtils.getParenthesized(condition, 14);
        JSStatement parentThenBranch = parentStatement.getThen();
        String parentThenBranchText = parentThenBranch.getText();
        StringBuilder statement = new StringBuilder(IF_STATEMENT_PREFIX).append(parentConditionText).append(" || ").append(childConditionText).append(')').append(parentThenBranchText);
        JSStatement childElseBranch = childStatement.getElse();
        if (childElseBranch != null) {
            String childElseBranchText = childElseBranch.getText();
            statement.append(ELSE_KEYWORD).append(childElseBranchText);
        }
        JSElementFactory.replaceStatement((JSStatement)parentStatement, statement.toString());
    }

    private static void replaceMergeableImplicitIf(JSElement token) throws IncorrectOperationException {
        JSIfStatement parentStatement = (JSIfStatement)(token.getParent() instanceof JSIfStatement ? token.getParent() : token);
        JSIfStatement childStatement = (JSIfStatement)JSElementFactory.getNonWhiteSpaceSibling((PsiElement)parentStatement, true);
        assert (childStatement != null);
        assert (parentStatement != null);
        JSExpression childCondition = childStatement.getCondition();
        JSExpression condition = parentStatement.getCondition();
        String childConditionText = ParenthesesUtils.getParenthesized(childCondition, 14);
        String parentConditionText = ParenthesesUtils.getParenthesized(condition, 14);
        JSStatement parentThenBranch = parentStatement.getThen();
        JSStatement childElseBranch = childStatement.getElse();
        StringBuilder statement = new StringBuilder(IF_STATEMENT_PREFIX).append(parentConditionText).append(" || ").append(childConditionText).append(')').append(parentThenBranch.getText());
        if (childElseBranch != null) {
            statement.append(ELSE_KEYWORD).append(childElseBranch.getText());
        }
        JSElementFactory.replaceStatement((JSStatement)parentStatement, statement.toString());
        JSElementFactory.removeElement((PsiElement)childStatement);
    }

    private static class MergeIfOrPredicate
    implements JSElementPredicate {
        private MergeIfOrPredicate() {
        }

        @Override
        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/trivialif/JSMergeIfOrIntention$MergeIfOrPredicate", "satisfiedBy"));
            }
            if (!(element instanceof JSElement)) {
                return false;
            }
            JSElement jsElement = (JSElement)element;
            return MergeIfOrPredicate.isMergableExplicitIf(jsElement) || MergeIfOrPredicate.isMergableImplicitIf(jsElement);
        }

        public static boolean isMergableExplicitIf(JSElement element) {
            JSIfStatement ifStatement;
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            if (ErrorUtil.containsError((PsiElement)(ifStatement = (JSIfStatement)parent))) {
                return false;
            }
            JSStatement thenBranch = ifStatement.getThen();
            JSStatement elseBranch = ifStatement.getElse();
            if (thenBranch == null || elseBranch == null) {
                return false;
            }
            if (!(elseBranch instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement childIfStatement = (JSIfStatement)elseBranch;
            JSStatement childThenBranch = childIfStatement.getThen();
            return EquivalenceChecker.statementsAreEquivalent(thenBranch, childThenBranch);
        }

        private static boolean isMergableImplicitIf(JSElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSIfStatement)) {
                if (element instanceof JSIfStatement) {
                    parent = element;
                } else {
                    return false;
                }
            }
            JSIfStatement ifStatement = (JSIfStatement)parent;
            JSStatement thenBranch = ifStatement.getThen();
            JSStatement elseBranch = ifStatement.getElse();
            if (thenBranch == null || elseBranch != null) {
                return false;
            }
            if (ControlFlowUtils.statementMayCompleteNormally((JSStatement)thenBranch)) {
                return false;
            }
            PsiElement nextStatement = JSElementFactory.getNonWhiteSpaceSibling((PsiElement)ifStatement, true);
            if (!(nextStatement instanceof JSIfStatement)) {
                return false;
            }
            JSIfStatement childIfStatement = (JSIfStatement)nextStatement;
            JSStatement childThenBranch = childIfStatement.getThen();
            return EquivalenceChecker.statementsAreEquivalent(thenBranch, childThenBranch);
        }
    }
}

