/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.psiutil;

import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSEmptyStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.intellij.idea.lang.javascript.psiutil.ParenthesesUtils;

public class EquivalenceChecker {
    private static final int THIS_EXPRESSION = 0;
    private static final int LITERAL_EXPRESSION = 1;
    private static final int CLASS_OBJECT_EXPRESSION = 2;
    private static final int REFERENCE_EXPRESSION = 3;
    private static final int SUPER_EXPRESSION = 4;
    private static final int CALL_EXPRESSION = 5;
    private static final int NEW_EXPRESSION = 6;
    private static final int ARRAY_LITERAL_EXPRESSION = 7;
    private static final int PREFIX_EXPRESSION = 8;
    private static final int POSTFIX_EXPRESSION = 9;
    private static final int ASSIGNMENT_EXPRESSION = 10;
    private static final int BINARY_EXPRESSION = 11;
    private static final int CONDITIONAL_EXPRESSION = 12;
    private static final int INDEX_PROPERTY_ACCESS_EXPRESSION = 13;
    private static final int OBJECT_LITERAL_EXPRESSION = 14;
    private static final int FUNCTION_EXPRESSION = 15;
    private static final int DEFINITION_EXPRESSION = 16;
    private static final int BLOCK_STATEMENT = 0;
    private static final int BREAK_STATEMENT = 1;
    private static final int CONTINUE_STATEMENT = 2;
    private static final int VAR_STATEMENT = 3;
    private static final int DO_WHILE_STATEMENT = 4;
    private static final int EMPTY_STATEMENT = 5;
    private static final int EXPRESSION_STATEMENT = 6;
    private static final int FOR_STATEMENT = 7;
    private static final int FOR_IN_STATEMENT = 8;
    private static final int IF_STATEMENT = 9;
    private static final int LABELED_STATEMENT = 10;
    private static final int RETURN_STATEMENT = 11;
    private static final int SWITCH_STATEMENT = 12;
    private static final int THROW_STATEMENT = 13;
    private static final int TRY_STATEMENT = 14;
    private static final int WHILE_STATEMENT = 15;
    private static final int WITH_STATEMENT = 16;

    private EquivalenceChecker() {
    }

    public static boolean statementsAreEquivalent(JSStatement exp1, JSStatement exp2) {
        int type2;
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        int type1 = EquivalenceChecker.getStatementType(exp1);
        if (type1 != (type2 = EquivalenceChecker.getStatementType(exp2))) {
            return false;
        }
        switch (type1) {
            case 0: {
                return EquivalenceChecker.codeBlocksAreEquivalent((JSBlockStatement)exp1, (JSBlockStatement)exp2);
            }
            case 1: {
                return EquivalenceChecker.breakStatementsAreEquivalent((JSBreakStatement)exp1, (JSBreakStatement)exp2);
            }
            case 2: {
                return EquivalenceChecker.continueStatementsAreEquivalent((JSContinueStatement)exp1, (JSContinueStatement)exp2);
            }
            case 3: {
                return EquivalenceChecker.declarationStatementsAreEquivalent((JSVarStatement)exp1, (JSVarStatement)exp2);
            }
            case 4: {
                return EquivalenceChecker.doWhileStatementsAreEquivalent((JSDoWhileStatement)exp1, (JSDoWhileStatement)exp2);
            }
            case 5: {
                return true;
            }
            case 6: {
                return EquivalenceChecker.expressionStatementsAreEquivalent((JSExpressionStatement)exp1, (JSExpressionStatement)exp2);
            }
            case 7: {
                return EquivalenceChecker.forStatementsAreEquivalent((JSForStatement)exp1, (JSForStatement)exp2);
            }
            case 8: {
                return EquivalenceChecker.forInStatementsAreEquivalent((JSForInStatement)exp1, (JSForInStatement)exp2);
            }
            case 9: {
                return EquivalenceChecker.ifStatementsAreEquivalent((JSIfStatement)exp1, (JSIfStatement)exp2);
            }
            case 10: {
                return EquivalenceChecker.labeledStatementsAreEquivalent((JSLabeledStatement)exp1, (JSLabeledStatement)exp2);
            }
            case 11: {
                return EquivalenceChecker.returnStatementsAreEquivalent((JSReturnStatement)exp1, (JSReturnStatement)exp2);
            }
            case 12: {
                return EquivalenceChecker.switchStatementsAreEquivalent((JSSwitchStatement)exp1, (JSSwitchStatement)exp2);
            }
            case 13: {
                return EquivalenceChecker.throwStatementsAreEquivalent((JSThrowStatement)exp1, (JSThrowStatement)exp2);
            }
            case 14: {
                return EquivalenceChecker.tryStatementsAreEquivalent((JSTryStatement)exp1, (JSTryStatement)exp2);
            }
            case 15: {
                return EquivalenceChecker.whileStatementsAreEquivalent((JSWhileStatement)exp1, (JSWhileStatement)exp2);
            }
            case 16: {
                return EquivalenceChecker.withStatementsAreEquivalent((JSWithStatement)exp1, (JSWithStatement)exp2);
            }
        }
        return false;
    }

    private static boolean declarationStatementsAreEquivalent(JSVarStatement statement1, JSVarStatement statement2) {
        JSVariable[] vars2;
        if (statement1 == null || statement2 == null) {
            return statement1 == statement2;
        }
        JSVariable[] vars1 = statement1.getVariables();
        if (vars1.length == (vars2 = statement2.getVariables()).length) {
            for (int index = 0; index < vars2.length; ++index) {
                if (EquivalenceChecker.localVariableAreEquivalent(vars1[index], vars2[index])) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean tryStatementsAreEquivalent(JSTryStatement statement1, JSTryStatement statement2) {
        if (!EquivalenceChecker.statementsAreEquivalent(statement1.getStatement(), statement2.getStatement())) {
            return false;
        }
        if (!EquivalenceChecker.statementsAreEquivalent(statement1.getFinallyStatement(), statement2.getFinallyStatement())) {
            return false;
        }
        JSCatchBlock catchBlock1 = statement1.getCatchBlock();
        JSCatchBlock catchBlock2 = statement2.getCatchBlock();
        if (catchBlock1 == null) {
            return catchBlock2 == null;
        }
        if (catchBlock2 == null) {
            return false;
        }
        if (!EquivalenceChecker.parametersAreEquivalent(catchBlock1.getParameter(), catchBlock2.getParameter())) {
            return false;
        }
        return EquivalenceChecker.statementsAreEquivalent(catchBlock1.getStatement(), catchBlock2.getStatement());
    }

    private static boolean localVariableAreEquivalent(JSVariable var1, JSVariable var2) {
        return EquivalenceChecker.expressionsAreEquivalent(var1.getInitializer(), var2.getInitializer()) && EquivalenceChecker.typesAreEquivalent(var1.getType(), var2.getType()) && EquivalenceChecker.areEqual(var1.getName(), var2.getName());
    }

    private static boolean parametersAreEquivalent(JSParameter parameter1, JSParameter parameter2) {
        return EquivalenceChecker.typesAreEquivalent(parameter1.getType(), parameter2.getType()) && EquivalenceChecker.areEqual(parameter1.getName(), parameter2.getName());
    }

    private static boolean typesAreEquivalent(JSType type1, JSType type2) {
        return EquivalenceChecker.areEqual(type1, type2);
    }

    private static boolean whileStatementsAreEquivalent(JSWhileStatement statement1, JSWhileStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getCondition(), statement2.getCondition()) && EquivalenceChecker.statementsAreEquivalent(statement1.getBody(), statement2.getBody());
    }

    private static boolean forStatementsAreEquivalent(JSForStatement statement1, JSForStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getCondition(), statement2.getCondition()) && EquivalenceChecker.expressionsAreEquivalent(statement1.getInitialization(), statement2.getInitialization()) && EquivalenceChecker.expressionsAreEquivalent(statement1.getUpdate(), statement2.getUpdate()) && EquivalenceChecker.statementsAreEquivalent(statement1.getBody(), statement2.getBody());
    }

    private static boolean forInStatementsAreEquivalent(JSForInStatement statement1, JSForInStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getCollectionExpression(), statement2.getCollectionExpression()) && EquivalenceChecker.expressionsAreEquivalent(statement1.getVariableExpression(), statement2.getVariableExpression()) && EquivalenceChecker.declarationStatementsAreEquivalent(statement1.getDeclarationStatement(), statement2.getDeclarationStatement()) && EquivalenceChecker.statementsAreEquivalent(statement1.getBody(), statement2.getBody());
    }

    private static boolean switchStatementsAreEquivalent(JSSwitchStatement statement1, JSSwitchStatement statement2) {
        JSCaseClause[] caseClauses2;
        if (!EquivalenceChecker.expressionsAreEquivalent(statement1.getSwitchExpression(), statement2.getSwitchExpression())) {
            return false;
        }
        JSCaseClause[] caseClauses1 = statement1.getCaseClauses();
        if (caseClauses1.length != (caseClauses2 = statement2.getCaseClauses()).length) {
            return false;
        }
        for (int index = 0; index < caseClauses1.length; ++index) {
            if (EquivalenceChecker.caseClausesAreEquivalent(caseClauses1[index], caseClauses2[index])) continue;
            return false;
        }
        return true;
    }

    private static boolean caseClausesAreEquivalent(JSCaseClause caseClause1, JSCaseClause caseClause2) {
        JSStatement[] statements2;
        if (caseClause1.isDefault() != caseClause2.isDefault()) {
            return false;
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(caseClause1.getCaseExpression(), caseClause2.getCaseExpression())) {
            return false;
        }
        JSStatement[] statements1 = caseClause1.getStatements();
        if (statements1.length != (statements2 = caseClause2.getStatements()).length) {
            return false;
        }
        for (int index = 0; index < statements1.length; ++index) {
            if (EquivalenceChecker.statementsAreEquivalent(statements1[index], statements2[index])) continue;
            return false;
        }
        return false;
    }

    private static boolean doWhileStatementsAreEquivalent(JSDoWhileStatement statement1, JSDoWhileStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getCondition(), statement2.getCondition()) && EquivalenceChecker.statementsAreEquivalent(statement1.getBody(), statement2.getBody());
    }

    private static boolean codeBlocksAreEquivalent(JSBlockStatement statement1, JSBlockStatement statement2) {
        if (statement1 == null && statement2 == null) {
            return true;
        }
        if (statement1 == null || statement2 == null) {
            return false;
        }
        return EquivalenceChecker.blockStatementsAreEquivalent(statement1.getStatements(), statement2.getStatements());
    }

    private static boolean breakStatementsAreEquivalent(JSBreakStatement statement1, JSBreakStatement statement2) {
        return EquivalenceChecker.areEqual(statement1.getLabel(), statement2.getLabel());
    }

    private static boolean continueStatementsAreEquivalent(JSContinueStatement statement1, JSContinueStatement statement2) {
        return EquivalenceChecker.areEqual(statement1.getLabel(), statement2.getLabel());
    }

    private static boolean labeledStatementsAreEquivalent(JSLabeledStatement statement1, JSLabeledStatement statement2) {
        PsiElement element1 = statement1.getLabelIdentifier();
        PsiElement element2 = statement2.getLabelIdentifier();
        return element1 == null ? element2 == null : element2 != null && element1.getText().equals(element2.getText());
    }

    private static boolean blockStatementsAreEquivalent(JSStatement[] statements1, JSStatement[] statements2) {
        if (statements1.length != statements2.length) {
            return false;
        }
        for (int index = 0; index < statements1.length; ++index) {
            if (EquivalenceChecker.statementsAreEquivalent(statements1[index], statements2[index])) continue;
            return false;
        }
        return true;
    }

    private static boolean ifStatementsAreEquivalent(JSIfStatement statement1, JSIfStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getCondition(), statement2.getCondition()) && EquivalenceChecker.statementsAreEquivalent(statement1.getThen(), statement2.getThen()) && EquivalenceChecker.statementsAreEquivalent(statement1.getElse(), statement2.getElse());
    }

    private static boolean expressionStatementsAreEquivalent(JSExpressionStatement statement1, JSExpressionStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getExpression(), statement2.getExpression());
    }

    private static boolean returnStatementsAreEquivalent(JSReturnStatement statement1, JSReturnStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getExpression(), statement2.getExpression());
    }

    private static boolean throwStatementsAreEquivalent(JSThrowStatement statement1, JSThrowStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getExpression(), statement2.getExpression());
    }

    private static boolean withStatementsAreEquivalent(JSWithStatement statement1, JSWithStatement statement2) {
        return EquivalenceChecker.expressionsAreEquivalent(statement1.getExpression(), statement2.getExpression()) && EquivalenceChecker.statementsAreEquivalent(statement1.getStatement(), statement2.getStatement());
    }

    public static boolean expressionsAreEquivalent(JSExpression exp1, JSExpression exp2) {
        int type2;
        if (exp1 == null && exp2 == null) {
            return true;
        }
        if (exp1 == null || exp2 == null) {
            return false;
        }
        JSExpression expToCompare1 = ParenthesesUtils.stripParentheses(exp1);
        JSExpression expToCompare2 = ParenthesesUtils.stripParentheses(exp2);
        int type1 = EquivalenceChecker.getExpressionType(expToCompare1);
        if (type1 != (type2 = EquivalenceChecker.getExpressionType(expToCompare2))) {
            return false;
        }
        switch (type1) {
            case 0: 
            case 4: {
                return true;
            }
            case 1: 
            case 2: 
            case 3: 
            case 16: {
                return expToCompare1.getText().equals(expToCompare2.getText());
            }
            case 5: {
                return EquivalenceChecker.callExpressionsAreEquivalent((JSCallExpression)expToCompare1, (JSCallExpression)expToCompare2);
            }
            case 6: {
                return EquivalenceChecker.newExpressionsAreEquivalent((JSNewExpression)expToCompare1, (JSNewExpression)expToCompare2);
            }
            case 7: {
                return EquivalenceChecker.arrayLiteralExpressionsAreEquivalent((JSArrayLiteralExpression)expToCompare1, (JSArrayLiteralExpression)expToCompare2);
            }
            case 8: {
                return EquivalenceChecker.prefixExpressionsAreEquivalent((JSPrefixExpression)expToCompare1, (JSPrefixExpression)expToCompare2);
            }
            case 9: {
                return EquivalenceChecker.postfixExpressionsAreEquivalent((JSPostfixExpression)expToCompare1, (JSPostfixExpression)expToCompare2);
            }
            case 11: {
                return EquivalenceChecker.binaryExpressionsAreEquivalent((JSBinaryExpression)expToCompare1, (JSBinaryExpression)expToCompare2);
            }
            case 10: {
                return EquivalenceChecker.assignmentExpressionsAreEquivalent((JSAssignmentExpression)expToCompare1, (JSAssignmentExpression)expToCompare2);
            }
            case 12: {
                return EquivalenceChecker.conditionalExpressionsAreEquivalent((JSConditionalExpression)expToCompare1, (JSConditionalExpression)expToCompare2);
            }
            case 13: {
                return EquivalenceChecker.indexedPropertyAccessExpressionsAreEquivalent((JSIndexedPropertyAccessExpression)expToCompare1, (JSIndexedPropertyAccessExpression)expToCompare2);
            }
            case 14: {
                return EquivalenceChecker.objectLiteralExpressionsAreEquivalent((JSObjectLiteralExpression)expToCompare1, (JSObjectLiteralExpression)expToCompare2);
            }
            case 15: {
                return EquivalenceChecker.functionExpressionsAreEquivalent((JSFunctionExpression)expToCompare1, (JSFunctionExpression)expToCompare2);
            }
        }
        return false;
    }

    private static boolean functionExpressionsAreEquivalent(JSFunctionExpression functionExp1, JSFunctionExpression functionExp2) {
        return false;
    }

    private static boolean objectLiteralExpressionsAreEquivalent(JSObjectLiteralExpression objectLiteralExp1, JSObjectLiteralExpression objectLiteralExp2) {
        JSProperty[] properties2;
        JSProperty[] properties1 = objectLiteralExp1.getProperties();
        if (properties1.length != (properties2 = objectLiteralExp2.getProperties()).length) {
            return false;
        }
        for (int index = 0; index < properties2.length; ++index) {
            JSProperty property1 = properties1[index];
            JSProperty property2 = properties2[index];
            String propertyName1 = property1.getName();
            String propertyName2 = property2.getName();
            if (propertyName1 != null && propertyName2 != null && propertyName2.equals(propertyName1) && EquivalenceChecker.expressionsAreEquivalent(property1.getValue(), property2.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean indexedPropertyAccessExpressionsAreEquivalent(JSIndexedPropertyAccessExpression exp1, JSIndexedPropertyAccessExpression exp2) {
        return EquivalenceChecker.expressionsAreEquivalent(exp1.getIndexExpression(), exp2.getIndexExpression()) && EquivalenceChecker.expressionsAreEquivalent(exp1.getQualifier(), exp2.getQualifier());
    }

    private static boolean callExpressionsAreEquivalent(JSCallExpression methodExp1, JSCallExpression methodExp2) {
        JSExpression exp2;
        JSExpression exp1;
        try {
            exp1 = methodExp1.getMethodExpression();
            exp2 = methodExp2.getMethodExpression();
        }
        catch (Exception exception) {
            return false;
        }
        if (!EquivalenceChecker.expressionsAreEquivalent(exp1, exp2)) {
            return false;
        }
        JSArgumentList argumentList1 = methodExp1.getArgumentList();
        JSArgumentList argumentList2 = methodExp2.getArgumentList();
        return argumentList1 != null && argumentList2 != null && EquivalenceChecker.expressionListsAreEquivalent(argumentList1.getArguments(), argumentList2.getArguments());
    }

    private static boolean newExpressionsAreEquivalent(JSNewExpression newExp1, JSNewExpression newExp2) {
        JSExpression exp2;
        JSExpression exp1 = newExp1.getMethodExpression();
        if (!EquivalenceChecker.expressionsAreEquivalent(exp1, exp2 = newExp2.getMethodExpression())) {
            return false;
        }
        JSArgumentList argumentList1 = newExp1.getArgumentList();
        JSArgumentList argumentList2 = newExp2.getArgumentList();
        return argumentList1 != null && argumentList2 != null && EquivalenceChecker.expressionListsAreEquivalent(argumentList1.getArguments(), argumentList2.getArguments());
    }

    private static boolean arrayLiteralExpressionsAreEquivalent(JSArrayLiteralExpression arrInitExp1, JSArrayLiteralExpression arrInitExp2) {
        return EquivalenceChecker.expressionListsAreEquivalent(arrInitExp1.getExpressions(), arrInitExp2.getExpressions());
    }

    private static boolean prefixExpressionsAreEquivalent(JSPrefixExpression prefixExp1, JSPrefixExpression prefixExp2) {
        IElementType operator1 = prefixExp1.getOperationSign();
        IElementType operator2 = prefixExp2.getOperationSign();
        return operator1 != null && operator2 != null && operator1.equals(operator2) && EquivalenceChecker.expressionsAreEquivalent(prefixExp1.getExpression(), prefixExp2.getExpression());
    }

    private static boolean postfixExpressionsAreEquivalent(JSPostfixExpression postfixExp1, JSPostfixExpression postfixExp2) {
        IElementType operator2;
        IElementType operator1 = postfixExp1.getOperationSign();
        return operator1.equals(operator2 = postfixExp2.getOperationSign()) && EquivalenceChecker.expressionsAreEquivalent(postfixExp1.getExpression(), postfixExp2.getExpression());
    }

    private static boolean binaryExpressionsAreEquivalent(JSBinaryExpression binaryExp1, JSBinaryExpression binaryExp2) {
        IElementType operator2;
        IElementType operator1 = binaryExp1.getOperationSign();
        return operator1.equals(operator2 = binaryExp2.getOperationSign()) && EquivalenceChecker.expressionsAreEquivalent(binaryExp1.getLOperand(), binaryExp2.getLOperand()) && EquivalenceChecker.expressionsAreEquivalent(binaryExp1.getROperand(), binaryExp2.getROperand());
    }

    private static boolean assignmentExpressionsAreEquivalent(JSAssignmentExpression assignExp1, JSAssignmentExpression assignExp2) {
        IElementType operator2;
        IElementType operator1 = assignExp1.getOperationSign();
        return operator1.equals(operator2 = assignExp2.getOperationSign()) && EquivalenceChecker.expressionsAreEquivalent(assignExp1.getLOperand(), assignExp2.getLOperand()) && EquivalenceChecker.expressionsAreEquivalent(assignExp1.getROperand(), assignExp2.getROperand());
    }

    private static boolean conditionalExpressionsAreEquivalent(JSConditionalExpression condExp1, JSConditionalExpression condExp2) {
        return EquivalenceChecker.expressionsAreEquivalent(condExp1.getCondition(), condExp2.getCondition()) && EquivalenceChecker.expressionsAreEquivalent(condExp1.getThen(), condExp2.getThen()) && EquivalenceChecker.expressionsAreEquivalent(condExp1.getElse(), condExp2.getElse());
    }

    private static boolean expressionListsAreEquivalent(JSExpression[] expressions1, JSExpression[] expressions2) {
        if (expressions1 == null && expressions2 == null) {
            return true;
        }
        if (expressions1 == null || expressions2 == null) {
            return false;
        }
        if (expressions1.length != expressions2.length) {
            return false;
        }
        for (int index = 0; index < expressions1.length; ++index) {
            if (EquivalenceChecker.expressionsAreEquivalent(expressions1[index], expressions2[index])) continue;
            return false;
        }
        return true;
    }

    private static boolean areEqual(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static int getExpressionType(JSExpression exp) {
        if (exp instanceof JSThisExpression) {
            return 0;
        }
        if (exp instanceof JSLiteralExpression) {
            return 1;
        }
        if (exp instanceof JSReferenceExpression) {
            return 3;
        }
        if (exp instanceof JSNewExpression) {
            return 6;
        }
        if (exp instanceof JSCallExpression) {
            return 5;
        }
        if (exp instanceof JSArrayLiteralExpression) {
            return 7;
        }
        if (exp instanceof JSPrefixExpression) {
            return 8;
        }
        if (exp instanceof JSPostfixExpression) {
            return 9;
        }
        if (exp instanceof JSAssignmentExpression) {
            return 10;
        }
        if (exp instanceof JSBinaryExpression) {
            return 11;
        }
        if (exp instanceof JSConditionalExpression) {
            return 12;
        }
        if (exp instanceof JSIndexedPropertyAccessExpression) {
            return 13;
        }
        if (exp instanceof JSFunctionExpression) {
            return 15;
        }
        if (exp instanceof JSObjectLiteralExpression) {
            return 14;
        }
        if (exp instanceof JSDefinitionExpression) {
            return 16;
        }
        return -1;
    }

    private static int getStatementType(JSStatement statement) {
        if (statement instanceof JSBlockStatement) {
            return 0;
        }
        if (statement instanceof JSBreakStatement) {
            return 1;
        }
        if (statement instanceof JSContinueStatement) {
            return 2;
        }
        if (statement instanceof JSVarStatement) {
            return 3;
        }
        if (statement instanceof JSDoWhileStatement) {
            return 4;
        }
        if (statement instanceof JSEmptyStatement) {
            return 5;
        }
        if (statement instanceof JSExpressionStatement) {
            return 6;
        }
        if (statement instanceof JSForStatement) {
            return 7;
        }
        if (statement instanceof JSForInStatement) {
            return 8;
        }
        if (statement instanceof JSIfStatement) {
            return 9;
        }
        if (statement instanceof JSLabeledStatement) {
            return 10;
        }
        if (statement instanceof JSReturnStatement) {
            return 11;
        }
        if (statement instanceof JSSwitchStatement) {
            return 12;
        }
        if (statement instanceof JSThrowStatement) {
            return 13;
        }
        if (statement instanceof JSTryStatement) {
            return 14;
        }
        if (statement instanceof JSWhileStatement) {
            return 15;
        }
        if (statement instanceof JSWithStatement) {
            return 16;
        }
        return -1;
    }
}

