/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.lang;

import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.SingleLazyInstanceSyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.thymeleaf.lang.highlight.ThymeleafSyntaxHighlighter;
import com.intellij.thymeleaf.resources.ThymeleafBundle;
import org.jetbrains.annotations.NotNull;

public class ThymeleafLanguage
extends Language
implements InjectableLanguage {
    public static final ThymeleafLanguage EXPRESSIONS = new ThymeleafLanguage();
    public static final ThymeleafLanguage EACH_EXPRESSIONS = new ThymeleafLanguage(EXPRESSIONS, ThymeleafBundle.message("thymeleaf.iterate.language.id", new Object[0])){};
    public static final ThymeleafLanguage URL_EXPRESSIONS = new ThymeleafLanguage(EXPRESSIONS, ThymeleafBundle.message("thymeleaf.url.language.id", new Object[0])){};
    public static final ThymeleafLanguage TEMPLATES_EXPRESSIONS = new ThymeleafLanguage(EXPRESSIONS, ThymeleafBundle.message("thymeleaf.templates.language.id", new Object[0])){};
    public static final ThymeleafLanguage SPRING_SECURITY_EXPRESSIONS = new ThymeleafLanguage(EXPRESSIONS, ThymeleafBundle.message("thymeleaf.spring.security.language.id", new Object[0])){};

    public ThymeleafLanguage() {
        super(ThymeleafBundle.message("thymeleaf.language.id", new Object[0]));
        this.addSyntaxHighlighting();
    }

    protected ThymeleafLanguage(ThymeleafLanguage baseLanguage, String name) {
        super((Language)baseLanguage, name, new String[0]);
        this.addSyntaxHighlighting();
    }

    private void addSyntaxHighlighting() {
        SyntaxHighlighterFactory.LANGUAGE_FACTORY.addExplicitExtension((Object)this, (Object)new SingleLazyInstanceSyntaxHighlighterFactory(){

            @NotNull
            protected SyntaxHighlighter createHighlighter() {
                ThymeleafSyntaxHighlighter thymeleafSyntaxHighlighter = new ThymeleafSyntaxHighlighter();
                if (thymeleafSyntaxHighlighter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafLanguage$5", "createHighlighter"));
                }
                return thymeleafSyntaxHighlighter;
            }
        });
    }

    @NotNull
    public String getDisplayName() {
        if (this == EACH_EXPRESSIONS) {
            if ("Thymeleaf Iterate Expressions" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafLanguage", "getDisplayName"));
            }
            return "Thymeleaf Iterate Expressions";
        }
        if (this == URL_EXPRESSIONS) {
            if ("Thymeleaf URL Expressions" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafLanguage", "getDisplayName"));
            }
            return "Thymeleaf URL Expressions";
        }
        if (this == TEMPLATES_EXPRESSIONS) {
            if ("Thymeleaf Templates Expressions" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafLanguage", "getDisplayName"));
            }
            return "Thymeleaf Templates Expressions";
        }
        if (this == SPRING_SECURITY_EXPRESSIONS) {
            if ("Thymeleaf Spring Security Extras" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafLanguage", "getDisplayName"));
            }
            return "Thymeleaf Spring Security Extras";
        }
        if ("Thymeleaf Expressions" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/lang/ThymeleafLanguage", "getDisplayName"));
        }
        return "Thymeleaf Expressions";
    }
}

