/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.javascript.JSDebuggerSupportUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.ExpressionInfoFactory;
import com.jetbrains.javascript.debugger.GlobalEvaluator;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcessKt;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.jetbrains.javascript.debugger.JavaScriptNameMapper;
import com.jetbrains.javascript.debugger.JavaScriptNameMapperKt;
import com.jetbrains.javascript.debugger.NameMapper;
import com.jetbrains.javascript.debugger.NameMapperKt;
import com.jetbrains.javascript.debugger.SegmentList;
import com.jetbrains.javascript.debugger.SourceEntriesProcessor;
import com.jetbrains.javascript.debugger.SourceMapHelperKt;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PromiseDebuggerEvaluator;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapDecoderKt;
import org.jetbrains.debugger.values.ObjectValue;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J.\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J4\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J*\u0010\u001f\u001a\u0004\u0018\u00010\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J \u0010&\u001a\u0004\u0018\u00010\u001b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006'"}, d2={"Lcom/jetbrains/javascript/debugger/ChromeEvaluator;", "Lorg/jetbrains/debugger/PromiseDebuggerEvaluator;", "Lcom/jetbrains/javascript/debugger/ExpressionInfoFactory;", "context", "Lorg/jetbrains/debugger/VariableContext;", "(Lorg/jetbrains/debugger/VariableContext;)V", "create", "Lcom/intellij/xdebugger/evaluation/ExpressionInfo;", "element", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "createNameMapper", "Lcom/jetbrains/javascript/debugger/NameMapper;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "evaluate", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/EvaluateResult;", "expression", "", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getEvaluationInfoBySourceMap", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "script", "Lorg/jetbrains/debugger/Script;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getExpressionInfoAtOffset", "project", "Lcom/intellij/openapi/project/Project;", "offset", "", "sideEffectsAllowed", "", "getPreferredScript", "JavaScriptDebugger"})
public class ChromeEvaluator
extends PromiseDebuggerEvaluator
implements ExpressionInfoFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public ExpressionInfo getExpressionInfoAtOffset(@NotNull Project project, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        if (!debugProcess.checkCanPerformCommands()) {
            return null;
        }
        LanguageConsoleView languageConsoleView = (LanguageConsoleView)ObjectUtils.tryCast((Object)debugProcess.getSession().getConsoleView(), LanguageConsoleView.class);
        if (languageConsoleView != null && languageConsoleView.getHistoryViewer().getDocument() == document) {
            void lock$iv;
            GlobalEvaluator evaluator = debugProcess.getGlobalEvaluator();
            SegmentList.SegmentListWithData<Pair<String, ObjectValue>> segmentListWithData = evaluator.getValues();
            synchronized (lock$iv) {
                int rangeIndex;
                block8: {
                    rangeIndex = evaluator.getValues().getRangeIndex(offset);
                    if (rangeIndex != -1) break block8;
                    ExpressionInfo expressionInfo = null;
                    return expressionInfo;
                }
                ExpressionInfo expressionInfo = new ExpressionInfo(evaluator.getValues().createRange(rangeIndex), (String)evaluator.getValues().getValueByIndex(rangeIndex).getFirst());
                return expressionInfo;
            }
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return null;
        }
        PsiFile file = psiFile;
        boolean customLogicExists = false;
        JavaScriptDebugAware[] javaScriptDebugAwareArray = (JavaScriptDebugAware[])JavaScriptDebugAware.EP_NAME.getExtensions();
        for (int i = 0; i < javaScriptDebugAwareArray.length; ++i) {
            JavaScriptDebugAware debugAware = javaScriptDebugAwareArray[i];
            if (!debugAware.canGetEvaluationInfo(file)) continue;
            customLogicExists = true;
            ExpressionInfo result = debugAware.getEvaluationInfo(file, offset, document, (ExpressionInfoFactory)this);
            if (result == null) continue;
            return result;
        }
        return customLogicExists ? (ExpressionInfo)null : JSDebuggerSupportUtils.getExpressionAtOffset((Document)document, (PsiFile)file, (int)offset);
    }

    @NotNull
    public ExpressionInfo create(@NotNull PsiElement element, @NotNull Document document) {
        ExpressionInfo expressionInfo;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> javaScriptDebugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        if ((expressionInfo = this.getEvaluationInfoBySourceMap(element, document, javaScriptDebugProcess, virtualFile)) == null) {
            expressionInfo = new ExpressionInfo(element.getTextRange());
        }
        return expressionInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public NameMapper createNameMapper(@NotNull VirtualFile file, @NotNull Document document) {
        void result;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        JavaScriptDebugProcess<?> debugProcess = JavaScriptDebuggerViewSupportKt.getDebugProcess(this.getContext());
        List<Url> urls = debugProcess.getFinder().getRemoteUrls(file);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Function1 processor2 = (Function1)new Function1<Script, Boolean>(urls, file, debugProcess, (Ref.ObjectRef)result, document){
            final /* synthetic */ List $urls;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ JavaScriptDebugProcess $debugProcess;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Document $document;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(@NotNull Script script) {
                JavaScriptNameMapper javaScriptNameMapper;
                SourceMap map;
                Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
                SourceMap sourceMap = map = script.getSourceMap();
                SourceMap sourceMap2 = sourceMap;
                if (sourceMap == null) return true;
                List list = this.$urls;
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"urls");
                Project project = this.$debugProcess.getSession().getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
                MappingList mappingList = sourceMap2.findMappingList(list, this.$file, SourceMapHelperKt.createResolver(project, this.$file));
                sourceMap2 = mappingList;
                if (mappingList == null) return true;
                SourceMap $receiver$iv = sourceMap2;
                MappingList mappingList2 = (MappingList)$receiver$iv;
                Ref.ObjectRef objectRef = this.$result;
                VirtualFile virtualFile = JavaScriptDebugProcess.findFile$default(this.$debugProcess, script.getUrl(), false, 2, null);
                if (virtualFile != null) {
                    JavaScriptNameMapper javaScriptNameMapper2;
                    void $receiver$iv2;
                    VirtualFile virtualFile2 = virtualFile;
                    Ref.ObjectRef objectRef2 = objectRef;
                    VirtualFile file = (VirtualFile)$receiver$iv2;
                    Document document = FileDocumentManager.getInstance().getDocument(file);
                    if (document != null) {
                        void $receiver$iv3;
                        Document it;
                        Document document2 = document;
                        Document document3 = it = (Document)$receiver$iv3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)document3, (String)"it");
                        javaScriptNameMapper2 = new JavaScriptNameMapper(this.$document, document3, mappingList2, map, file);
                    } else {
                        javaScriptNameMapper2 = null;
                    }
                    JavaScriptNameMapper javaScriptNameMapper3 = javaScriptNameMapper2;
                    objectRef = objectRef2;
                    javaScriptNameMapper = javaScriptNameMapper3;
                } else {
                    javaScriptNameMapper = null;
                }
                objectRef.element = javaScriptNameMapper;
                return false;
            }
            {
                this.$urls = list;
                this.$file = virtualFile;
                this.$debugProcess = javaScriptDebugProcess;
                this.$result = objectRef;
                this.$document = document;
                super(1);
            }
        };
        Script preferredScript = this.getPreferredScript(debugProcess, file);
        if (preferredScript != null) {
            processor2.invoke((Object)preferredScript);
        } else {
            debugProcess.forEachScript((Function1<Script, Boolean>)processor2);
        }
        return (NameMapper)result.element;
    }

    /*
     * WARNING - void declaration
     */
    private final ExpressionInfo getEvaluationInfoBySourceMap(PsiElement element, Document document, JavaScriptDebugProcess<?> debugProcess, VirtualFile file) {
        int elementOffset = element.getTextOffset();
        int line = document.getLineNumber(elementOffset);
        int elementColumn = elementOffset - document.getLineStartOffset(line);
        int elementEndColumn = elementColumn + element.getTextLength() - 1;
        MultiMap scriptToMappings = MultiMap.createLinked();
        Script preferredScript = this.getPreferredScript(debugProcess, file);
        SourceEntriesProcessor processor2 = new SourceEntriesProcessor(elementColumn, elementEndColumn, scriptToMappings){
            final /* synthetic */ int $elementColumn;
            final /* synthetic */ int $elementEndColumn;
            final /* synthetic */ MultiMap $scriptToMappings;

            public boolean process(@NotNull MappingEntry entry, @Nullable MappingEntry nextEntry) {
                Intrinsics.checkParameterIsNotNull((Object)entry, (String)"entry");
                int entryColumn = entry.getSourceColumn();
                boolean bl = nextEntry == null || entryColumn == 0 && nextEntry.getSourceColumn() == 0 ? entryColumn <= this.$elementColumn : entryColumn >= this.$elementColumn && entryColumn <= this.$elementEndColumn;
                if (bl) {
                    this.$scriptToMappings.putValue(ObjectUtils.chooseNotNull((Object)this.getScript(), (Object)this.getScriptUrl()), (Object)entry);
                }
                return true;
            }
            {
                this.$elementColumn = $captured_local_variable$0;
                this.$elementEndColumn = $captured_local_variable$1;
                this.$scriptToMappings = $captured_local_variable$2;
            }
        };
        List<Url> sourceUrls = debugProcess.getFinder().getRemoteUrls(file);
        if (preferredScript == null || preferredScript.getSourceMap() == null) {
            List<Url> list = sourceUrls;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"sourceUrls");
            SourceMapHelperKt.processMappingsInLine(debugProcess, list, file, line, processor2);
        } else {
            processor2.setScriptUrl(preferredScript.getUrl());
            SourceMap sourceMap = preferredScript.getSourceMap();
            if (sourceMap == null) {
                Intrinsics.throwNpe();
            }
            List<Url> list = sourceUrls;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"sourceUrls");
            MappingList.MappingsProcessorInLine mappingsProcessorInLine = processor2;
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            sourceMap.processMappingsInLine(list, line, mappingsProcessorInLine, file, SourceMapHelperKt.createResolver(project, file));
            processor2.setScriptUrl(null);
        }
        if (scriptToMappings.isEmpty()) {
            return null;
        }
        Iterator iterator = scriptToMappings.entrySet().iterator();
        while (iterator.hasNext()) {
            Script script;
            void $receiver$iv;
            void $receiver$iv2;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            Object key = $receiver$iv2.getKey();
            Map.Entry $i$f$component1 = entry;
            Collection value = (Collection)$receiver$iv.getValue();
            if (key instanceof Script) {
                script = (Script)key;
            } else {
                Vm vm = debugProcess.getVm();
                if (vm == null) {
                    Intrinsics.throwNpe();
                }
                Object k = key;
                if (k == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Url");
                }
                script = vm.getScriptManager().findScriptByUrl((Url)k);
            }
            if (script == null) {
                continue;
            }
            Script script2 = script;
            Collection collection = value;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<org.jetbrains.debugger.sourcemap.MappingEntry>");
            }
            ExpressionInfo expressionInfo = this.getEvaluationInfoBySourceMap(element, debugProcess, script2, (List)collection);
            if (expressionInfo == null) continue;
            return expressionInfo;
        }
        return null;
    }

    private final Script getPreferredScript(JavaScriptDebugProcess<?> debugProcess, VirtualFile file) {
        CallFrameView topFrameView = (CallFrameView)debugProcess.getSession().getCurrentStackFrame();
        if (topFrameView != null) {
            SourceInfo topFrameSourceInfo;
            SourceInfo sourceInfo = topFrameSourceInfo = topFrameView.getSourcePosition();
            if (Intrinsics.areEqual((Object)(sourceInfo != null ? sourceInfo.getFile() : null), (Object)file)) {
                return topFrameView.getScript();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final ExpressionInfo getEvaluationInfoBySourceMap(PsiElement element, JavaScriptDebugProcess<?> debugProcess, Script script, List<? extends MappingEntry> mappings) {
        VirtualFile virtualFile;
        boolean isNamedElement;
        block13: {
            block12: {
                void $receiver$iv;
                isNamedElement = element.getParent() instanceof PsiNamedElement;
                if (mappings.size() > 1 && isNamedElement) {
                    NameMapperKt.warnSeveralMapping((PsiElement)element);
                    return null;
                }
                virtualFile = JavaScriptDebugProcess.findFile$default(debugProcess, script.getUrl(), false, 2, null);
                if (virtualFile == null) break block12;
                VirtualFile virtualFile2 = virtualFile;
                VirtualFile it = (VirtualFile)$receiver$iv;
                virtualFile = FileDocumentManager.getInstance().getDocument(it);
                if (virtualFile != null) break block13;
            }
            return null;
        }
        VirtualFile rawDocument = virtualFile;
        Collections.sort(mappings, SourceMapDecoderKt.getMAPPING_COMPARATOR_BY_GENERATED_POSITION());
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap == null) {
            Intrinsics.throwNpe();
        }
        SourceMap sourceMap2 = sourceMap;
        CharSequence charSequence = rawDocument.getImmutableCharSequence();
        StringBuilder expressionBuilder = null;
        CharSequence result = null;
        int n = mappings.size();
        for (int i = 0; i < n; ++i) {
            int end;
            MappingEntry nextMapping;
            MappingEntry mapping = mappings.get(i);
            MappingEntry mappingEntry = nextMapping = i + 1 < n ? mappings.get(i + 1) : (MappingEntry)null;
            if (nextMapping == null) {
                nextMapping = sourceMap2.getMappings().getNext(mapping);
            }
            int generatedLineStartOffset = rawDocument.getLineStartOffset(mapping.getGeneratedLine());
            int start2 = generatedLineStartOffset + mapping.getGeneratedColumn();
            int n2 = end = nextMapping == null || nextMapping.getGeneratedLine() != mapping.getGeneratedLine() ? rawDocument.getLineEndOffset(mapping.getGeneratedLine()) : generatedLineStartOffset + nextMapping.getGeneratedColumn();
            if (nextMapping != null && start2 > end) {
                JavaScriptDebugProcessKt.getLOG().assertTrue(nextMapping.getGeneratedColumn() >= mapping.getGeneratedColumn());
            }
            CharSequence name = charSequence.subSequence(start2, end);
            if (isNamedElement) {
                result = JavaScriptNameMapperKt.doExtractName(name);
                break;
            }
            if (expressionBuilder == null) {
                expressionBuilder = new StringBuilder();
                result = expressionBuilder;
            }
            if (name.length() == 1 && name.charAt(0) == '.') {
                expressionBuilder.append('.');
                continue;
            }
            expressionBuilder.append(NameMapper.Companion.trimName(name, i + 1 == n));
        }
        TextRange textRange = element.getTextRange();
        CharSequence charSequence2 = result;
        if (charSequence2 == null) {
            Intrinsics.throwNpe();
        }
        return new ExpressionInfo(textRange, ((Object)charSequence2).toString(), (String)null);
    }

    @NotNull
    protected Promise<EvaluateResult> evaluate(@NotNull String expression, @Nullable XSourcePosition expressionPosition) {
        Promise promise;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Promise promise2 = null;
        if (this.getContext() instanceof CallFrameView) {
            for (Scope scope : ((CallFrameView)this.getContext()).getCallFrame().getVariableScopes()) {
                if (!Intrinsics.areEqual((Object)scope.getType(), (Object)Scope.Type.LOCAL)) continue;
                promise2 = ((CallFrameView)this.getContext()).getMemberFilter(scope).thenAsync(new AsyncFunction<? super T, SUB_RESULT>(this, expression){
                    final /* synthetic */ ChromeEvaluator this$0;
                    final /* synthetic */ String $expression;

                    @NotNull
                    public final Promise<EvaluateResult> fun(MemberFilter it) {
                        EvaluateContext evaluateContext = ((CallFrameView)ChromeEvaluator.access$getContext$p(this.this$0)).getEvaluateContext();
                        String string = it.sourceNameToRaw(this.$expression);
                        if (string == null) {
                            string = this.$expression;
                        }
                        return EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)string, null, (boolean)false, (int)6, null);
                    }
                    {
                        this.this$0 = chromeEvaluator;
                        this.$expression = string;
                    }
                });
                break;
            }
        }
        if ((promise = promise2) == null) {
            promise = super.evaluate(expression, expressionPosition);
        }
        return promise;
    }

    public ChromeEvaluator(@NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }

    @NotNull
    public static final /* synthetic */ VariableContext access$getContext$p(ChromeEvaluator $this) {
        return $this.getContext();
    }
}

