/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.util.text.SimilarityIndex;
import com.intellij.openapi.util.text.SimilarityIndexKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcessKt;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapLoaderKt;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asar.AsarFileSystem;
import org.jetbrains.asar.FileItem;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a*\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a*\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0006\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"RENAME_SCORE", "", "resolveFileBySourceUrl", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "url", "sourceContent", "", "selectMostSimilarFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "", "sourceBytes", "", "findFileIfAsar", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "JavaScriptDebugger"})
public final class FileResolverByContentKt {
    private static final int RENAME_SCORE = 60;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile findFileIfAsar(JavaScriptDebugProcess<?> $receiver, @NotNull Url url) {
        Unit unit;
        void endIndex$iv2;
        void startIndex$iv;
        AsarFileSystem $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (!url.isInLocalFileSystem()) {
            return null;
        }
        String scriptPath = url.getPath();
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)SourceMapLoaderKt.ASAR, (int)0, (boolean)false, (int)6, null);
        if (index <= 0) {
            return null;
        }
        String string = scriptPath;
        boolean bl = false;
        int n = index + (SourceMapLoaderKt.ASAR.length() - 1);
        JavaScriptDebugProcess<?> javaScriptDebugProcess = $receiver;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)v0).substring((int)startIndex$iv, (int)endIndex$iv2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string3 = string2;
        AsarFileSystem asarFileSystem = javaScriptDebugProcess.getAsarFs$JavaScriptDebugger(string3);
        if (asarFileSystem != null) {
            Unit unit2;
            int startIndex$iv2;
            Object $receiver$iv2;
            $receiver$iv = asarFileSystem;
            AsarFileSystem fs = $receiver$iv;
            String endIndex$iv2 = scriptPath;
            int $i$f$substring = index + SourceMapLoaderKt.ASAR.length();
            void v3 = $receiver$iv2;
            if (v3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = ((String)v3).substring(startIndex$iv2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            String scriptRelativePath = string4;
            $receiver$iv2 = scriptPath;
            startIndex$iv2 = index + SourceMapLoaderKt.ASAR.length();
            AsarFileSystem asarFileSystem2 = fs;
            String string5 = $receiver$iv2;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(startIndex$iv2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String string7 = string6;
            FileItem fileItem = asarFileSystem2.getFile(string7);
            if (fileItem != null) {
                Iterable $receiver$iv3;
                Collection collection;
                $receiver$iv2 = fileItem;
                FileItem fileItem2 = (FileItem)$receiver$iv2;
                GlobalSearchScope scope = ProjectScope.getContentScope((Project)$receiver.getSession().getProject());
                Object token$iv = ReadAction.start();
                try {
                    collection = FilenameIndex.getVirtualFilesByName((Project)$receiver.getSession().getProject(), (String)PathUtilRt.getFileName((String)scriptRelativePath), (GlobalSearchScope)scope);
                }
                finally {
                    token$iv.finish();
                }
                Collection files = collection;
                token$iv = files;
                if (!$receiver$iv3.isEmpty()) {
                    void destination$iv;
                    $receiver$iv3 = files;
                    Collection $i$f$isNotEmpty = (Collection)new SmartList();
                    for (Object element$iv : $receiver$iv3) {
                        VirtualFile it = (VirtualFile)element$iv;
                        String string8 = it.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"it.path");
                        if (!FileUtilKt.endsWithName((String)string8, (String)scriptRelativePath)) continue;
                        destination$iv.add(element$iv);
                    }
                    files = destination$iv;
                    $receiver$iv3 = files;
                    if (!$receiver$iv3.isEmpty()) {
                        return FileResolverByContentKt.selectMostSimilarFile$default(files, fs.loadBytes(fileItem2), null, 4, null);
                    }
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = null;
            }
            unit = unit2;
        } else {
            unit = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final Url resolveFileBySourceUrl(@NotNull Project project, @NotNull Url url, @Nullable String sourceContent) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (Intrinsics.areEqual((Object)url.getScheme(), (Object)"webpack") ? JavaScriptDebugProcessKt.isWebpackLibraryFile(url) : !(!Intrinsics.areEqual((Object)url.getScheme(), (Object)"http") && !Intrinsics.areEqual((Object)url.getScheme(), (Object)"https") || url.isInLocalFileSystem() && !Files.exists(Paths.get(url.getPath(), new String[0]), LinkOption.NOFOLLOW_LINKS))) {
            return null;
        }
        String fileName = PathUtilRt.getFileName((String)url.getPath());
        CharSequence charSequence = fileName;
        if ($receiver$iv.length() > 0) {
            CharSequence $receiver$iv2;
            Collection collection;
            GlobalSearchScope scope = ProjectScope.getContentScope((Project)project);
            Object token$iv = ReadAction.start();
            try {
                collection = FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope);
            }
            finally {
                token$iv.finish();
            }
            Collection files = collection;
            token$iv = files;
            if (!$receiver$iv2.isEmpty()) {
                $receiver$iv2 = sourceContent;
                if (!($receiver$iv2 == null || $receiver$iv2.length() == 0)) {
                    Collection collection2 = files;
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"files");
                    String string = sourceContent;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    VirtualFile virtualFile = FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)collection2, string, project);
                    if (virtualFile != null) {
                        $receiver$iv2 = virtualFile;
                        VirtualFile it = (VirtualFile)$receiver$iv2;
                        return Urls.newLocalFileUrl((VirtualFile)it);
                    }
                } else if (files.size() == 1) {
                    return Urls.newLocalFileUrl((VirtualFile)((VirtualFile)CollectionsKt.first((Iterable)files)));
                }
            }
        }
        return null;
    }

    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files, @NotNull String sourceContent, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)sourceContent, (String)"sourceContent");
        String string = sourceContent;
        Charset charset = null;
        boolean bl = true;
        Object var6_6 = null;
        Collection<? extends VirtualFile> collection = files;
        if (var6_6 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return FileResolverByContentKt.selectMostSimilarFile(collection, byArray2, project);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, String string, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: selectMostSimilarFile");
        }
        if ((n & 4) != 0) {
            project = null;
        }
        return FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)collection, string, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final VirtualFile selectMostSimilarFile(@NotNull Collection<? extends VirtualFile> files, @NotNull byte[] sourceBytes, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)sourceBytes, (String)"sourceBytes");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        VirtualFile matchedFile = null;
        int lastMatchedScore = RENAME_SCORE;
        for (VirtualFile virtualFile : files) {
            int contentScore;
            int score;
            int n;
            byte[] $i$a$1;
            int length = (int)virtualFile.getLength();
            int max = Math.max(sourceBytes.length, length);
            int min = Math.min(sourceBytes.length, length);
            if (min * 100 / max < RENAME_SCORE) continue;
            if (project != null) {
                Boolean bl;
                AccessToken token$iv = ReadAction.start();
                try {
                    bl = JSMinifiedFileUtil.isFileMinified((VirtualFile)virtualFile, (Project)project);
                }
                finally {
                    token$iv.finish();
                }
                if (bl.booleanValue()) continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile.contentsToByteArray(), (String)"file.contentsToByteArray()");
            int n2 = 0;
            int $i$f$runReadAction = 4;
            Object var15_19 = null;
            if (var15_19 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: similarityScore");
            }
            if (($i$f$runReadAction & 4) != 0) {
                n2 = SimilarityIndexKt.MAX_SCORE;
            }
            if (Arrays.equals(sourceBytes, $i$a$1)) {
                n = n2;
            } else {
                void sourceIndex;
                if ((SimilarityIndex)sourceIndex.element == null) {
                    sourceIndex.element = SimilarityIndexKt.SimilarityIndex(sourceBytes);
                }
                SimilarityIndex similarityIndex = (SimilarityIndex)sourceIndex.element;
                if (similarityIndex == null) {
                    Intrinsics.throwNpe();
                }
                n = SimilarityIndex.score$default(similarityIndex, SimilarityIndexKt.SimilarityIndex($i$a$1), 0, 2, null);
            }
            if ((score = ((contentScore = n) * 99 + 100) / 10000) <= lastMatchedScore) continue;
            matchedFile = virtualFile;
            lastMatchedScore = score;
        }
        return matchedFile;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ VirtualFile selectMostSimilarFile$default(Collection collection, byte[] byArray, Project project, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: selectMostSimilarFile");
        }
        if ((n & 4) != 0) {
            project = null;
        }
        return FileResolverByContentKt.selectMostSimilarFile((Collection<? extends VirtualFile>)collection, byArray, project);
    }
}

