/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.jetbrains.javascript.debugger.GlobalVariablesHolder;
import com.jetbrains.javascript.debugger.JavaScriptDebuggerConsoleExecuteActionHandler;
import com.jetbrains.javascript.debugger.VariablesHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000*\u0001\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/javascript/debugger/GlobalVariablesHolder;", "Lcom/jetbrains/javascript/debugger/VariablesHolder;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "(Lorg/jetbrains/debugger/DebuggerViewSupport;)V", "variablesLoader", "com/jetbrains/javascript/debugger/GlobalVariablesHolder$variablesLoader$1", "Lcom/jetbrains/javascript/debugger/GlobalVariablesHolder$variablesLoader$1;", "getVariablesLoader", "Lorg/jetbrains/concurrency/AsyncValueLoader;", "", "JavaScriptDebugger"})
public final class GlobalVariablesHolder
extends VariablesHolder {
    private final variablesLoader.1 variablesLoader;

    @NotNull
    protected AsyncValueLoader<Boolean> getVariablesLoader() {
        return this.variablesLoader;
    }

    public GlobalVariablesHolder(@NotNull DebuggerViewSupport viewSupport) {
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        super(viewSupport);
        this.variablesLoader = new AsyncValueLoader<Boolean>(this, viewSupport){
            final /* synthetic */ GlobalVariablesHolder this$0;
            final /* synthetic */ DebuggerViewSupport $viewSupport;

            protected boolean isCancelOnReject() {
                return true;
            }

            @NotNull
            protected Promise<Boolean> load(@NotNull AsyncPromise<Boolean> promise) {
                Intrinsics.checkParameterIsNotNull(promise, (String)"promise");
                Vm vm = this.$viewSupport.getVm();
                if (vm == null) {
                    promise.setError("vm disconnected");
                    return (Promise)promise;
                }
                EvaluateContext globalEvaluateContext = vm.getEvaluateContext();
                if (globalEvaluateContext == null) {
                    promise.setError("vm global evaluate unsupported");
                    return (Promise)promise;
                }
                String string = JavaScriptDebuggerConsoleExecuteActionHandler.class.getSimpleName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JavaScriptDebuggerConsol\u2026er::class.java.simpleName");
                EvaluateContext evaluateContext = globalEvaluateContext.withValueManager(string);
                Promise promise2 = EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)"this", null, (boolean)false, (int)6, null).thenAsync((AsyncFunction)new AsyncFunction<? super T, SUB_RESULT>(this){
                    final /* synthetic */ variablesLoader.1 this$0;

                    @NotNull
                    public final Promise<Boolean> fun(EvaluateResult it) {
                        Value value = it.getValue();
                        if (!(value instanceof ObjectValue)) {
                            return PromiseKt.resolvedPromise((Object)true);
                        }
                        return ((ObjectValue)value).getProperties().then((Function)new Function<? super T, ? extends SUB_RESULT>(this){
                            final /* synthetic */ variablesLoader.load.1 this$0;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * WARNING - void declaration
                             */
                            public final boolean fun(List<? extends Variable> variables) {
                                if (this.this$0.this$0.$viewSupport.getVm() == null || variables.isEmpty()) {
                                    return true;
                                }
                                AccessToken token$iv = ReadAction.start();
                                try {
                                    for (Variable variable : variables) {
                                        LookupElementBuilder lookupElementBuilder;
                                        String psiTypeName;
                                        String name = variable.getName();
                                        if (this.this$0.this$0.this$0.nameToPsiTypeName.put((Object)name, (Object)(psiTypeName = VariablesHolder.backendTypeNameToPsiTypeName(variable.getValue()))) != null) continue;
                                        LookupElementBuilder lookupItem = LookupElementBuilder.create((String)name);
                                        if (variable.getValue() != null) {
                                            void $receiver$iv;
                                            Value it;
                                            Value value = it = (Value)$receiver$iv;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"it");
                                            lookupElementBuilder = lookupItem.withIcon(VariableView.Companion.getIcon(value));
                                        } else {
                                            lookupElementBuilder = null;
                                        }
                                        LookupElementBuilder lookupElementBuilder2 = lookupItem;
                                        if (lookupElementBuilder2 == null) {
                                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.codeInsight.lookup.LookupElement");
                                        }
                                        this.this$0.this$0.this$0.lookupElements.add((LookupElement)lookupElementBuilder2);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                finally {
                                    token$iv.finish();
                                }
                                return true;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).processed((Consumer)new Consumer<? super T>(evaluateContext){
                    final /* synthetic */ EvaluateContext $evaluateContext;

                    public final void consume(Boolean it) {
                        this.$evaluateContext.releaseObjects();
                    }
                    {
                        this.$evaluateContext = evaluateContext;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"evaluateContext.evaluate\u2026ontext.releaseObjects() }");
                return promise2;
            }
            {
                this.this$0 = $outer;
                this.$viewSupport = $captured_local_variable$1;
            }
        };
    }
}

