/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcessKt;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Location;
import org.jetbrains.io.CharPercentEscaper;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u001a\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"ESCAPED_SLASH", "", "PATTERN_PARAMETERS_POSTFIX", "createUrlRegExp", "location", "Lorg/jetbrains/debugger/Location;", "useCaseSensitiveUrl", "", "escapePath", "", "backslashAware", "builder", "Ljava/lang/StringBuilder;", "encodedUrl", "start", "", "end", "match", "regExp", "input", "JavaScriptDebugger"})
public final class JavaScriptLineBreakpointManagerKt {
    @NotNull
    public static final String PATTERN_PARAMETERS_POSTFIX = "([;?#!].*)?$";
    @NotNull
    public static final String ESCAPED_SLASH = "[/\\\\]";

    private static final String createUrlRegExp(Location location, boolean useCaseSensitiveUrl) {
        StringBuilder builder = new StringBuilder();
        Url url = location.getUrl();
        String scheme = url.getScheme();
        if (scheme == null) {
            builder.append('^');
            String string = url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
            JavaScriptLineBreakpointManagerKt.escapePath$default(false, useCaseSensitiveUrl, builder, string, 0, 0, 32, null);
        } else {
            String filename = PathUtilRt.getFileName((String)url.getPath());
            if (StringsKt.startsWith$default((String)filename, (String)"index.", (boolean)false, (int)2, null) && !url.isInLocalFileSystem()) {
                builder.append('^');
                builder.append(scheme).append("://");
                String string = url.getAuthority();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.authority!!");
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, useCaseSensitiveUrl, builder, string, 0, 0, 48, null);
                builder.append('/');
                int dirLength = url.getPath().length() - filename.length();
                if (dirLength > 0) {
                    builder.append('(');
                    String string2 = url.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.path");
                    JavaScriptLineBreakpointManagerKt.escapePath(false, useCaseSensitiveUrl, builder, string2, 1, dirLength);
                    builder.append('|').append("[^.;?#]+");
                    builder.append(')').append('?');
                }
                builder.append('(');
                String string3 = filename;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"filename");
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, useCaseSensitiveUrl, builder, string3, 0, 0, 32, null);
                builder.append(')').append('?');
            } else {
                boolean useDetailed;
                boolean bl = useDetailed = location.getScript() != null;
                if (!useDetailed) {
                    builder.append('/');
                }
                boolean bl2 = useDetailed || useCaseSensitiveUrl;
                String string = useDetailed ? url.getPath() : filename;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"if (useDetailed) url.path else filename");
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, bl2, builder, string, 0, 0, 32, null);
            }
        }
        builder.append(PATTERN_PARAMETERS_POSTFIX);
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final void escapePath(boolean backslashAware, boolean useCaseSensitiveUrl, @NotNull StringBuilder builder, @NotNull String encodedUrl, int start2, int end) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull((Object)encodedUrl, (String)"encodedUrl");
        int n = start2;
        int n2 = end - 1;
        if (n <= n2) {
            while (true) {
                char lowerCasedChar;
                char upperCasedChar2;
                void i;
                char c = encodedUrl.charAt((int)i);
                if (backslashAware && c == '\\') {
                    builder.append(ESCAPED_SLASH);
                } else if (c == '/') {
                    if (backslashAware) {
                        builder.append(ESCAPED_SLASH);
                    } else {
                        builder.append(c);
                    }
                } else if (StringsKt.contains$default((CharSequence)".?*+^$[](){}|-\\", (char)c, (boolean)false, (int)2, null)) {
                    builder.append('\\').append(c);
                } else if (!useCaseSensitiveUrl && Character.isLetter(c) && (upperCasedChar2 = Character.toUpperCase(c)) != (lowerCasedChar = Character.toLowerCase(c))) {
                    if (CharPercentEscaper.isSafe(c)) {
                        builder.append('[').append(lowerCasedChar).append(upperCasedChar2).append(']');
                    } else {
                        void $receiver$iv;
                        builder.append('(').append(lowerCasedChar).append('|').append(upperCasedChar2).append('|');
                        String string = encodedUrl;
                        void v0 = $receiver$iv;
                        if (v0 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        CharPercentEscaper.escape(((String)v0).codePointAt((int)i), builder);
                        builder.append(')');
                    }
                } else if (!CharPercentEscaper.isSafe(c)) {
                    void $receiver$iv;
                    builder.append('(').append(c).append('|');
                    String upperCasedChar2 = encodedUrl;
                    void v1 = $receiver$iv;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    CharPercentEscaper.escape(((String)v1).codePointAt((int)i), builder);
                    builder.append(')');
                } else {
                    builder.append(c);
                }
                if (i == n2) break;
                ++i;
            }
        }
    }

    public static /* bridge */ /* synthetic */ void escapePath$default(boolean bl, boolean bl2, StringBuilder stringBuilder, String string, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: escapePath");
        }
        if ((n3 & 0x10) != 0) {
            n = 0;
        }
        if ((n3 & 0x20) != 0) {
            n2 = string.length();
        }
        JavaScriptLineBreakpointManagerKt.escapePath(bl, bl2, stringBuilder, string, n, n2);
    }

    public static final boolean match(@NotNull String regExp, @NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)regExp, (String)"regExp");
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        try {
            return Pattern.compile(regExp).matcher(input).find();
        }
        catch (PatternSyntaxException e) {
            JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
            return false;
        }
    }

    @NotNull
    public static final /* synthetic */ String access$createUrlRegExp(@NotNull Location location, boolean useCaseSensitiveUrl) {
        return JavaScriptLineBreakpointManagerKt.createUrlRegExp(location, useCaseSensitiveUrl);
    }
}

