/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.jetbrains.javascript.debugger.ExecutionStackImpl;
import com.jetbrains.javascript.debugger.JSRunningThreadExecutionStack;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.JavaScriptSuspendContext;
import com.jetbrains.javascript.debugger.JavaScriptSuspendContextKt;
import com.jetbrains.javascript.debugger.V8ValueMarkerProvider;
import com.jetbrains.javascript.debugger.ValueMarkersRefIds;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.JSExecutionStackSuspendContext;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendContextManager;
import org.jetbrains.debugger.SuspendContextManagerBase;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.WebWorker;
import org.jetbrains.debugger.WorkerManager;
import org.jetbrains.debugger.frame.CallFrameView;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00182\u0006\u0010\u0019\u001a\u00020\tJ+\u0010\u0017\u001a\u0015\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\t0\t0\u0018\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\tH\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u001f\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u0017\u0010\"\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010#H\u0016\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u00020&2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006'"}, d2={"Lcom/jetbrains/javascript/debugger/JavaScriptSuspendContext;", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "(Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "executionStacks", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "markersRefIds", "Lcom/jetbrains/javascript/debugger/ValueMarkersRefIds;", "getMarkersRefIds$JavaScriptDebugger", "()Lcom/jetbrains/javascript/debugger/ValueMarkersRefIds;", "addSuspendContext", "", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "evaluateExpression", "Lorg/jetbrains/concurrency/Promise;", "expression", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "getActiveExecutionStack", "getExecutionStack", "worker", "Lorg/jetbrains/debugger/WebWorker;", "getExecutionStacks", "", "()[Lcom/intellij/xdebugger/frame/XExecutionStack;", "hasPausedExecutionStack", "", "JavaScriptDebugger"})
public final class JavaScriptSuspendContext
extends XSuspendContext {
    @Nullable
    private final ValueMarkersRefIds markersRefIds;
    private final ConcurrentMap<String, XExecutionStack> executionStacks;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    @Nullable
    public final ValueMarkersRefIds getMarkersRefIds$JavaScriptDebugger() {
        return this.markersRefIds;
    }

    @Nullable
    public XExecutionStack getActiveExecutionStack() {
        SuspendContextManager suspendContextManager;
        Vm vm = this.debugProcess.getVm();
        Object object = suspendContextManager = vm != null ? vm.getSuspendContextManager() : null;
        if (suspendContextManager != null) {
            Object object2 = suspendContextManager.getContext();
            if (object2 == null || (object2 = object2.getWorkerId()) == null) {
                object2 = "";
            }
            Object key = object2;
            return (XExecutionStack)this.executionStacks.get(key);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public XExecutionStack[] getExecutionStacks() {
        Map activeWorkers;
        WorkerManager workerManager;
        XExecutionStack cachedStack;
        Object stack;
        Collection $receiver$iv;
        Vm vm = this.debugProcess.getVm();
        if (vm == null) {
            return super.getExecutionStacks();
        }
        Vm vm2 = vm;
        SuspendContextManager suspendContextManager = vm2.getSuspendContextManager();
        if (suspendContextManager instanceof SuspendContextManagerBase) {
            void $receiver$iv2;
            Map map = ((SuspendContextManagerBase)suspendContextManager).getThreadSuspendContexts();
            Iterator iterator = $receiver$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                void $receiver$iv3;
                Map.Entry entry;
                Map.Entry $i$f$iterator = entry = iterator.next();
                String workerId = (String)$receiver$iv.getKey();
                Map.Entry $i$f$component1 = entry;
                stack = (JSExecutionStackSuspendContext)$receiver$iv3.getValue();
                cachedStack = (XExecutionStack)this.executionStacks.get(workerId);
                if (!(cachedStack instanceof ExecutionStackImpl) || !(Intrinsics.areEqual(((ExecutionStackImpl)cachedStack).getSuspendContext(), (Object)stack.getSuspendContext()) ^ true)) continue;
                this.executionStacks.remove(workerId);
            }
        }
        Vm vm3 = this.debugProcess.getVm();
        WorkerManager workerManager2 = workerManager = vm3 != null ? vm3.getWorkerManager() : null;
        Map map = activeWorkers = workerManager2 != null ? workerManager2.getActiveWorkers() : null;
        if (activeWorkers != null && !activeWorkers.isEmpty()) {
            List list;
            void destination$iv$iv;
            void $receiver$iv$iv;
            ArrayList<XExecutionStack> stacks = new ArrayList<XExecutionStack>(1 + activeWorkers.size());
            stacks.add(this.getExecutionStack(null));
            stack = CollectionsKt.sorted((Iterable)activeWorkers.keySet());
            ArrayList<XExecutionStack> arrayList = stacks;
            cachedStack = $receiver$iv;
            Collection $i$f$component2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                list = destination$iv$iv;
                XExecutionStack xExecutionStack = this.getExecutionStack((WebWorker)activeWorkers.get(it));
                list.add(xExecutionStack);
            }
            list = (List)destination$iv$iv;
            arrayList.addAll(list);
            $receiver$iv = stacks;
            Collection thisCollection$iv = $receiver$iv;
            XExecutionStack[] xExecutionStackArray = thisCollection$iv.toArray(new XExecutionStack[thisCollection$iv.size()]);
            if (xExecutionStackArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return (XExecutionStack[])((Object[])xExecutionStackArray);
        }
        return super.getExecutionStacks();
    }

    /*
     * WARNING - void declaration
     */
    private final XExecutionStack getExecutionStack(WebWorker worker) {
        Object object = worker;
        if (object == null || (object = object.getId()) == null) {
            object = "";
        }
        XExecutionStack stack = (XExecutionStack)this.executionStacks.get(object);
        if (stack == null) {
            void value$iv;
            void key$iv;
            void $receiver$iv;
            stack = new JSRunningThreadExecutionStack(JavaScriptSuspendContextKt.getThreadName(worker));
            Map map = this.executionStacks;
            Object object2 = worker;
            if (object2 == null || (object2 = object2.getId()) == null) {
                object2 = "";
            }
            Object object3 = object2;
            XExecutionStack xExecutionStack = stack;
            $receiver$iv.put(key$iv, value$iv);
        }
        return stack;
    }

    public final void addSuspendContext(@NotNull SuspendContext<?> suspendContext, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo) {
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        ExecutionStackImpl stack = new ExecutionStackImpl(this, suspendContext, this.debugProcess.getDebuggerViewSupport(), topFrameScript, topFrameSourceInfo);
        String string = suspendContext.getWorkerId();
        if (string == null) {
            string = "";
        }
        this.executionStacks.put(string, stack);
    }

    public static /* bridge */ /* synthetic */ void addSuspendContext$default(JavaScriptSuspendContext javaScriptSuspendContext, SuspendContext suspendContext, Script script, SourceInfo sourceInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addSuspendContext");
        }
        if ((n & 4) != 0) {
            sourceInfo = null;
        }
        javaScriptSuspendContext.addSuspendContext(suspendContext, script, sourceInfo);
    }

    public final boolean hasPausedExecutionStack(@NotNull SuspendContext<?> suspendContext) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
            Iterable $receiver$iv = this.executionStacks.values();
            for (Object element$iv : $receiver$iv) {
                XExecutionStack it = (XExecutionStack)element$iv;
                if (!(it instanceof ExecutionStackImpl && Intrinsics.areEqual(((ExecutionStackImpl)it).getSuspendContext(), suspendContext))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Promise<String> evaluateExpression(@NotNull String expression) {
        XExecutionStack frame;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        XExecutionStack xExecutionStack = this.getActiveExecutionStack();
        if (xExecutionStack == null || (xExecutionStack = xExecutionStack.getTopFrame()) == null) {
            return PromiseKt.rejectedPromise((String)"Top frame is null");
        }
        XExecutionStack xExecutionStack2 = frame = xExecutionStack;
        if (xExecutionStack2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        }
        Promise<String> promise = this.evaluateExpression(((CallFrameView)xExecutionStack2).getCallFrame().getEvaluateContext(), expression);
        Intrinsics.checkExpressionValueIsNotNull(promise, (String)"evaluateExpression((fram\u2026luateContext, expression)");
        return promise;
    }

    private final Promise<String> evaluateExpression(EvaluateContext evaluateContext, String expression) {
        return EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext, (String)expression, null, (boolean)false, (int)6, null).thenAsync((AsyncFunction)evaluateExpression.1.INSTANCE);
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public JavaScriptSuspendContext(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        V8ValueMarkerProvider v8ValueMarkerProvider = this.debugProcess.getValueMarkerProvider();
        this.markersRefIds = v8ValueMarkerProvider != null ? v8ValueMarkerProvider.computeRefIds$JavaScriptDebugger() : null;
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        this.executionStacks = concurrentMap;
    }
}

