/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.WebWorker;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0007\u001a\u00020\u00012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\u0010\u0010\u0007\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"MAIN_LOOP_NAME", "", "getMAIN_LOOP_NAME", "()Ljava/lang/String;", "NAME_ATTRIBUTES", "Lcom/intellij/ui/SimpleTextAttributes;", "PREFIX_ATTRIBUTES", "getThreadName", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/debugger/CallFrame;", "vm", "Lorg/jetbrains/debugger/Vm;", "worker", "Lorg/jetbrains/debugger/WebWorker;", "JavaScriptDebugger"})
public final class JavaScriptSuspendContextKt {
    @NotNull
    private static final String MAIN_LOOP_NAME = "main loop";
    private static final SimpleTextAttributes PREFIX_ATTRIBUTES;
    private static final SimpleTextAttributes NAME_ATTRIBUTES;

    @NotNull
    public static final String getMAIN_LOOP_NAME() {
        return MAIN_LOOP_NAME;
    }

    @NotNull
    public static final String getThreadName(@NotNull SuspendContext<? extends CallFrame> suspendContext, @Nullable Vm vm) {
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        String workerId = suspendContext.getWorkerId();
        if (workerId != null) {
            Object object = vm;
            WebWorker worker = object != null && (object = object.getWorkerManager()) != null && (object = object.getActiveWorkers()) != null ? (WebWorker)object.get(workerId) : null;
            return JavaScriptSuspendContextKt.getThreadName(worker);
        }
        Vm vm2 = vm;
        Object workerManager = vm2 != null ? vm2.getWorkerManager() : null;
        Object object = workerManager;
        if (object != null && (object = object.getActiveWorkers()) != null ? object.isEmpty() : true) {
            return "";
        }
        return JavaScriptSuspendContextKt.getThreadName(null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getThreadName(@Nullable WebWorker worker) {
        String string;
        if (worker == null) {
            string = MAIN_LOOP_NAME;
        } else {
            void endIndex$iv;
            void $receiver$iv;
            String url = worker.getUrl();
            int slashIndex = StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)0, (boolean)false, (int)6, null) + 1;
            int questionIndex = StringsKt.indexOf$default((CharSequence)url, (char)'?', (int)slashIndex, (boolean)false, (int)4, null);
            String string2 = url;
            int n = questionIndex > slashIndex ? questionIndex : url.length();
            void v1 = $receiver$iv;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)v1).substring(slashIndex, (int)endIndex$iv);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String scriptName = string3;
            string = "worker: " + scriptName + " (" + StringUtil.trimStart((String)worker.getId(), (String)"dedicated:") + ")";
        }
        return string;
    }

    static {
        MAIN_LOOP_NAME = MAIN_LOOP_NAME;
        PREFIX_ATTRIBUTES = new SimpleTextAttributes(2, UIUtil.getInactiveTextColor());
        NAME_ATTRIBUTES = new SimpleTextAttributes(2 | 1, UIUtil.getInactiveTextColor());
    }

    @NotNull
    public static final /* synthetic */ SimpleTextAttributes access$getPREFIX_ATTRIBUTES$p() {
        return PREFIX_ATTRIBUTES;
    }

    @NotNull
    public static final /* synthetic */ SimpleTextAttributes access$getNAME_ATTRIBUTES$p() {
        return NAME_ATTRIBUTES;
    }
}

