/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.editor.ex.util.SegmentArray;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SegmentList
extends SegmentArray {
    public void add(int startOffset, int endOffset) {
        this.setElementAt(this.mySegmentCount, startOffset, endOffset);
    }

    public void clear() {
        this.removeAll();
    }

    public int getRangeIndex(int offset) {
        return this.mySegmentCount <= 0 ? -1 : this.findSegmentIndex(offset);
    }

    public boolean rangeContains(int index, int offset) {
        return offset < this.myEnds[index];
    }

    protected int segmentNotFound(int offset, int start2) {
        return -1;
    }

    protected int noSegmentsAvailable(int offset) {
        return -1;
    }

    protected int offsetOutOfRange(int offset, int lastValidOffset) {
        return -1;
    }

    public static class SegmentListWithData<T>
    extends SegmentList {
        private final List<T> data = new ArrayList<T>();

        public void add(T value, int startOffset, int endOffset) {
            this.data.add(value);
            this.setElementAt(this.mySegmentCount, startOffset, endOffset);
        }

        public TextRange createRange(int index) {
            return new TextRange(this.myStarts[index], this.myEnds[index]);
        }

        @Nullable
        public T getValueByOffset(int offset) {
            int index = this.getRangeIndex(offset);
            return index == -1 ? null : (T)this.getValueByIndex(index);
        }

        public T getValueByIndex(int index) {
            return this.data.get(index);
        }

        @Override
        public void clear() {
            super.clear();
            this.data.clear();
        }
    }
}

