/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.execution;

import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.AsyncGenericProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.actions.OpenFileInDefaultBrowserAction;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.javascript.debugger.execution.JSDebugConfigUsagesCollector;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSettingsEditor;
import com.intellij.javascript.debugger.execution.JsRunners;
import com.intellij.javascript.debugger.execution.RemoteDebuggingFileFinder;
import com.intellij.javascript.debugger.execution.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.javascript.debugger.impl.DebuggableFileFinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.DebuggableFileFinderImpl;
import com.jetbrains.javascript.debugger.JavaScriptDebugEngine;
import com.jetbrains.javascript.debugger.JavaScriptDebugEngineKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/javascript/debugger/execution/JavaScriptDebugRunner;", "Lcom/intellij/execution/runners/AsyncGenericProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "findEngineAndBrowser", "Lcom/intellij/openapi/util/Pair;", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugEngine;", "Lcom/intellij/ide/browsers/WebBrowser;", "browserIdOrNameOrEngineId", "isRun", "getRunnerId", "prepare", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/RunProfileStarter;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "startSession", "Lcom/intellij/execution/ui/RunContentDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "engineAndBrowser", "JavaScriptDebugger"})
public final class JavaScriptDebugRunner
extends AsyncGenericProgramRunner<RunnerSettings> {
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)profile, (String)"profile");
        return profile instanceof JavaScriptDebugConfiguration && (Intrinsics.areEqual((Object)executorId, (Object)DefaultDebugExecutor.EXECUTOR_ID) || Intrinsics.areEqual((Object)executorId, (Object)DefaultRunExecutor.EXECUTOR_ID));
    }

    @NotNull
    public String getRunnerId() {
        return "JavascriptDebugRunner";
    }

    private final Pair<JavaScriptDebugEngine, WebBrowser> findEngineAndBrowser(String browserIdOrNameOrEngineId, boolean isRun) {
        WebBrowser webBrowser;
        JavaScriptDebugEngine debugEngine;
        Pair<JavaScriptDebugEngine, WebBrowser> info;
        Pair<JavaScriptDebugEngine, WebBrowser> pair = info = browserIdOrNameOrEngineId == null ? (Pair<JavaScriptDebugEngine, WebBrowser>)null : JavaScriptDebugEngine.Companion.findByBrowserIdOrName(browserIdOrNameOrEngineId);
        if (info != null) {
            return info;
        }
        JavaScriptDebugEngine javaScriptDebugEngine = debugEngine = browserIdOrNameOrEngineId == null ? (JavaScriptDebugEngine)null : JavaScriptDebugEngineKt.findByBrowserIdOrNameOrEngineId(browserIdOrNameOrEngineId);
        if (debugEngine == null) {
            if (isRun) {
                Pair pair2 = Pair.create(null, (Object)OpenFileInDefaultBrowserAction.findUsingBrowser());
                Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"Pair.create<JavaScriptDe\u2026ction.findUsingBrowser())");
                return pair2;
            }
            WebBrowser defaultBrowser = (WebBrowser)ContainerUtil.getFirstItem((List)WebBrowserManager.getInstance().getBrowsers(JavaScriptDebugSettingsEditor.BROWSER_CONDITION));
            if (defaultBrowser != null) {
                debugEngine = JavaScriptDebugEngine.Companion.findByBrowser(defaultBrowser);
                Pair pair3 = Pair.create((Object)debugEngine, (Object)defaultBrowser);
                Intrinsics.checkExpressionValueIsNotNull((Object)pair3, (String)"Pair.create<JavaScriptDe\u2026ugEngine, defaultBrowser)");
                return pair3;
            }
            debugEngine = (JavaScriptDebugEngine)ArraysKt.first((Object[])JavaScriptDebugEngineKt.getEngines());
        }
        if ((webBrowser = debugEngine.getBrowser()) == null) {
            WebBrowser webBrowser2 = WebBrowserManager.getInstance().getFirstBrowser(debugEngine.getBrowserFamily());
            webBrowser = webBrowser2;
            Intrinsics.checkExpressionValueIsNotNull((Object)webBrowser2, (String)"WebBrowserManager.getIns\u2026ebugEngine.browserFamily)");
        }
        WebBrowser notNullBrowser = webBrowser;
        Pair pair4 = Pair.create((Object)debugEngine, (Object)notNullBrowser);
        Intrinsics.checkExpressionValueIsNotNull((Object)pair4, (String)"Pair.create<JavaScriptDe\u2026ugEngine, notNullBrowser)");
        return pair4;
    }

    @NotNull
    protected Promise<RunProfileStarter> prepare(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        }
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        UsageTrigger.trigger((String)("JSDebugConfig." + environment.getExecutor().getId() + "." + JSDebugConfigUsagesCollector.getStatisticsKey(environment.getProject(), configuration)));
        boolean isRun = Intrinsics.areEqual((Object)DefaultRunExecutor.EXECUTOR_ID, (Object)environment.getExecutor().getId());
        Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser = this.findEngineAndBrowser(configuration.getEngineId(), isRun);
        if (isRun) {
            BrowserLauncher browserLauncher = BrowserLauncher.getInstance();
            String string = configuration.getUri();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            browserLauncher.browse(string, (WebBrowser)engineAndBrowser.second, environment.getProject());
            Promise promise = Promise.resolve(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)promise, (String)"Promise.resolve<RunProfileStarter>(null)");
            return promise;
        }
        Project project = environment.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
        return JsRunners.INSTANCE.start(project, engineAndBrowser, new JsRunners.Starter(this, environment, engineAndBrowser){
            final /* synthetic */ JavaScriptDebugRunner this$0;
            final /* synthetic */ ExecutionEnvironment $environment;
            final /* synthetic */ Pair $engineAndBrowser;

            @NotNull
            public RunContentDescriptor start() {
                Project project = this.$environment.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"environment.project");
                return JavaScriptDebugRunner.access$startSession(this.this$0, project, this.$environment, this.$engineAndBrowser);
            }
            {
                this.this$0 = $outer;
                this.$environment = $captured_local_variable$1;
                this.$engineAndBrowser = $captured_local_variable$2;
            }
        });
    }

    private final RunContentDescriptor startSession(Project project, ExecutionEnvironment environment, Pair<JavaScriptDebugEngine, WebBrowser> engineAndBrowser) {
        DebuggableFileFinder fileFinder;
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration");
        }
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runProfile;
        String string = configuration.getUri();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Url url = Urls.newFromIdea((CharSequence)string);
        DebuggableFileFinderImpl defaultFileFinder = new DebuggableFileFinderImpl(project, url);
        if (url.isInLocalFileSystem()) {
            fileFinder = defaultFileFinder;
        } else {
            List<RemoteUrlMappingBean> list = configuration.getMappings();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"configuration.mappings");
            fileFinder = new RemoteDebuggingFileFinder(RemoteDebuggingFileFinderKt.createUrlToLocalMap(list), defaultFileFinder);
        }
        ExecutionEnvironment executionEnvironment = environment;
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)environment.getProject());
        XDebugProcessStarter xDebugProcessStarter2 = new XDebugProcessStarter(engineAndBrowser, fileFinder, url){
            final /* synthetic */ Pair $engineAndBrowser$inlined;
            final /* synthetic */ DebuggableFileFinder $fileFinder$inlined;
            final /* synthetic */ Url $url$inlined;

            public XDebugProcess start(XDebugSession session) {
                XDebugSession it = session;
                JavaScriptDebugEngine javaScriptDebugEngine = (JavaScriptDebugEngine)this.$engineAndBrowser$inlined.first;
                WebBrowser webBrowser = (WebBrowser)this.$engineAndBrowser$inlined.second;
                Intrinsics.checkExpressionValueIsNotNull((Object)webBrowser, (String)"engineAndBrowser.second");
                return (XDebugProcess)javaScriptDebugEngine.createDebugProcess(it, webBrowser, this.$fileFinder$inlined, this.$url$inlined, null, true);
            }
            {
                this.$engineAndBrowser$inlined = pair;
                this.$fileFinder$inlined = debuggableFileFinder;
                this.$url$inlined = url;
            }
        };
        XDebugSession xDebugSession = xDebuggerManager.startSession(executionEnvironment, xDebugProcessStarter2);
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"XDebuggerManager.getInst\u2026gProcessStarter(starter))");
        RunContentDescriptor runContentDescriptor = xDebugSession.getRunContentDescriptor();
        Intrinsics.checkExpressionValueIsNotNull((Object)runContentDescriptor, (String)"startSession(environment\u2026) }).runContentDescriptor");
        return runContentDescriptor;
    }

    @NotNull
    public static final /* synthetic */ RunContentDescriptor access$startSession(JavaScriptDebugRunner $this, @NotNull Project project, @NotNull ExecutionEnvironment environment, @NotNull Pair engineAndBrowser) {
        return $this.startSession(project, environment, (Pair<JavaScriptDebugEngine, WebBrowser>)engineAndBrowser);
    }
}

