/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.icons.AllIcons;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.scripts.Scripts;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

public class FileInfo {
    private final String name;
    protected Icon icon;
    private final List<Script> scripts;
    private final Url fileUrl;

    FileInfo(@NotNull String name, @NotNull Url fileUrl, @NotNull List<Script> scripts) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/javascript/debugger/scripts/FileInfo", "<init>"));
        }
        if (fileUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileUrl", "com/jetbrains/javascript/debugger/scripts/FileInfo", "<init>"));
        }
        if (scripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scripts", "com/jetbrains/javascript/debugger/scripts/FileInfo", "<init>"));
        }
        this.name = name;
        this.scripts = scripts;
        this.fileUrl = fileUrl;
    }

    void addScript(@NotNull Script script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/scripts/FileInfo", "addScript"));
        }
        for (Script existingScript : this.scripts) {
            if (!existingScript.getUrl().equals(script.getUrl())) continue;
            return;
        }
        this.scripts.add(script);
    }

    public int getWeight() {
        return 10;
    }

    @NotNull
    public Url getUrl() {
        Url url = this.fileUrl;
        if (url == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/FileInfo", "getUrl"));
        }
        return url;
    }

    @NotNull
    public List<Script> getScripts() {
        List<Script> list = this.scripts;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/FileInfo", "getScripts"));
        }
        return list;
    }

    @NotNull
    public Script getFirstScript() {
        Script script = this.scripts.get(0);
        if (script == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/FileInfo", "getFirstScript"));
        }
        return script;
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/FileInfo", "getName"));
        }
        return string;
    }

    public boolean hasChildren() {
        return false;
    }

    List<FileInfo> getChildren() {
        return Collections.emptyList();
    }

    @Nullable
    public FileInfo getSingleChild() {
        return null;
    }

    public boolean isFile() {
        return true;
    }

    @NotNull
    public Icon getIcon() {
        if (this.icon == null) {
            this.icon = Scripts.getFileType(this.fileUrl).getIcon();
        }
        Icon icon = this.icon == null ? AllIcons.FileTypes.JavaScript : this.icon;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/FileInfo", "getIcon"));
        }
        return icon;
    }
}

