/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.RemoteDebuggingFileFinder;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.content.Content;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.RunnerContentProvider;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import com.jetbrains.javascript.debugger.scripts.RootScriptsNode;
import com.jetbrains.javascript.debugger.scripts.SourceTabManager;
import com.jetbrains.javascript.debugger.scripts.SourcesTreeComponentKt;
import com.jetbrains.javascript.debugger.scripts.actions.OpenActualScriptSourceAction;
import com.jetbrains.javascript.debugger.scripts.actions.OpenScriptSourceAction;
import com.jetbrains.javascript.debugger.scripts.actions.SetLocalPathForScriptAction;
import com.jetbrains.javascript.debugger.scripts.actions.VisualizeScriptSourcemap;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.VmConnection;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u0015\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/javascript/debugger/scripts/SourcesTreeComponent;", "", "sourceTabManager", "Lcom/jetbrains/javascript/debugger/scripts/SourceTabManager;", "(Lcom/jetbrains/javascript/debugger/scripts/SourceTabManager;)V", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "getDebugProcess", "()Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "mainComponent", "Ljavax/swing/JScrollPane;", "kotlin.jvm.PlatformType", "getMainComponent", "()Ljavax/swing/JScrollPane;", "selectedNode", "Lcom/jetbrains/javascript/debugger/scripts/FileNode;", "getSelectedNode", "()Lcom/jetbrains/javascript/debugger/scripts/FileNode;", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "treeBuilder", "Lcom/intellij/ui/treeStructure/SimpleTreeBuilder;", "createPopupGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "SourcesRunnerContentProvider", "SourcesTreeStructure", "JavaScriptDebugger"})
public final class SourcesTreeComponent {
    private final SimpleTree tree;
    private final SimpleTreeBuilder treeBuilder;
    private final JScrollPane mainComponent;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;

    public final JScrollPane getMainComponent() {
        return this.mainComponent;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    private final DefaultActionGroup createPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new OpenScriptSourceAction(this));
        WebBrowser browser = this.debugProcess.getConnection().getBrowser();
        if (browser == null || browser.getFamily() == BrowserFamily.CHROME) {
            group.add((AnAction)new OpenActualScriptSourceAction(this));
            group.add((AnAction)new VisualizeScriptSourcemap(this));
        }
        return group;
    }

    @Nullable
    public final FileNode getSelectedNode() {
        SimpleNode simpleNode = this.tree.getSelectedNode();
        if (!(simpleNode instanceof FileNode)) {
            simpleNode = null;
        }
        return (FileNode)simpleNode;
    }

    public SourcesTreeComponent(@NotNull SourceTabManager sourceTabManager) {
        DefaultActionGroup dirGroup;
        Intrinsics.checkParameterIsNotNull((Object)sourceTabManager, (String)"sourceTabManager");
        this.tree = new SimpleTree();
        this.mainComponent = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree));
        this.debugProcess = sourceTabManager.getDebugProcess();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.treeBuilder = new SimpleTreeBuilder((JTree)this.tree, this.tree.getBuilderModel(), (AbstractTreeStructure)new SourcesTreeStructure(sourceTabManager), (Comparator)new WeightBasedComparator(true));
        this.treeBuilder.initRootNode();
        sourceTabManager.addListener(new Runnable(){

            @Override
            public void run() {
                treeBuilder.updateFromRoot(true);
            }
        });
        SetLocalPathForScriptAction setLocalPathForScriptAction = this.debugProcess.getSession().getRunProfile() instanceof JavaScriptDebugConfiguration && this.debugProcess.getFinder() instanceof RemoteDebuggingFileFinder ? new SetLocalPathForScriptAction(this) : (SetLocalPathForScriptAction)null;
        final DefaultActionGroup fileGroup = this.createPopupGroup();
        if (setLocalPathForScriptAction != null) {
            dirGroup = new DefaultActionGroup();
            dirGroup.add((AnAction)setLocalPathForScriptAction);
            fileGroup.add((AnAction)setLocalPathForScriptAction);
        } else {
            dirGroup = null;
        }
        this.tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(@NotNull Component comp, int x, int y) {
                Intrinsics.checkParameterIsNotNull((Object)comp, (String)"comp");
                FileNode selectedNode = this.getSelectedNode();
                if (selectedNode != null) {
                    DefaultActionGroup group;
                    DefaultActionGroup defaultActionGroup = group = selectedNode.getFileInfo().isFile() ? fileGroup : dirGroup;
                    if (group != null) {
                        ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group).getComponent().show(comp, x, y);
                    }
                }
            }
        });
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/javascript/debugger/scripts/SourcesTreeComponent$SourcesRunnerContentProvider;", "Lcom/jetbrains/javascript/debugger/RunnerContentProvider;", "()V", "registerContent", "", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "Lorg/jetbrains/debugger/connection/VmConnection;", "Lorg/jetbrains/debugger/Vm;", "tabIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "JavaScriptDebugger"})
    public static final class SourcesRunnerContentProvider
    implements RunnerContentProvider {
        public void registerContent(@NotNull RunnerLayoutUi ui, @NotNull JavaScriptDebugProcess<? extends VmConnection<Vm>> debugProcess, @NotNull AtomicInteger tabIdCounter) {
            Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
            Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)tabIdCounter, (String)"tabIdCounter");
            SourcesTreeComponent treeComponent = new SourcesTreeComponent(debugProcess.getSourceTabManager$JavaScriptDebugger());
            Content content = ui.createContent(SourcesTreeComponentKt.access$getCONTENT_ID$p(), (JComponent)treeComponent.getMainComponent(), "Scripts", JavaScriptFileType.INSTANCE.getIcon(), (JComponent)treeComponent.getMainComponent());
            content.setCloseable(false);
            Disposer.register((Disposable)((Disposable)content), (Disposable)((Disposable)treeComponent.treeBuilder));
            ui.addContent(content, tabIdCounter.incrementAndGet(), PlaceInGrid.bottom, false);
        }
    }

    @Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/javascript/debugger/scripts/SourcesTreeComponent$SourcesTreeStructure;", "Lcom/intellij/ui/treeStructure/SimpleTreeStructure;", "sourceTabManager", "Lcom/jetbrains/javascript/debugger/scripts/SourceTabManager;", "(Lcom/jetbrains/javascript/debugger/scripts/SourceTabManager;)V", "rootNode", "Lcom/jetbrains/javascript/debugger/scripts/RootScriptsNode;", "getRootElement", "", "JavaScriptDebugger"})
    private static final class SourcesTreeStructure
    extends SimpleTreeStructure {
        private RootScriptsNode rootNode;
        private final SourceTabManager sourceTabManager;

        @NotNull
        public Object getRootElement() {
            if (this.rootNode == null) {
                this.rootNode = new RootScriptsNode(this.sourceTabManager.getDebugProcess(), this.sourceTabManager.getRoot(), null);
            }
            RootScriptsNode rootScriptsNode = this.rootNode;
            if (rootScriptsNode == null) {
                Intrinsics.throwNpe();
            }
            return rootScriptsNode;
        }

        public SourcesTreeStructure(@NotNull SourceTabManager sourceTabManager) {
            Intrinsics.checkParameterIsNotNull((Object)sourceTabManager, (String)"sourceTabManager");
            this.sourceTabManager = sourceTabManager;
        }
    }
}

