/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.javascript.debugger.scripts.ConsumerOnEdt;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import com.jetbrains.javascript.debugger.scripts.SourcesTreeComponent;
import com.jetbrains.javascript.debugger.scripts.actions.ScriptTreeActionBase;
import org.jetbrains.annotations.NotNull;

public class OpenActualScriptSourceAction
extends ScriptTreeActionBase {
    public OpenActualScriptSourceAction(SourcesTreeComponent treeComponent) {
        super(treeComponent, "Open Actual Source");
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/javascript/debugger/scripts/actions/OpenActualScriptSourceAction", "isApplicable"));
        }
        return info.getScripts().size() == 1 && info.getUrl().equals(info.getFirstScript().getUrl()) && this.treeComponent.getDebugProcess().getConnection().getState().getStatus() == ConnectionStatus.CONNECTED;
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/javascript/debugger/scripts/actions/OpenActualScriptSourceAction", "perform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/javascript/debugger/scripts/actions/OpenActualScriptSourceAction", "perform"));
        }
        this.treeComponent.getDebugProcess().getDebuggerViewSupport().getFileByUrlOrVmSource(node.getFileInfo().getFirstScript(), false).done((Consumer)new ConsumerOnEdt<VirtualFile>(this.getProject()){

            @Override
            public void consume(@NotNull Project project, VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/scripts/actions/OpenActualScriptSourceAction$1", "consume"));
                }
                FileEditorManager.getInstance((Project)project).openFile(file, true);
            }
        });
    }
}

