/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import com.jetbrains.javascript.debugger.scripts.SourcesTreeComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ScriptTreeActionBase
extends AnAction {
    protected final SourcesTreeComponent treeComponent;

    protected ScriptTreeActionBase(@NotNull SourcesTreeComponent treeComponent, @Nullable String text) {
        if (treeComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeComponent", "com/jetbrains/javascript/debugger/scripts/actions/ScriptTreeActionBase", "<init>"));
        }
        super(text);
        this.treeComponent = treeComponent;
    }

    protected boolean isOnlyFile() {
        return true;
    }

    public final void update(AnActionEvent e) {
        FileNode node = this.treeComponent.getSelectedNode();
        boolean applicable = node != null && (!this.isOnlyFile() || node.getFileInfo().isFile()) && this.isApplicable(node.getFileInfo());
        e.getPresentation().setEnabled(applicable);
        if (this.invisibleIfDisabled()) {
            e.getPresentation().setVisible(applicable);
        }
    }

    protected boolean isApplicable(@NotNull FileInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/javascript/debugger/scripts/actions/ScriptTreeActionBase", "isApplicable"));
        }
        return true;
    }

    protected boolean invisibleIfDisabled() {
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        FileNode node = this.treeComponent.getSelectedNode();
        if (node != null) {
            this.perform(node, e.getDataContext());
        }
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.treeComponent.getDebugProcess().getSession().getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/actions/ScriptTreeActionBase", "getProject"));
        }
        return project;
    }

    protected abstract void perform(@NotNull FileNode var1, @NotNull DataContext var2);
}

