/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.scripts.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.javascript.debugger.scripts.ConsumerOnEdt;
import com.jetbrains.javascript.debugger.scripts.FileInfo;
import com.jetbrains.javascript.debugger.scripts.FileNode;
import com.jetbrains.javascript.debugger.scripts.Scripts;
import com.jetbrains.javascript.debugger.scripts.SourcesTreeComponent;
import com.jetbrains.javascript.debugger.scripts.actions.ScriptTreeActionBase;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.VisualizeSourceMapAction;
import java.util.Collection;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;

public class VisualizeScriptSourcemap
extends ScriptTreeActionBase {
    public VisualizeScriptSourcemap(@NotNull SourcesTreeComponent treeComponent) {
        if (treeComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeComponent", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "<init>"));
        }
        super(treeComponent, "Visualize Source Map");
    }

    @Override
    protected boolean invisibleIfDisabled() {
        return false;
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "isApplicable"));
        }
        for (Script script : info.getScripts()) {
            if (script.getSourceMap() == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Promise<Script> chooseScript(@NotNull Collection<Script> items, @NotNull DataContext dataContext) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "chooseScript"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "chooseScript"));
        }
        if (items.size() == 1) {
            Promise promise = Promise.resolve((Object)ContainerUtil.getFirstItem(items));
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "chooseScript"));
            }
            return promise;
        }
        final JBList list = new JBList(items);
        list.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setIcon(Scripts.getFileType(((Script)value).getUrl()).getIcon());
                this.append(((Script)value).getUrl().toDecodedForm());
            }
        });
        final AsyncPromise result = new AsyncPromise();
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Script").setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                Script value = (Script)list.getSelectedValue();
                if (value == null) {
                    result.setError("selected value is null");
                } else {
                    result.setResult((Object)value);
                }
            }
        }).createPopup().showInBestPositionFor(dataContext);
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "chooseScript"));
        }
        return asyncPromise;
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext dataContext) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "perform"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "perform"));
        }
        final Url sourceUrl = node.getFileInfo().getUrl();
        VisualizeScriptSourcemap.chooseScript(node.getFileInfo().getScripts(), dataContext).done((Consumer)new Consumer<Script>(){

            public void consume(Script script) {
                VisualizeScriptSourcemap.this.visualize(script, sourceUrl);
            }
        });
    }

    private void visualize(final @NotNull Script script, final @NotNull Url sourceUrl) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "visualize"));
        }
        if (sourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrl", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap", "visualize"));
        }
        final SourceMap map = script.getSourceMap();
        if (map == null) {
            return;
        }
        final SourceMapInspector.SourceFileFinder sourceFileFinder = new SourceMapInspector.SourceFileFinder(){

            @Override
            @Nullable
            public VirtualFile find(@NotNull Url source) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap$4", "find"));
                }
                VirtualFile file = SourceMapInspector.createSourceFromProvidedContent(map, source, (UserDataHolder)script);
                if (file == null) {
                    file = SourceMapInspector.getSourceFile(source);
                }
                return file == null ? VisualizeScriptSourcemap.this.treeComponent.getDebugProcess().findFileOrAny(source) : file;
            }
        };
        this.treeComponent.getDebugProcess().getDebuggerViewSupport().getFileByUrlOrVmSource(script, true).done((Consumer)new ConsumerOnEdt<VirtualFile>(this.getProject()){

            @Override
            public void consume(@NotNull Project project, VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/scripts/actions/VisualizeScriptSourcemap$5", "consume"));
                }
                VisualizeSourceMapAction.visualize(map, file, sourceUrl, project, sourceFileFinder);
            }
        });
    }
}

