/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap;

import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Base64;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.javascript.debugger.JavaScriptDebugProcess;
import com.jetbrains.javascript.debugger.sourcemap.SourceMapLoaderKt;
import io.netty.util.CharsetUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Request;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asar.AsarFileSystem;
import org.jetbrains.asar.DirectoryItem;
import org.jetbrains.asar.FileItem;
import org.jetbrains.asar.Item;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolverKt;
import org.jetbrains.io.UtilKt;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000v\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0000\u001a&\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a&\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0000\u001a\u001c\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001d\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u001e\u001a\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010\u00012\u0006\u0010#\u001a\u00020\u0001H\u0000\u001a&\u0010$\u001a\u0004\u0018\u00010\f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\"\u0010$\u001a\u0004\u0018\u00010 2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010(\u001a\u0012\u0010)\u001a\u0004\u0018\u00010 2\u0006\u0010\u0019\u001a\u00020\bH\u0002\u001a\u0012\u0010*\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a$\u0010+\u001a\u0004\u0018\u00010 2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\b\b\u0002\u00100\u001a\u00020/H\u0002\u001a\u0010\u0010+\u001a\u0004\u0018\u00010 2\u0006\u0010\u001c\u001a\u00020\u001e\u001a\"\u00101\u001a\u0004\u0018\u00010\f*\u00020\u001e2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0014\u00102\u001a\u0004\u0018\u00010\u0001*\u0002032\u0006\u0010\r\u001a\u00020\u0001\u001a\n\u00104\u001a\u00020 *\u00020\u001d\u001a\n\u00104\u001a\u00020 *\u000205\u001a\n\u00104\u001a\u00020 *\u00020\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"ASAR", "", "REFERENCE_LINE", "REFERENCE_PATTERN_FILE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "REFERENCE_PATTERN_LINE", "canonicalizeUrl", "Lcom/intellij/util/Url;", "url", "baseUrl", "decodeLocalSourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "path", "script", "Lorg/jetbrains/debugger/Script;", "debugProcess", "Lcom/jetbrains/javascript/debugger/JavaScriptDebugProcess;", "decodeString", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "charBuffer", "Ljava/nio/CharBuffer;", "findSourceMap", "parsedUrl", "findSourceMapLocally", "getSourceMapUrl", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/nio/file/Path;", "string", "", "pattern", "getStringFromDataUri", "dataUrl", "loadFromDataUri", "sourceMapUrl", "baseFileUrl", "session", "Lcom/intellij/xdebugger/XDebugSession;", "loadRemoteSourceMapData", "regularFile", "tail", "channel", "Ljava/nio/channels/SeekableByteChannel;", "size", "", "offset", "decodeSourceMap", "getSourceMapUrlFromAsar", "Lorg/jetbrains/asar/AsarFileSystem;", "loadFile", "Ljava/io/File;", "JavaScriptDebugger"})
public final class SourceMapLoaderKt {
    @NotNull
    public static final String ASAR = ".asar/";
    private static final String REFERENCE_LINE = "//(?:@|#)[ \\t]sourceMappingURL=[ \\t]*(?:file://)?([^\\r\\n]*)\\s*(?:\\*/\\s*)?$";
    private static final Pattern REFERENCE_PATTERN_FILE;
    private static final Pattern REFERENCE_PATTERN_LINE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final String getSourceMapUrlFromAsar(AsarFileSystem $receiver, @NotNull String path) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        FileItem fileItem = $receiver.getFile(path);
        if (fileItem != null) {
            Object it;
            void $receiver$iv;
            FileItem $receiver$iv2 = fileItem;
            FileItem fileItem2 = $receiver$iv2;
            Closeable closeable = $receiver.openFileChannel();
            boolean closed$iv = false;
            try {
                it = (SeekableByteChannel)$receiver$iv;
                SeekableByteChannel seekableByteChannel = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)seekableByteChannel, (String)"it");
                CharSequence charSequence = SourceMapLoaderKt.tail(seekableByteChannel, fileItem2.getSize(), fileItem2.getOffset());
                Pattern pattern = REFERENCE_PATTERN_LINE;
                Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
                it = SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
            }
            catch (Exception e$iv) {
                closed$iv = true;
                try {
                    $receiver$iv.close();
                }
                catch (Exception closeException$iv) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            finally {
                if (!closed$iv) {
                    $receiver$iv.close();
                }
            }
            string = (String)it;
        } else {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SourceMap findSourceMapLocally(@NotNull Script script, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        String scriptPath = script.getUrl().getPath();
        if (!FileUtil.isAbsolutePlatformIndependent((String)scriptPath)) {
            return null;
        }
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)ASAR, (int)0, (boolean)false, (int)6, null);
        if (index > 0) {
            Void void_;
            void endIndex$iv2;
            void startIndex$iv;
            AsarFileSystem $receiver$iv2;
            String string = scriptPath;
            boolean bl = false;
            int n = index + (ASAR.length() - 1);
            JavaScriptDebugProcess<?> javaScriptDebugProcess = debugProcess;
            void v0 = $receiver$iv2;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)v0).substring((int)startIndex$iv, (int)endIndex$iv2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string3 = string2;
            AsarFileSystem asarFileSystem = javaScriptDebugProcess.getAsarFs$JavaScriptDebugger(string3);
            if (asarFileSystem != null) {
                void startIndex$iv2;
                String $receiver$iv3;
                $receiver$iv2 = asarFileSystem;
                AsarFileSystem fs = $receiver$iv2;
                String endIndex$iv2 = scriptPath;
                int $i$f$substring = index + ASAR.length();
                void v3 = $receiver$iv3;
                if (v3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = ((String)v3).substring((int)startIndex$iv2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                String scriptRelativePath = string4;
                String string5 = SourceMapLoaderKt.getSourceMapUrlFromAsar(fs, scriptRelativePath);
                if (string5 != null) {
                    SourceMap sourceMap;
                    FileItem $receiver$iv4;
                    $receiver$iv3 = string5;
                    String url = $receiver$iv3;
                    CharSequence $i$f$substring2 = url;
                    if ($receiver$iv4.length() == 0) {
                        return null;
                    }
                    if (URLUtil.isDataUri((String)url)) {
                        return SourceMapLoaderKt.loadFromDataUri(debugProcess, script, url);
                    }
                    if (FileUtil.isAbsolutePlatformIndependent((String)url)) {
                        return SourceMapLoaderKt.decodeLocalSourceMap(url, script, debugProcess);
                    }
                    String string6 = PathUtilRt.getParentPath((String)scriptRelativePath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"PathUtilRt.getParentPath(scriptRelativePath)");
                    DirectoryItem directoryItem = fs.getDir(string6);
                    Item item = directoryItem != null ? directoryItem.findChild(url) : null;
                    if (!(item instanceof FileItem)) {
                        item = null;
                    }
                    FileItem fileItem = (FileItem)item;
                    if (fileItem != null) {
                        void $receiver$iv5;
                        $receiver$iv4 = fileItem;
                        FileItem it = $receiver$iv4;
                        CharSequence charSequence = fs.loadText(it);
                        CharSequence it2 = (CharSequence)$receiver$iv5;
                        sourceMap = JavaScriptDebugProcess.decodeSourceMap$default(debugProcess, it2, script.getUrl(), true, script, false, 16, null);
                    } else {
                        sourceMap = null;
                    }
                    return sourceMap;
                }
                void_ = null;
            } else {
                void_ = null;
            }
        }
        String string = scriptPath;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"scriptPath");
        Path path = SourceMapLoaderKt.regularFile(string);
        if (path == null) {
            String string7 = scriptPath;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"scriptPath");
            Project project = debugProcess.getSession().getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"debugProcess.session.project");
            VirtualFile virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(string7, project);
            if (virtualFile != null) {
                void $receiver$iv6;
                VirtualFile fs = virtualFile;
                VirtualFile it = (VirtualFile)$receiver$iv6;
                String string8 = it.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"it.path");
                path = SourceMapLoaderKt.regularFile(string8);
            } else {
                path = null;
            }
        }
        if (path == null) {
            return null;
        }
        Path path2 = path;
        String url = SourceMapLoaderKt.getSourceMapUrl(path2);
        if (url == null) {
            Path mapPath = path2.getParent().resolve(path2.getFileName() + ".map");
            if (Files.isRegularFile(mapPath, new LinkOption[0]) && Files.getLastModifiedTime(mapPath, new LinkOption[0]).toMillis() + (long)100 >= Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis()) {
                return JavaScriptDebugProcess.decodeSourceMap$default(debugProcess, SourceMapLoaderKt.loadFile(mapPath), script.getUrl(), true, script, false, 16, null);
            }
            return null;
        }
        CharSequence mapPath = url;
        if ($receiver$iv.length() == 0) {
            return null;
        }
        if (URLUtil.isDataUri((String)url)) {
            return SourceMapLoaderKt.loadFromDataUri(debugProcess, script, url);
        }
        return SourceMapLoaderKt.decodeSourceMap(path2.getParent().resolve(url), debugProcess, script);
    }

    private static final SourceMap decodeLocalSourceMap(String path, Script script, JavaScriptDebugProcess<?> debugProcess) {
        return SourceMapLoaderKt.decodeSourceMap(Paths.get(path, new String[0]), debugProcess, script);
    }

    private static final SourceMap decodeSourceMap(Path $receiver, JavaScriptDebugProcess<?> debugProcess, Script script) {
        SourceMap sourceMap;
        if (Files.isRegularFile($receiver, new LinkOption[0])) {
            CharSequence $receiver$iv = SourceMapLoaderKt.loadFile($receiver.normalize());
            CharSequence it = $receiver$iv;
            Url url = Urls.newLocalFileUrl((String)((Object)$receiver).toString());
            Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"Urls.newLocalFileUrl(this.toString())");
            sourceMap = JavaScriptDebugProcess.decodeSourceMap$default(debugProcess, it, url, true, script, false, 16, null);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    private static final SourceMap loadFromDataUri(JavaScriptDebugProcess<?> debugProcess, Script script, String url) {
        CharSequence sourceMapData;
        CharSequence charSequence = SourceMapLoaderKt.loadFromDataUri(url, script.getUrl(), debugProcess.getSession());
        if (charSequence == null) {
            charSequence = null;
        }
        CharSequence charSequence2 = sourceMapData = charSequence;
        if (charSequence2 == null) {
            Intrinsics.throwNpe();
        }
        return JavaScriptDebugProcess.decodeSourceMap$default(debugProcess, charSequence2, script.getUrl(), true, script, false, 16, null);
    }

    @Nullable
    public static final Path regularFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path $receiver$iv = Paths.get(path, new String[0]);
        Path it = $receiver$iv;
        return Files.isRegularFile(it, new LinkOption[0]) ? it : (Path)null;
    }

    @Nullable
    public static final SourceMap findSourceMap(@NotNull Url parsedUrl, @NotNull Script script, @NotNull JavaScriptDebugProcess<?> debugProcess) {
        SourceMap sourceMap;
        Intrinsics.checkParameterIsNotNull((Object)parsedUrl, (String)"parsedUrl");
        Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        if (parsedUrl.isInLocalFileSystem()) {
            String string = parsedUrl.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsedUrl.path");
            return SourceMapLoaderKt.decodeLocalSourceMap(string, script, debugProcess);
        }
        if (!Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"http") && !Intrinsics.areEqual((Object)parsedUrl.getScheme(), (Object)"https")) {
            CommandProcessorKt.getLOG().warn("Cannot load source map from '" + parsedUrl + "': scheme " + parsedUrl.getScheme() + " is not supported");
            return null;
        }
        CharSequence charSequence = SourceMapLoaderKt.loadRemoteSourceMapData(parsedUrl);
        if (charSequence != null) {
            CharSequence $receiver$iv = charSequence;
            CharSequence it = $receiver$iv;
            sourceMap = JavaScriptDebugProcess.decodeSourceMap$default(debugProcess, it, parsedUrl, true, script, false, 16, null);
        } else {
            sourceMap = null;
        }
        return sourceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final CharSequence loadRemoteSourceMapData(Url parsedUrl) {
        void $receiver$iv;
        CharSequence charSequence;
        long start2 = System.nanoTime();
        String url = parsedUrl.toExternalForm();
        try {
            charSequence = (CharSequence)Request.Get((String)url).connectTimeout(HttpConfigurable.CONNECTION_TIMEOUT).socketTimeout(HttpConfigurable.READ_TIMEOUT).execute().handleResponse((ResponseHandler)loadRemoteSourceMapData.1.INSTANCE);
        }
        catch (Exception e222) {
            void $receiver$iv2;
            try {
                CommandProcessorKt.getLOG().error((Throwable)e222);
            }
            catch (Throwable throwable) {
                void $receiver$iv3;
                Logger $i$a$2 = CommandProcessorKt.getLOG();
                if (!$receiver$iv3.isDebugEnabled()) throw throwable;
                void var8_11 = $receiver$iv3;
                String string = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
                String string2 = string;
                var8_11.debug(string2);
                throw throwable;
            }
            Logger e222 = CommandProcessorKt.getLOG();
            if (!$receiver$iv2.isDebugEnabled()) return null;
            void var8_10 = $receiver$iv2;
            String string = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
            String string3 = string;
            var8_10.debug(string3);
            return null;
        }
        Logger logger = CommandProcessorKt.getLOG();
        if (!$receiver$iv.isDebugEnabled()) return charSequence;
        void var8_9 = $receiver$iv;
        String string = String.format("Load " + url + " took %d ms", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start2));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(\u2026stem.nanoTime() - start))");
        String string4 = string;
        var8_9.debug(string4);
        return charSequence;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String getStringFromDataUri(@NotNull String dataUrl) {
        Intrinsics.checkParameterIsNotNull((Object)dataUrl, (String)"dataUrl");
        Matcher matcher = URLUtil.DATA_URI_PATTERN.matcher(StringUtil.unquoteString((String)dataUrl));
        if (matcher.matches()) {
            try {
                String string;
                String content = matcher.group(4);
                if (StringsKt.equals((String)";base64", (String)matcher.group(3), (boolean)true)) {
                    void charset$iv;
                    void $receiver$iv;
                    byte[] byArray = Base64.decode((String)content);
                    Charset charset = Charsets.UTF_8;
                    string = new String((byte[])$receiver$iv, (Charset)charset$iv);
                } else {
                    void e;
                    string = e;
                }
                return string;
            }
            catch (IllegalArgumentException e) {
                CommandProcessorKt.getLOG().warn((Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final CharSequence loadFromDataUri(@NotNull String sourceMapUrl, @NotNull Url baseFileUrl, @Nullable XDebugSession session) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)sourceMapUrl, (String)"sourceMapUrl");
        Intrinsics.checkParameterIsNotNull((Object)baseFileUrl, (String)"baseFileUrl");
        String sourceMapData = SourceMapLoaderKt.getStringFromDataUri(sourceMapUrl);
        if (sourceMapData == null) {
            Unit unit;
            String message = "Cannot decode sourcemap data URI " + baseFileUrl;
            XDebugSession xDebugSession = session;
            if (xDebugSession != null) {
                xDebugSession.reportError(message);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            CommandProcessorKt.getLOG().error(message);
            return null;
        }
        CharSequence message = sourceMapData;
        return $receiver$iv.length() == 0 ? (CharSequence)null : (CharSequence)sourceMapData;
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null)) {
            Url url2 = Urls.newFromEncoded((String)url);
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newFromEncoded(url)");
            return url2;
        }
        return SourceResolverKt.doCanonicalize((String)url, (Url)baseUrl, (boolean)true, (boolean)false);
    }

    @NotNull
    public static final CharSequence loadFile(VirtualFile $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return UtilKt.readCharSequence((InputStreamReader)new InputStreamReader($receiver.getInputStream(), $receiver.getCharset()), (int)((int)$receiver.getLength()));
    }

    @NotNull
    public static final CharSequence loadFile(File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        File $receiver$iv = $receiver;
        InputStream inputStream = new FileInputStream($receiver$iv);
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        if (var4_4 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        return UtilKt.readCharSequence((InputStreamReader)new InputStreamReader(inputStream, charset), (int)((int)$receiver.length()));
    }

    @NotNull
    public static final CharSequence loadFile(Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        InputStream inputStream = Files.newInputStream($receiver, new OpenOption[0]);
        Charset charset = null;
        boolean bl = true;
        Object var4_4 = null;
        if (var4_4 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reader");
        }
        if (bl & true) {
            charset = Charsets.UTF_8;
        }
        return UtilKt.readCharSequence((InputStreamReader)new InputStreamReader(inputStream, charset), (int)((int)Files.size($receiver)));
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            if (file.isInLocalFileSystem()) {
                Path path = Paths.get(file.getPath(), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(file.path)");
                return SourceMapLoaderKt.getSourceMapUrl(path);
            }
            CharSequence charSequence = SourceMapLoaderKt.loadFile(file);
            Pattern pattern = REFERENCE_PATTERN_FILE;
            Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"REFERENCE_PATTERN_FILE");
            return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
        }
        catch (IOException e) {
            CommandProcessorKt.getLOG().error((Throwable)e);
            return null;
        }
    }

    @Nullable
    public static final String getSourceMapUrl(@NotNull Path file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CharSequence charSequence = SourceMapLoaderKt.tail(file);
        Pattern pattern = REFERENCE_PATTERN_LINE;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"REFERENCE_PATTERN_LINE");
        return SourceMapLoaderKt.getSourceMapUrl(charSequence, pattern);
    }

    private static final String getSourceMapUrl(CharSequence string, Pattern pattern) {
        if (string == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(string);
        return matcher.find() ? matcher.group(1) : (String)null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final CharSequence tail(@NotNull Path file) {
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Closeable $receiver$iv = Files.newByteChannel(file, new OpenOption[0]);
        boolean closed$iv = false;
        try {
            it = (SeekableByteChannel)$receiver$iv;
            SeekableByteChannel seekableByteChannel = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)seekableByteChannel, (String)"it");
            it = SourceMapLoaderKt.tail$default(seekableByteChannel, (int)Files.size(file), 0, 4, null);
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        return (CharSequence)it;
    }

    /*
     * Unable to fully structure code
     */
    private static final CharSequence tail(SeekableByteChannel channel, int size, int offset) {
        bufferSize = Math.min(4096, size);
        trim = true;
        stringBuilder = null;
        charBuffer = null;
        buffer = ByteBuffer.allocate(bufferSize);
        position = offset + (size - bufferSize);
        while (position >= offset) {
            block12: {
                channel.position(position);
                for (count = 0; count < bufferSize && (n = channel.read(buffer)) > 0; count += n) {
                }
                v0 = RangesKt.downTo((int)(buffer.position() - 1), (int)0);
                n = v0.getFirst();
                var11_11 = v0.getLast();
                var12_12 = v0.getStep();
                v1 = n;
                v2 = var11_11;
                if (!(var12_12 > 0 ? v1 <= v2 : v1 >= v2)) break block12;
                while (true) {
                    c = (char)buffer.get((int)p);
                    if (!trim) ** GOTO lbl27
                    if (c == '\n' || c == '\r') {
                        buffer.limit((int)p);
                    } else {
                        trim = false;
lbl27:
                        // 2 sources

                        if (c == '\n') {
                            buffer.position((int)(p + true));
                            if (charBuffer == null) {
                                charBuffer = CharBuffer.allocate(buffer.remaining());
                            }
                            v3 = buffer;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"buffer");
                            v4 = charBuffer;
                            if (v4 == null) {
                                Intrinsics.throwNpe();
                            }
                            SourceMapLoaderKt.decodeString(v3, v4);
                            return stringBuilder == null ? (CharSequence)charBuffer : (CharSequence)stringBuilder.insert(0, charBuffer);
                        }
                    }
                    if (p == var11_11) break;
                    p += var12_12;
                }
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(bufferSize * 2);
            }
            if (charBuffer == null) {
                charBuffer = CharBuffer.allocate(bufferSize);
            }
            buffer.position(0);
            v5 = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"buffer");
            v6 = charBuffer;
            if (v6 == null) {
                Intrinsics.throwNpe();
            }
            SourceMapLoaderKt.decodeString(v5, v6);
            stringBuilder.insert(0, charBuffer);
            buffer.clear();
            charBuffer.clear();
            if (position == 0) break;
            if (position < bufferSize) {
                bufferSize = position;
                buffer.limit(position);
                position = 0;
                continue;
            }
            position -= bufferSize;
        }
        return null;
    }

    static /* bridge */ /* synthetic */ CharSequence tail$default(SeekableByteChannel seekableByteChannel, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tail");
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return SourceMapLoaderKt.tail(seekableByteChannel, n, n2);
    }

    private static final void decodeString(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CharsetDecoder decoder = CharsetUtil.getDecoder((Charset)CharsetToolkit.UTF8_CHARSET);
        CoderResult coderResult = decoder.decode(byteBuffer, charBuffer, true);
        if (!coderResult.isUnderflow()) {
            coderResult.throwException();
        }
        if (!(coderResult = decoder.flush(charBuffer)).isUnderflow()) {
            coderResult.throwException();
        }
        charBuffer.flip();
    }

    static {
        REFERENCE_LINE = REFERENCE_LINE;
        REFERENCE_PATTERN_FILE = Pattern.compile("[" + "\\" + "r" + "\\" + "n]" + REFERENCE_LINE);
        REFERENCE_PATTERN_LINE = Pattern.compile(REFERENCE_LINE);
    }
}

