/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap.visualizer.actions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.sourcemap.SourceMap;

public final class AddSourceContentsAction
extends BaseSourceMapAction {
    private static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = new NotificationGroup("Source Map", NotificationDisplayType.BALLOON, true);
            if (notificationGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/AddSourceContentsAction$1", "compute"));
            }
            return notificationGroup;
        }
    };
    private static final String SOURCES_CONTENT = "sourcesContent";

    @Override
    protected void perform(final SourceMap sourceMap, final VirtualFile file, final Project project) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Add sources content to " + SourceMapInspector.getFileTitle(file), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/AddSourceContentsAction$2", "run"));
                }
                try {
                    Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                    InputStreamReader reader = new InputStreamReader(file.getInputStream(), CharsetToolkit.UTF8_CHARSET);
                    Map map = (Map)gson.fromJson((Reader)reader, Map.class);
                    reader.close();
                    if (map.containsKey(AddSourceContentsAction.SOURCES_CONTENT)) {
                        ((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification("Source Map has already sources content", MessageType.INFO).notify(project);
                        return;
                    }
                    List sources = (List)map.get("sources");
                    String[] sourcesContent = new String[sources.size()];
                    for (int i = 0; i < sources.size(); ++i) {
                        VirtualFile sourceFile = SourceMapInspector.getSourceFile(sourceMap.getSources()[i]);
                        BaseSourceMapAction.LOG.assertTrue(sourceFile != null);
                        sourcesContent[i] = VfsUtilCore.loadText((VirtualFile)sourceFile);
                    }
                    map.put(AddSourceContentsAction.SOURCES_CONTENT, Arrays.asList(sourcesContent));
                    String path = file.getPath();
                    int index = path.lastIndexOf(".map");
                    String ext = ".source.map";
                    File outFile = new File((index > -1 ? path.substring(0, index) : path) + ext);
                    try (OutputStreamWriter stream = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), CharsetToolkit.UTF8_CHARSET);){
                        gson.toJson((Object)map, (Appendable)stream);
                    }
                    LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outFile);
                    ((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification("Source Map with sources content created: " + outFile.getName(), MessageType.INFO).notify(project);
                }
                catch (IOException e) {
                    BaseSourceMapAction.LOG.error((Throwable)e);
                }
            }
        });
    }
}

