/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger.sourcemap.visualizer.actions;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.jetbrains.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

public final class VisualizeSourceMapAction
extends BaseSourceMapAction {
    @Override
    protected void perform(final @NotNull SourceMap map, @NotNull VirtualFile file, final @NotNull Project project) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction", "perform"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction", "perform"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction", "perform"));
        }
        VirtualFile generatedFile = null;
        if (map.getOutFile() != null) {
            generatedFile = file.getParent().findFileByRelativePath(map.getOutFile());
            if (generatedFile == null) {
                generatedFile = LocalFileFinder.findFile((String)map.getOutFile());
            }
        } else {
            String fileName = file.getName();
            if (fileName.endsWith(".map")) {
                generatedFile = file.getParent().findChild(fileName.substring(0, fileName.length() - ".map".length()));
            }
        }
        if (generatedFile == null) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)JavaScriptFileType.INSTANCE);
            descriptor.setTitle("Select Generated File");
            FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)file.getParent(), (Consumer)new Consumer<VirtualFile>(){

                public void consume(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction$1", "consume"));
                    }
                    VisualizeSourceMapAction.visualize(map, file, null, project, null);
                }
            });
        } else {
            VisualizeSourceMapAction.visualize(map, generatedFile, null, project, null);
        }
    }

    public static void visualize(@NotNull SourceMap map, @NotNull VirtualFile generatedFile, @Nullable Url sourceUrl, @NotNull Project project, @Nullable SourceMapInspector.SourceFileFinder sourceFileFinder) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction", "visualize"));
        }
        if (generatedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generatedFile", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction", "visualize"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/javascript/debugger/sourcemap/visualizer/actions/VisualizeSourceMapAction", "visualize"));
        }
        String dimensionKey = "SourceMapInspector.frame";
        if (DimensionService.getInstance().getSize(dimensionKey, project) == null) {
            Dimension frameSize = WindowManager.getInstance().getFrame(project).getSize();
            DimensionService.getInstance().setSize(dimensionKey, frameSize, project);
        }
        DialogBuilder dialogBuilder = new DialogBuilder(project);
        SourceMapInspector mapInspector = new SourceMapInspector(map, generatedFile, project, (Disposable)dialogBuilder, sourceFileFinder);
        dialogBuilder.title("Source visualization of " + mapInspector.generatedEditor.getVirtualFile().getName()).centerPanel(mapInspector.createMainComponent(sourceUrl)).dimensionKey(dimensionKey).showNotModal();
    }
}

