/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.diagnostic.ITNReporter;
import com.intellij.ide.plugins.PluginManagerMain;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.AddDomElementQuickFix;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import com.intellij.util.xml.highlighting.RemoveDomElementQuickFix;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.AddToGroup;
import org.jetbrains.idea.devkit.dom.Anchor;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.Extensions;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.IdeaVersion;
import org.jetbrains.idea.devkit.dom.Vendor;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PluginXmlDomInspection
extends BasicDomElementsInspection<IdeaPlugin> {
    public PluginXmlDomInspection() {
        super(IdeaPlugin.class, new Class[0]);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = DevKitBundle.message("inspections.group.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Plugin.xml Validity" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection", "getDisplayName"));
        }
        return "Plugin.xml Validity";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("PluginXmlValidity" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection", "getShortName"));
        }
        return "PluginXmlValidity";
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        super.checkDomElement(element, holder, helper);
        if (element instanceof IdeaPlugin) {
            PluginXmlDomInspection.checkJetBrainsPlugin((IdeaPlugin)element, holder);
        } else if (element instanceof Extension) {
            PluginXmlDomInspection.annotateExtension((Extension)element, holder);
        } else if (element instanceof Vendor) {
            PluginXmlDomInspection.annotateVendor((Vendor)element, holder);
        } else if (element instanceof IdeaVersion) {
            PluginXmlDomInspection.annotateIdeaVersion((IdeaVersion)element, holder);
        } else if (element instanceof Extensions) {
            PluginXmlDomInspection.annotateExtensions((Extensions)element, holder);
        } else if (element instanceof AddToGroup) {
            PluginXmlDomInspection.annotateAddToGroup((AddToGroup)element, holder);
        }
    }

    private static void checkJetBrainsPlugin(IdeaPlugin ideaPlugin, DomElementAnnotationHolder holder) {
        Module module = ideaPlugin.getModule();
        if (module == null) {
            return;
        }
        if (!PsiUtil.isIdeaProject(module.getProject())) {
            return;
        }
        String pluginId = ideaPlugin.getPluginId();
        if (pluginId == null || pluginId.equals("com.intellij")) {
            return;
        }
        XmlTag xmlTag = ideaPlugin.getXmlTag();
        if (xmlTag == null) {
            return;
        }
        VirtualFile virtualFile = xmlTag.getContainingFile().getVirtualFile();
        if (virtualFile == null || !ModuleRootManager.getInstance((Module)module).getFileIndex().isUnderSourceRootOfType(virtualFile, JavaModuleSourceRootTypes.PRODUCTION)) {
            return;
        }
        Vendor vendor = (Vendor)ContainerUtil.getFirstItem(ideaPlugin.getVendors());
        if (vendor == null) {
            holder.createProblem((DomElement)DomUtil.getFileElement((DomElement)ideaPlugin), "Plugin developed as a part of IntelliJ IDEA project should specify 'JetBrains' as its vendor", new LocalQuickFix[]{new SpecifyJetBrainsAsVendorQuickFix()});
        } else if (!PluginManagerMain.isDevelopedByJetBrains((String)vendor.getValue())) {
            holder.createProblem((DomElement)vendor, "Plugin developed as a part of IntelliJ IDEA project should include 'JetBrains' as one of its vendors", new LocalQuickFix[0]);
        }
    }

    private static void annotateExtensions(Extensions extensions, DomElementAnnotationHolder holder) {
        GenericAttributeValue<IdeaPlugin> xmlnsAttribute = extensions.getXmlns();
        if (DomUtil.hasXml(xmlnsAttribute)) {
            holder.createProblem(xmlnsAttribute, ProblemHighlightType.LIKE_DEPRECATED, "Use defaultExtensionNs instead", null, new LocalQuickFix[0]).highlightWholeElement();
            return;
        }
        if (!DomUtil.hasXml(extensions.getDefaultExtensionNs())) {
            holder.createProblem((DomElement)extensions, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, "Specify defaultExtensionNs=\"com.intellij\" explicitly", null, new LocalQuickFix[]{new AddDomElementQuickFix<GenericAttributeValue>(extensions.getDefaultExtensionNs()){

                public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$1", "applyFix"));
                    }
                    if (descriptor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$1", "applyFix"));
                    }
                    super.applyFix(project, descriptor);
                    ((GenericAttributeValue)this.myElement).setStringValue("com.intellij");
                }
            }});
        }
    }

    private static void annotateIdeaVersion(IdeaVersion ideaVersion, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightNotUsedAnymore(ideaVersion.getMin(), holder);
        PluginXmlDomInspection.highlightNotUsedAnymore(ideaVersion.getMax(), holder);
    }

    private static void annotateExtension(Extension extension, DomElementAnnotationHolder holder) {
        PsiClass value;
        ExtensionPoint extensionPoint = extension.getExtensionPoint();
        if (extensionPoint == null) {
            return;
        }
        GenericAttributeValue<PsiClass> interfaceAttribute = extensionPoint.getInterface();
        if (DomUtil.hasXml(interfaceAttribute) && (value = (PsiClass)interfaceAttribute.getValue()) != null && value.isDeprecated()) {
            holder.createProblem((DomElement)extension, ProblemHighlightType.LIKE_DEPRECATED, "Deprecated EP '" + extensionPoint.getEffectiveQualifiedName() + "'", null, new LocalQuickFix[0]);
            return;
        }
        if ("com.intellij.errorHandler".equals(extensionPoint.getEffectiveQualifiedName()) && extension.exists()) {
            Vendor vendor;
            IdeaPlugin plugin;
            String implementation = extension.getXmlTag().getAttributeValue("implementation");
            if (ITNReporter.class.getName().equals(implementation) && (plugin = (IdeaPlugin)extension.getParentOfType(IdeaPlugin.class, true)) != null && (vendor = (Vendor)ContainerUtil.getFirstItem(plugin.getVendors())) != null && PluginManagerMain.isDevelopedByJetBrains((String)vendor.getValue())) {
                RemoveDomElementQuickFix fix = new RemoveDomElementQuickFix((DomElement)extension);
                holder.createProblem((DomElement)extension, ProblemHighlightType.LIKE_UNUSED_SYMBOL, "Exceptions from plugins developed by JetBrains are reported via ITNReporter automatically, there is no need to specify it explicitly", null, new LocalQuickFix[]{fix}).highlightWholeElement();
            }
        }
        List descriptions = extension.getGenericInfo().getAttributeChildrenDescriptions();
        for (DomAttributeChildDescription attributeDescription : descriptions) {
            PsiField psiField;
            PsiElement declaration;
            XmlAttributeValue value2;
            GenericAttributeValue attributeValue = attributeDescription.getDomAttributeValue((DomElement)extension);
            if (attributeValue == null || !DomUtil.hasXml((DomElement)attributeValue)) continue;
            if ("icon".equals(attributeDescription.getXmlElementName()) && (value2 = attributeValue.getXmlAttributeValue()) != null) {
                for (PsiReference reference : value2.getReferences()) {
                    if (reference.resolve() != null) continue;
                    holder.createResolveProblem((GenericDomValue)attributeValue, reference);
                }
            }
            if (!((declaration = attributeDescription.getDeclaration(extension.getManager().getProject())) instanceof PsiField) || !(psiField = (PsiField)declaration).isDeprecated()) continue;
            holder.createProblem((DomElement)attributeValue, ProblemHighlightType.LIKE_DEPRECATED, "Deprecated attribute '" + attributeDescription.getName() + "'", null, new LocalQuickFix[0]).highlightWholeElement();
        }
    }

    private static void annotateVendor(Vendor vendor, DomElementAnnotationHolder holder) {
        PluginXmlDomInspection.highlightNotUsedAnymore(vendor.getLogo(), holder);
    }

    private static void highlightNotUsedAnymore(GenericAttributeValue attributeValue, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml((DomElement)attributeValue)) {
            return;
        }
        holder.createProblem((DomElement)attributeValue, ProblemHighlightType.LIKE_DEPRECATED, "Attribute '" + attributeValue.getXmlElementName() + "' not used anymore", null, new LocalQuickFix[]{new RemoveDomElementQuickFix((DomElement)attributeValue)}).highlightWholeElement();
    }

    private static void annotateAddToGroup(AddToGroup addToGroup, DomElementAnnotationHolder holder) {
        if (!DomUtil.hasXml(addToGroup.getRelativeToAction())) {
            return;
        }
        if (!DomUtil.hasXml(addToGroup.getAnchor())) {
            holder.createProblem((DomElement)addToGroup, "'anchor' must be specified with 'relative-to-action'", new LocalQuickFix[]{new AddDomElementQuickFix(addToGroup.getAnchor())});
            return;
        }
        Anchor value = (Anchor)((Object)addToGroup.getAnchor().getValue());
        if (value == Anchor.after || value == Anchor.before) {
            return;
        }
        holder.createProblem(addToGroup.getAnchor(), "Must use '" + (Object)((Object)Anchor.after) + "'|'" + (Object)((Object)Anchor.before) + "' with 'relative-to-action'", new LocalQuickFix[0]);
    }

    private static class SpecifyJetBrainsAsVendorQuickFix
    implements LocalQuickFix {
        private SpecifyJetBrainsAsVendorQuickFix() {
        }

        @Nls
        @NotNull
        public String getName() {
            if ("Specify JetBrains as vendor" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$SpecifyJetBrainsAsVendorQuickFix", "getName"));
            }
            return "Specify JetBrains as vendor";
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$SpecifyJetBrainsAsVendorQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$SpecifyJetBrainsAsVendorQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/idea/devkit/inspections/PluginXmlDomInspection$SpecifyJetBrainsAsVendorQuickFix", "applyFix"));
            }
            PsiFile file = descriptor.getPsiElement().getContainingFile();
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement((XmlFile)file, IdeaPlugin.class);
            if (fileElement != null) {
                IdeaPlugin root = (IdeaPlugin)fileElement.getRootElement();
                XmlTag after = SpecifyJetBrainsAsVendorQuickFix.getLastSubTag(root, new DomElement[]{root.getId(), (DomElement)ContainerUtil.getLastItem(root.getDescriptions()), (DomElement)ContainerUtil.getLastItem(root.getVersions()), root.getName()});
                XmlTag rootTag = root.getXmlTag();
                XmlTag vendorTag = rootTag.createChildTag("vendor", rootTag.getNamespace(), "JetBrains", false);
                if (after == null) {
                    rootTag.addSubTag(vendorTag, true);
                } else {
                    rootTag.addAfter((PsiElement)vendorTag, (PsiElement)after);
                }
            }
        }

        private static XmlTag getLastSubTag(IdeaPlugin root, DomElement ... children) {
            HashSet<XmlTag> childrenTags = new HashSet<XmlTag>();
            for (DomElement child : children) {
                if (child == null) continue;
                childrenTags.add(child.getXmlTag());
            }
            XmlTag[] subTags = root.getXmlTag().getSubTags();
            for (int i = subTags.length - 1; i >= 0; --i) {
                if (!childrenTags.contains(subTags[i])) continue;
                return subTags[i];
            }
            return null;
        }
    }
}

