/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation.valueresolvers;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.tapestry.core.TapestryProject;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ComponentResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.LiteralResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.MessageResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ResolvedValue;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValidateResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverContext;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.PropResolver;
import org.apache.commons.chain.impl.ChainBase;
import org.jetbrains.annotations.Nullable;

public class ValueResolverChain
extends ChainBase {
    private static final Logger _logger = Logger.getInstance(ValueResolverChain.class);
    private static final ValueResolverChain _me = new ValueResolverChain();

    private ValueResolverChain() {
        this.addCommand(new PropResolver());
        this.addCommand(new LiteralResolver());
        this.addCommand(new ComponentResolver());
        this.addCommand(new ValidateResolver());
        this.addCommand(new MessageResolver());
    }

    public static ValueResolverChain getInstance() {
        return _me;
    }

    @Nullable
    public ResolvedValue resolve(TapestryProject project, IJavaClassType contextClass, String value, String defaultPrefix) throws Exception {
        ValueResolverContext context = new ValueResolverContext(project, contextClass, value, defaultPrefix);
        try {
            this.execute(context);
        }
        catch (Exception ex) {
            if (!(ex instanceof ProcessCanceledException)) {
                _logger.error((Throwable)ex);
            }
            throw ex;
        }
        if (context.getResultType() != null) {
            return new ResolvedValue(context.getResultType(), context.getResultCodeBind());
        }
        return null;
    }
}

