/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.intellij.util;

import com.intellij.facet.FacetManager;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.tapestry.core.java.IJavaType;
import com.intellij.tapestry.intellij.core.java.IntellijJavaArrayType;
import com.intellij.tapestry.intellij.core.java.IntellijJavaClassType;
import com.intellij.tapestry.intellij.core.java.IntellijJavaPrimitiveType;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaUtils {
    public static boolean isModuleNode(AnActionEvent event) {
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        Module module = (Module)event.getData(LangDataKeys.MODULE_CONTEXT);
        return project != null && module != null;
    }

    public static List<WebRoot> findWebRoots(Module module) {
        ArrayList<WebRoot> finalWebRoots = new ArrayList<WebRoot>();
        WebFacet webFacet = IdeaUtils.getWebFacet(module);
        if (webFacet == null) {
            return finalWebRoots;
        }
        List webRoots = webFacet.getWebRoots();
        for (WebRoot webRoot : webRoots) {
            if (webRoot.getRelativePath().equals("/WEB-INF")) continue;
            finalWebRoots.add(webRoot);
        }
        return finalWebRoots;
    }

    @Nullable
    public static PsiDirectory findOrCreateDirectoryForPackage(PsiDirectory sourceDirectory, String packageName) throws IncorrectOperationException {
        PsiDirectory finalDirectory = sourceDirectory;
        StringTokenizer packageTokens = new StringTokenizer(packageName, ".", false);
        while (packageTokens.hasMoreTokens()) {
            String currentToken = packageTokens.nextToken();
            if (finalDirectory.findSubdirectory(currentToken) != null) {
                finalDirectory = finalDirectory.findSubdirectory(currentToken);
                continue;
            }
            finalDirectory = finalDirectory.createSubdirectory(currentToken);
        }
        return finalDirectory;
    }

    public static boolean isWebRoot(Module module, VirtualFile directory) {
        WebFacet webFacet = IdeaUtils.getWebFacet(module);
        if (webFacet == null) {
            return false;
        }
        List webRoots = webFacet.getWebRoots();
        for (WebRoot webRoot : webRoots) {
            if (!webRoot.getFile().getPath().equals(directory.getPath())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiClass findPublicClass(PsiFile psiFile) {
        return psiFile instanceof PsiClassOwner ? IdeaUtils.findPublicClass(((PsiClassOwner)psiFile).getClasses()) : null;
    }

    @Nullable
    public static PsiClass findPublicClass(PsiClass[] classes) {
        for (PsiClass clazz : classes) {
            PsiModifierList modifierList;
            if (!clazz.isValid() || (modifierList = clazz.getModifierList()) == null || !modifierList.hasModifierProperty("public") || clazz.isEnum() || clazz.isInterface() || !PsiUtil.hasDefaultConstructor((PsiClass)clazz)) continue;
            return clazz;
        }
        return null;
    }

    public static void runWriteCommand(Project project, final Runnable runnable) {
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(runnable);
            }
        }, "", null);
    }

    @Nullable
    public static <T> T findFirstParent(DefaultMutableTreeNode node, Class<T> clazz) {
        for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
            if (!clazz.isInstance(parent.getUserObject())) continue;
            return (T)parent;
        }
        return null;
    }

    public static IJavaType createJavaTypeFromPsiType(Module module, PsiType type) {
        if (type instanceof PsiClassType) {
            PsiClass psiClass = null;
            try {
                psiClass = ((PsiClassType)type).resolve();
                if (psiClass instanceof PsiTypeParameter) {
                    psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("java.lang.Object", GlobalSearchScope.moduleWithLibrariesScope((Module)module));
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (psiClass != null) {
                return new IntellijJavaClassType(module, psiClass.getContainingFile());
            }
            return null;
        }
        if (type instanceof PsiPrimitiveType) {
            return new IntellijJavaPrimitiveType((PsiPrimitiveType)type);
        }
        if (type instanceof PsiArrayType) {
            return new IntellijJavaArrayType(module, (PsiArrayType)type);
        }
        return null;
    }

    @Nullable
    public static WebFacet getWebFacet(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/tapestry/intellij/util/IdeaUtils", "getWebFacet"));
        }
        return (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID);
    }

    @Nullable
    public static PsiPackage getPackage(@Nullable PsiElement psiElement) {
        if (psiElement instanceof PsiDirectory) {
            Project project = psiElement.getProject();
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            String packageName = projectFileIndex.getPackageNameByDirectory(((PsiDirectory)psiElement).getVirtualFile());
            return packageName == null ? null : JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        }
        return psiElement instanceof PsiPackage ? (PsiPackage)psiElement : null;
    }

    @Nullable
    public static XmlElement getNameElement(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/tapestry/intellij/util/IdeaUtils", "getNameElement"));
        }
        PsiElement child = tag.getFirstChild();
        while (child != null) {
            if (!((child = child.getNextSibling()) instanceof XmlElement)) continue;
            return (XmlElement)child;
        }
        return null;
    }

    @Nullable
    public static XmlElement getNameElementClosing(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/tapestry/intellij/util/IdeaUtils", "getNameElementClosing"));
        }
        PsiElement child = tag.getLastChild();
        while (child != null) {
            if (!((child = child.getPrevSibling()) instanceof XmlElement)) continue;
            return (XmlElement)child;
        }
        return null;
    }
}

