/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import icons.UmlIcons;
import java.util.List;
import javax.swing.Icon;

public class UmlAddNoteAction
extends DiagramAction {
    public UmlAddNoteAction() {
        super("Note", "", UmlIcons.AddNote);
    }

    public void perform(AnActionEvent e) {
        DiagramDataModel model = UmlAddNoteAction.getDataModel((AnActionEvent)e);
        DiagramNode node = (DiagramNode)UmlAddNoteAction.getSelectedNodes((AnActionEvent)e).get(0);
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        String description = Messages.showMultilineInputDialog((Project)project, (String)"Note text", (String)"Add a Note", (String)"", (Icon)Messages.getQuestionIcon(), (InputValidator)new NonEmptyInputValidator());
        if (description != null && description.length() > 0) {
            DiagramNoteNode note = model.addNote(node, description);
            DiagramBuilder builder = UmlAddNoteAction.getBuilder((AnActionEvent)e);
            assert (builder != null);
            builder.updateGraph();
            if (note != null) {
                Node noteNode = builder.getNode((DiagramNode)note);
                NodeRealizer realizer = builder.getGraph().getRealizer(noteNode);
                NodeRealizer target = builder.getGraph().getRealizer(builder.getNode(note.getIdentifyingElement()));
                realizer.setCenterX(target.getCenterX());
                realizer.setY(target.getY() - realizer.getHeight() - 20.0);
            }
            builder.updateGraph();
            builder.notifyOtherBuilders();
        }
    }

    public void update(AnActionEvent e) {
        List nodes = UmlAddNoteAction.getSelectedNodes((AnActionEvent)e);
        if (nodes.size() == 1) {
            DiagramNode node = (DiagramNode)nodes.get(0);
            DiagramDataModel model = UmlAddNoteAction.getDataModel((AnActionEvent)e);
            if (model != null && !(node instanceof DiagramNoteNode) && !model.getNotes().containsKey(node)) {
                e.getPresentation().setEnabled(true);
                return;
            }
        }
        e.getPresentation().setEnabled(false);
    }

    public String getActionName() {
        return "Add Note";
    }
}

